/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QueryReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.InvocationScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class QueryValidator
implements SourceValidator<N2oQuery>,
SourceClassAware {
    public void validate(N2oQuery n2oQuery, SourceProcessor p) {
        if (Objects.nonNull(n2oQuery.getObjectId())) {
            ValidationUtils.checkForExistsObject(n2oQuery.getObjectId(), String.format("\u0412\u044b\u0431\u043e\u0440\u043a\u0430 %s", ValidationUtils.getIdOrEmptyString(n2oQuery.getId())), p);
        }
        if (Objects.nonNull(n2oQuery.getFields())) {
            p.safeStreamOf((Object[])n2oQuery.getFields()).forEach(field -> QueryValidator.checkFieldIdExistence(field, n2oQuery.getId(), p));
            this.checkForUniqueFields(n2oQuery.getFields(), n2oQuery.getId(), p);
        }
        if (Objects.nonNull(n2oQuery.getFilters())) {
            this.checkForUniqueFilterFields(n2oQuery.getFilters(), n2oQuery.getId());
            this.checkForExistsFiltersInSelections(n2oQuery);
        }
        this.checkInvocations(n2oQuery, p);
        this.checkSwitchCase(n2oQuery.getFields());
    }

    public static void checkFieldIdExistence(AbstractField field, String queryId, SourceProcessor p) {
        if (field instanceof QueryReferenceField) {
            p.safeStreamOf((Object[])((QueryReferenceField)field).getFields()).forEach(childField -> QueryValidator.checkFieldIdExistence(childField, queryId, p));
        }
        p.checkIdExistence((IdAware)field, String.format("\u041e\u0434\u043d\u043e \u0438\u0437 \u043f\u043e\u043b\u0435\u0439 \u0432\u044b\u0431\u043e\u0440\u043a\u0438 %s \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 'id'", ValidationUtils.getIdOrEmptyString(queryId)));
    }

    private void checkForUniqueFields(AbstractField[] fields, String queryId, SourceProcessor p) {
        p.checkIdsUnique((IdAware[])fields, String.format("\u041f\u043e\u043b\u0435 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '%s'", "%s", queryId));
    }

    private void checkForUniqueFilterFields(N2oQuery.Filter[] filters, String queryId) {
        HashSet<String> filterFields = new HashSet<String>();
        for (N2oQuery.Filter filter : filters) {
            if (!Objects.nonNull(filter.getFilterId()) || filterFields.add(filter.getFilterId())) continue;
            throw new N2oMetadataValidationException(String.format("\u0424\u0438\u043b\u044c\u0442\u0440 %s \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f", ValidationUtils.getIdOrEmptyString(filter.getFilterId()), ValidationUtils.getIdOrEmptyString(queryId)));
        }
    }

    private void checkForExistsFiltersInSelections(N2oQuery query) {
        Set<String> filterFields = Arrays.stream(query.getFilters()).map(N2oQuery.Filter::getFilterId).collect(Collectors.toSet());
        this.checkFiltersExistInSelectionType(query.getLists(), filterFields, "list", query.getId());
        this.checkFiltersExistInSelectionType(query.getUniques(), filterFields, "unique", query.getId());
        this.checkFiltersExistInSelectionType(query.getCounts(), filterFields, "count", query.getId());
    }

    private void checkFiltersExistInSelectionType(N2oQuery.Selection[] selections, Set<String> filterFields, String selectionType, String queryId) {
        if (Objects.nonNull(selections)) {
            for (N2oQuery.Selection s : selections) {
                if (!Objects.nonNull(s.getFilters())) continue;
                for (String filter : s.getFilters()) {
                    if (filterFields.contains(filter)) continue;
                    throw new N2oMetadataValidationException(String.format("<%s> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0444\u0438\u043b\u044c\u0442\u0440 %s \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s", selectionType, ValidationUtils.getIdOrEmptyString(filter), ValidationUtils.getIdOrEmptyString(queryId)));
                }
            }
        }
    }

    private void checkInvocations(N2oQuery query, SourceProcessor p) {
        if (Objects.nonNull(query.getLists())) {
            this.validateInvocations(query.getLists(), query.getId(), p);
        }
        if (Objects.nonNull(query.getCounts())) {
            this.validateInvocations(query.getCounts(), query.getId(), p);
        }
        if (Objects.nonNull(query.getUniques())) {
            this.validateInvocations(query.getUniques(), query.getId(), p);
        }
    }

    private void validateInvocations(N2oQuery.Selection[] selections, String queryId, SourceProcessor p) {
        InvocationScope invocationScope = new InvocationScope();
        invocationScope.setQueryId(queryId);
        Arrays.stream(selections).map(N2oQuery.Selection::getInvocation).filter(Objects::nonNull).forEach(invocation -> p.validate((Source)invocation, new Object[]{invocationScope}));
    }

    private void checkSwitchCase(AbstractField[] fields) {
        if (Objects.isNull(fields)) {
            return;
        }
        for (AbstractField field : fields) {
            if (field instanceof QueryReferenceField) {
                this.checkSwitchCase(((QueryReferenceField)field).getFields());
            }
            if (!(field instanceof QuerySimpleField) || !Objects.nonNull(((QuerySimpleField)field).getN2oSwitch())) continue;
            N2oSwitch n2oSwitch = ((QuerySimpleField)field).getN2oSwitch();
            if (n2oSwitch.getCases().isEmpty()) {
                throw new N2oMetadataValidationException(String.format("\u0412 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0435 '<switch>' \u043f\u043e\u043b\u044f '%s' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 '<case>'", field.getId()));
            }
            if (n2oSwitch.getCases().containsKey("")) {
                throw new N2oMetadataValidationException(String.format("\u0412 '<case>' \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 '<switch>' \u043f\u043e\u043b\u044f '%s' \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'value' \u043f\u0443\u0441\u0442\u043e\u0439", field.getId()));
            }
            if (!n2oSwitch.getCases().containsValue("")) continue;
            throw new N2oMetadataValidationException(String.format("\u0412 '<case>' \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 '<switch>' \u043f\u043e\u043b\u044f '%s' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0435\u043b\u043e", field.getId()));
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }
}

