/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.page;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.global.view.page.N2oLeftRightPage;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.validation.standard.PageValidationUtil;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import org.springframework.stereotype.Component;

@Component
public class LeftRightPageValidator
implements SourceValidator<N2oLeftRightPage>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oLeftRightPage.class;
    }

    public void validate(N2oLeftRightPage page, SourceProcessor p) {
        Object[] datasources = page.getDatasources();
        Object[] actions = page.getActions();
        List widgets = page.getWidgets();
        PageScope pageScope = new PageScope();
        pageScope.setWidgetIds(p.safeStreamOf((Collection)widgets).map(N2oMetadata::getId).collect(Collectors.toSet()));
        ValidatorDataSourcesScope dataSourcesScope = new ValidatorDataSourcesScope(p.safeStreamOf(datasources).collect(Collectors.toMap(N2oAbstractDatasource::getId, Function.identity())));
        ValidatorDatasourceIdsScope datasourceIdsScope = new ValidatorDatasourceIdsScope(p.safeStreamOf(datasources).map(N2oAbstractDatasource::getId).collect(Collectors.toSet()));
        PageValidationUtil.fillDatasourceIdsScopeByInlineDatasource(widgets, datasourceIdsScope, p);
        MetaActions actionBarScope = new MetaActions(p.safeStreamOf(actions).collect(Collectors.toMap(ActionBar::getId, Function.identity())));
        this.validateSide(page.getLeft(), p, pageScope, datasourceIdsScope, dataSourcesScope, actionBarScope);
        this.validateSide(page.getRight(), p, pageScope, datasourceIdsScope, dataSourcesScope, actionBarScope);
    }

    private void validateSide(SourceComponent[] side, SourceProcessor p, PageScope pageScope, ValidatorDatasourceIdsScope datasourceIdsScope, ValidatorDataSourcesScope dataSourcesScope, MetaActions actionBarScope) {
        p.safeStreamOf((Object[])side).forEach(item -> p.validate((Source)item, new Object[]{pageScope, datasourceIdsScope, dataSourcesScope, actionBarScope}));
    }
}

