/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.object;

import java.util.HashMap;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oInvocationValidation;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oMandatoryValidation;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.InvocationScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class ObjectValidator
implements SourceValidator<N2oObject>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oObject.class;
    }

    public void validate(N2oObject object, SourceProcessor p) {
        InvocationScope invocationScope = new InvocationScope();
        invocationScope.setObjectId(object.getId());
        if (!ArrayUtils.isEmpty((Object[])object.getObjectFields())) {
            p.safeStreamOf((Object[])object.getObjectFields()).forEach(field -> ObjectValidator.checkFieldIdExistence(field, p, String.format("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u043f\u043e\u043b\u0435\u0439 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d 'id'", ValidationUtils.getIdOrEmptyString(object.getId()))));
            this.checkForExistsReferenceObject(object.getId(), object.getObjectFields(), p);
        }
        p.checkIdsUnique((IdAware[])object.getObjectFields(), String.format("\u041f\u043e\u043b\u0435 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 %s", "%s", ValidationUtils.getIdOrEmptyString(object.getId())));
        p.checkIdsUnique((IdAware[])object.getOperations(), String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 %s", "%s", ValidationUtils.getIdOrEmptyString(object.getId())));
        p.checkIdsUnique((IdAware[])object.getN2oValidations(), String.format("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 %s", "%s", ValidationUtils.getIdOrEmptyString(object.getId())));
        if (object.getOperations() != null) {
            this.validateOperations(object, p, invocationScope);
        }
        if (object.getN2oValidations() != null) {
            p.safeStreamOf((Object[])object.getN2oValidations()).forEach(validation -> {
                p.checkIdExistence((IdAware)validation, String.format("\u0412 \u043e\u0434\u043d\u043e\u0439 \u0438\u0437 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'id'", ValidationUtils.getIdOrEmptyString(object.getId())));
                if (validation instanceof N2oMandatoryValidation && validation.getFieldId() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 <mandatory> \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'field-id'", ValidationUtils.getIdOrEmptyString(validation.getId()), ValidationUtils.getIdOrEmptyString(object.getId())));
                }
                if (validation instanceof N2oInvocationValidation) {
                    invocationScope.setValidationId(validation.getId());
                    p.validate((Source)((N2oInvocationValidation)validation).getN2oInvocation(), new Object[]{invocationScope});
                }
            });
        }
    }

    private void validateOperations(N2oObject object, SourceProcessor p, InvocationScope invocationScope) {
        p.safeStreamOf((Object[])object.getOperations()).forEach(operation -> {
            if (operation.getId() == null) {
                throw new N2oMetadataValidationException(String.format("\u0412 \u043e\u0434\u043d\u043e\u0439 \u0438\u0437 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d 'id'", ValidationUtils.getIdOrEmptyString(object.getId())));
            }
            invocationScope.setOperationId(operation.getId());
            if (operation.getInFields() != null) {
                p.safeStreamOf((Object[])operation.getInFields()).forEach(field -> ObjectValidator.checkFieldIdExistence(field, p, String.format("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 <in> \u043f\u043e\u043b\u0435\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d 'id'", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId()))));
                this.checkForExistsReferenceObject(object.getId(), operation.getInFields(), p);
                this.checkSwitchCase(operation.getInFields());
            }
            if (operation.getOutFields() != null) {
                p.safeStreamOf((Object[])operation.getOutFields()).forEach(field -> ObjectValidator.checkFieldIdExistence(field, p, String.format("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 <out> \u043f\u043e\u043b\u0435\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d 'id'", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId()))));
                this.checkSwitchCase(operation.getOutFields());
            }
            p.checkIdsUnique((IdAware[])operation.getInFields(), String.format("\u041f\u043e\u043b\u0435 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 <in> \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s", "%s", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId())));
            p.checkIdsUnique((IdAware[])operation.getOutFields(), String.format("\u041f\u043e\u043b\u0435 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 <out> \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s", "%s", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId())));
            if (operation.getInvocation() != null) {
                p.validate((Source)operation.getInvocation(), new Object[]{invocationScope});
            }
            if (operation.getValidations() != null) {
                if (operation.getValidations().getWhiteList() != null) {
                    this.checkValidationWhiteList(object, (N2oObject.Operation)operation, p);
                }
                if (operation.getValidations().getInlineValidations() != null) {
                    p.safeStreamOf((Object[])operation.getValidations().getInlineValidations()).forEach(validation -> {
                        p.checkIdExistence((IdAware)validation, String.format("\u0412 \u043e\u0434\u043d\u043e\u0439 \u0438\u0437 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'id'", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId())));
                        if (validation instanceof N2oInvocationValidation) {
                            invocationScope.setValidationId(validation.getId());
                            p.validate((Source)((N2oInvocationValidation)validation).getN2oInvocation(), new Object[]{invocationScope});
                        }
                    });
                }
            }
            this.checkValidationSide(object.getId(), (N2oObject.Operation)operation);
        });
    }

    private void checkSwitchCase(AbstractParameter[] fields) {
        if (fields == null) {
            return;
        }
        for (AbstractParameter field : fields) {
            if (field instanceof ObjectReferenceField) {
                this.checkSwitchCase(((ObjectReferenceField)field).getFields());
            }
            if (!(field instanceof ObjectSimpleField) || ((ObjectSimpleField)field).getN2oSwitch() == null) continue;
            N2oSwitch n2oSwitch = ((ObjectSimpleField)field).getN2oSwitch();
            if (n2oSwitch.getCases().isEmpty()) {
                throw new N2oMetadataValidationException(String.format("\u0412 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0435 '<switch>' \u043f\u043e\u043b\u044f '%s' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 '<case>'", field.getId()));
            }
            if (n2oSwitch.getCases().containsKey("")) {
                throw new N2oMetadataValidationException(String.format("\u0412 '<case>' \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 '<switch>' \u043f\u043e\u043b\u044f '%s' \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'value' \u043f\u0443\u0441\u0442\u043e\u0439", field.getId()));
            }
            if (!n2oSwitch.getCases().containsValue("")) continue;
            throw new N2oMetadataValidationException(String.format("\u0412 '<case>' \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 '<switch>' \u043f\u043e\u043b\u044f '%s' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0435\u043b\u043e", field.getId()));
        }
    }

    private void checkValidationSide(String objectId, N2oObject.Operation operation) {
        if (operation.getValidations() != null) {
            for (N2oValidation validation : operation.getValidations().getInlineValidations()) {
                this.validationSideIsNotClient(objectId, operation, validation);
            }
        }
    }

    private void validationSideIsNotClient(String objectId, N2oObject.Operation operation, N2oValidation validation) {
        if (validation.getSide() != null && validation.getSide().contains("client")) {
            throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'side' \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 %s \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 client", ValidationUtils.getIdOrEmptyString(validation.getId()), ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(objectId)));
        }
    }

    private void checkForExistsReferenceObject(String objectId, AbstractParameter[] fields, SourceProcessor p) {
        for (AbstractParameter field : fields) {
            if (!(field instanceof ObjectReferenceField)) continue;
            ObjectReferenceField refField = (ObjectReferenceField)field;
            if (refField.getReferenceObjectId() != null) {
                ValidationUtils.checkForExistsObject(refField.getReferenceObjectId(), String.format("\u041f\u043e\u043b\u0435 %s \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 %s", ValidationUtils.getIdOrEmptyString(refField.getId()), ValidationUtils.getIdOrEmptyString(objectId)), p);
            }
            if (ArrayUtils.isEmpty((Object[])refField.getFields())) continue;
            this.checkForExistsReferenceObject(objectId, refField.getFields(), p);
        }
    }

    private void checkValidationWhiteList(N2oObject object, N2oObject.Operation operation, SourceProcessor p) {
        if (object.getN2oValidations() == null) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'white-list', \u043d\u043e \u0441\u0430\u043c \u043e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0439", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId())));
        }
        HashMap validations = new HashMap();
        p.safeStreamOf((Object[])object.getN2oValidations()).forEach(v -> validations.put(v.getId(), v));
        p.safeStreamOf((Object[])operation.getValidations().getWhiteList()).forEach(val -> {
            if (!validations.containsKey(val)) {
                throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'white-list' \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044e %s \u043e\u0431\u044a\u0435\u043a\u0442\u0430", ValidationUtils.getIdOrEmptyString(operation.getId()), ValidationUtils.getIdOrEmptyString(object.getId()), ValidationUtils.getIdOrEmptyString(val)));
            }
            this.validationSideIsNotClient(object.getId(), operation, (N2oValidation)validations.get(val));
        });
    }

    public static void checkFieldIdExistence(AbstractParameter field, SourceProcessor p, String message) {
        if (field instanceof ObjectReferenceField) {
            p.safeStreamOf((Object[])((ObjectReferenceField)field).getFields()).forEach(childField -> ObjectValidator.checkFieldIdExistence(childField, p, message));
        }
        p.checkIdExistence((IdAware)field, message);
    }
}

