/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.fieldset;

import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.enums.Color;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oMultiFieldSet;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.widget.FieldsScope;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.stereotype.Component;

@Component
public class MultiFieldSetValidator
implements SourceValidator<N2oMultiFieldSet>,
SourceClassAware {
    public void validate(N2oMultiFieldSet source, SourceProcessor p) {
        if (StringUtils.isEmpty((Object)source.getId())) {
            throw new N2oMetadataValidationException(String.format("\u041c\u0443\u043b\u044c\u0442\u0438\u0444\u0438\u043b\u0434\u0441\u0435\u0442 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430", ValidationUtils.getIdOrEmptyString(((WidgetScope)p.getScope(WidgetScope.class)).getWidgetId())));
        }
        if (source.getItems() == null) {
            throw new N2oMetadataValidationException(String.format("\u041c\u0443\u043b\u044c\u0442\u0438\u0444\u0438\u043b\u0434\u0441\u0435\u0442 %s \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u0438\u043c\u0435\u0435\u0442 \u043f\u0443\u0441\u0442\u043e\u0435 \u0442\u0435\u043b\u043e", ValidationUtils.getIdOrEmptyString(source.getId()), ValidationUtils.getIdOrEmptyString(((WidgetScope)p.getScope(WidgetScope.class)).getWidgetId())));
        }
        this.validateItems(source, p);
        if (source.getBadgeColor() != null && !StringUtils.isLink((Object)source.getBadgeColor()) && !EnumUtils.isValidEnum(Color.class, (String)source.getBadgeColor())) {
            throw new N2oMetadataValidationException(String.format("\u0424\u0438\u043b\u0434\u0441\u0435\u0442 <multi-set> \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 badge-color=\"%s\"", source.getBadgeColor()));
        }
    }

    private void validateItems(N2oMultiFieldSet source, SourceProcessor p) {
        FieldsScope scope = new FieldsScope();
        p.safeStreamOf((Object[])source.getItems()).forEach(i -> p.validate((Source)i, new Object[]{scope}));
    }

    public Class<? extends Source> getSourceClass() {
        return N2oMultiFieldSet.class;
    }
}

