/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.datasource;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.datasource.DatasourceValidator;
import org.springframework.stereotype.Component;

@Component
public class StandardDatasourceValidator
extends DatasourceValidator<N2oStandardDatasource> {
    public Class<? extends Source> getSourceClass() {
        return N2oStandardDatasource.class;
    }

    @Override
    public void validate(N2oStandardDatasource datasource, SourceProcessor p) {
        super.validate(datasource, p);
        ValidationUtils.checkForExistsObject(datasource.getObjectId(), String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(datasource.getId())), p);
        N2oQuery query = ValidationUtils.checkQueryExists(datasource.getQueryId(), String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(datasource.getId())), p);
        this.checkSubmit(datasource.getId(), datasource.getSubmit(), p);
        this.checkPrefilters(datasource.getId(), datasource.getFilters(), query, p);
    }
}

