/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.datasource;

import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.control.Submit;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractDatasourceValidator<S extends N2oAbstractDatasource>
implements SourceValidator<S>,
SourceClassAware {
    public void validate(S source, SourceProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getId() == null && widgetScope == null) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s \u043d\u0435 \u0437\u0430\u0434\u0430\u043d 'id'", ValidationUtils.getIdOrEmptyString(pageScope.getPageId())));
        }
    }

    public void checkSubmit(String datasourceId, Submit submit, SourceProcessor p) {
        if (submit != null && submit.getRefreshDatasourceIds() != null) {
            for (String refreshDs : submit.getRefreshDatasourceIds()) {
                ValidationUtils.checkDatasourceExistence(refreshDs, p, String.format("\u0422\u0435\u0433 <submit> \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s' \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0435 'refresh-datasources'", ValidationUtils.getIdOrEmptyString(datasourceId), refreshDs));
            }
        }
    }

    public void checkPrefilters(String datasourceId, N2oPreFilter[] preFilters, N2oQuery query, SourceProcessor p) {
        if (preFilters != null) {
            if (query == null) {
                throw new N2oMetadataValidationException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u044b, \u043d\u043e \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0432\u044b\u0431\u043e\u0440\u043a\u0430", ValidationUtils.getIdOrEmptyString(datasourceId)));
            }
            if (query.getFilters() == null) {
                throw new N2oMetadataValidationException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u044b, \u043d\u043e \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s \u043d\u0435\u0442 filters!", ValidationUtils.getIdOrEmptyString(datasourceId), ValidationUtils.getIdOrEmptyString(query.getId())));
            }
            for (N2oPreFilter preFilter : preFilters) {
                QuerySimpleField exField;
                if (preFilter.getFieldId() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440 \u0431\u0435\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e field-id!", ValidationUtils.getIdOrEmptyString(datasourceId)));
                }
                String queryId = ValidationUtils.getIdOrEmptyString(query.getId());
                if (preFilter.getDatasourceId() != null) {
                    ValidationUtils.checkDatasourceExistence(preFilter.getDatasourceId(), p, String.format("\u0412 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u0435 \u043f\u043e \u043f\u043e\u043b\u044e %s \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(preFilter.getFieldId()), ValidationUtils.getIdOrEmptyString(preFilter.getDatasourceId())));
                }
                if ((exField = query.getSimpleFieldByAbsoluteId(preFilter.getFieldId())) == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s \u043d\u0435\u0442 \u043f\u043e\u043b\u044f %s!", ValidationUtils.getIdOrEmptyString(queryId), ValidationUtils.getIdOrEmptyString(preFilter.getFieldId())));
                }
                if (ArrayUtils.isEmpty((Object[])query.getFiltersList(exField.getAbsoluteId()))) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s \u043f\u043e\u043b\u0435 %s \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432!", ValidationUtils.getIdOrEmptyString(queryId), ValidationUtils.getIdOrEmptyString(preFilter.getFieldId())));
                }
                N2oQuery.Filter exFilter = null;
                for (N2oQuery.Filter filter : query.getFiltersList(exField.getAbsoluteId())) {
                    if (preFilter.getType() != filter.getType()) continue;
                    exFilter = filter;
                    break;
                }
                if (exFilter != null) continue;
                throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s \u043f\u043e\u043b\u0435 %s \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0444\u0438\u043b\u044c\u0442\u0440 \u0442\u0438\u043f\u0430 %s!", ValidationUtils.getIdOrEmptyString(queryId), ValidationUtils.getIdOrEmptyString(preFilter.getFieldId()), ValidationUtils.getIdOrEmptyString(preFilter.getType().name())));
            }
        }
    }
}

