/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.cell;

import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.enums.Color;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oBadgeCell;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.stereotype.Component;

@Component
public class BadgeCellValidator
implements SourceValidator<N2oBadgeCell>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oBadgeCell.class;
    }

    public void validate(N2oBadgeCell source, SourceProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getN2oSwitch() != null) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)source.getN2oSwitch().getValueFieldId())) {
                throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 <switch> \u044f\u0447\u0435\u0439\u043a\u0438 <badge> \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 'value-field-id'", ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
            }
            if (source.getN2oSwitch().getCases() != null) {
                p.safeStreamOf(source.getN2oSwitch().getCases().keySet()).forEach(c -> {
                    if (c == null) {
                        throw new N2oMetadataValidationException(String.format("\u0414\u043b\u044f <case> \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 <switch> \u044f\u0447\u0435\u0439\u043a\u0438 <badge> \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 'value'", ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
                    }
                });
            }
        }
        if (source.getColor() != null && !StringUtils.isLink((Object)source.getColor()) && !EnumUtils.isValidEnum(Color.class, (String)source.getColor())) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u044f\u0447\u0435\u0439\u043a\u0435 <badge> \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 color=\"%s\"", ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId()), source.getColor()));
        }
    }
}

