/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.button;

import java.util.Arrays;
import java.util.Objects;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oConfirmAction;
import net.n2oapp.framework.api.metadata.aware.GenerateAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.enums.Color;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Button;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeAware;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.stereotype.Component;

@Component
public class BaseButtonValidator
implements SourceValidator<Button>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return Button.class;
    }

    public void validate(Button source, SourceProcessor p) {
        this.checkDatasource(source, p);
        this.checkValidateDatasource(source, p);
        if (source.getColor() != null) {
            this.checkColor(source);
        }
        if (source instanceof BadgeAware) {
            this.checkBadgeColor(source);
        }
        if (ArrayUtils.isNotEmpty((Object[])source.getActions())) {
            if (source.getConfirm() != null) {
                if (Arrays.stream(source.getActions()).filter(N2oConfirmAction.class::isInstance).count() >= 2L) {
                    throw new N2oMetadataValidationException(String.format("\u041a\u043d\u043e\u043f\u043a\u0430 %s \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0438\u043c\u0435\u0435\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'confirm' \u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 <confirm>", this.getLabelOrId(source)));
                }
            }
            Arrays.stream(source.getActions()).forEach(a -> p.validate((Source)a, new Object[]{new ComponentScope(source, (ComponentScope)p.getScope(ComponentScope.class))}));
        }
        if (source instanceof GenerateAware && ((GenerateAware)source).getGenerate() != null) {
            String[] generate = ((GenerateAware)source).getGenerate();
            if (generate.length > 1) {
                throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u043a\u043d\u043e\u043f\u043a\u0438 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438", this.getLabelOrId(source)));
            }
            if (generate.length == 1 && StringUtils.isEmpty((Object)generate[0])) {
                throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u043a\u043d\u043e\u043f\u043a\u0438 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043f\u0443\u0441\u0442\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443", this.getLabelOrId(source)));
            }
            if (generate[0].equals("crud")) {
                throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u043a\u043d\u043e\u043f\u043a\u0438 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u044b\u0432\u0430\u0442\u044c 'crud' \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e", this.getLabelOrId(source)));
            }
        }
    }

    private void checkColor(Button source) {
        boolean isIncorrectColor;
        String color = source.getColor();
        boolean bl = isIncorrectColor = !Objects.equals(color, "link") && !color.startsWith("outline") && !EnumUtils.isValidEnum(Color.class, (String)color);
        if (isIncorrectColor && !StringUtils.isLink((Object)color)) {
            throw new N2oMetadataValidationException(String.format("\u041a\u043d\u043e\u043f\u043a\u0430 %s \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 color=\"%s\"", this.getLabelOrId(source), color));
        }
    }

    private void checkBadgeColor(Button source) {
        String badgeColor = ((BadgeAware)source).getBadgeColor();
        if (badgeColor != null && !StringUtils.isLink((Object)badgeColor) && !EnumUtils.isValidEnum(Color.class, (String)badgeColor)) {
            throw new N2oMetadataValidationException(String.format("\u041a\u043d\u043e\u043f\u043a\u0430 %s \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 badge-color=\"%s\"", this.getLabelOrId(source), badgeColor));
        }
    }

    private void checkDatasource(Button source, SourceProcessor p) {
        if (source.getDatasourceId() != null) {
            ValidationUtils.checkDatasourceExistence(source.getDatasourceId(), p, String.format("\u041a\u043d\u043e\u043f\u043a\u0430 %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", this.getLabelOrId(source), source.getDatasourceId()));
        }
    }

    private void checkValidateDatasource(Button source, SourceProcessor p) {
        if (source.getValidateDatasourceIds() != null) {
            for (String validateDs : source.getValidateDatasourceIds()) {
                ValidationUtils.checkDatasourceExistence(validateDs, p, String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'validate-datasources' \u043a\u043d\u043e\u043f\u043a\u0438 %s \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", this.getLabelOrId(source), validateDs));
            }
        }
    }

    private String getLabelOrId(Button button) {
        return ValidationUtils.getIdOrEmptyString(button.getLabel() != null ? button.getLabel() : button.getId());
    }
}

