/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.application;

import java.util.stream.Collectors;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.application.N2oSidebar;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.menu.N2oSimpleMenu;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.application.sidebar.SidebarPathsScope;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class ApplicationValidator
implements SourceValidator<N2oApplication>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oApplication.class;
    }

    public void validate(N2oApplication source, SourceProcessor p) {
        Object[] datasources = source.getDatasources();
        Object[] sidebars = source.getSidebars();
        p.checkIdsUnique((IdAware[])datasources, String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f %s", "%s", ValidationUtils.getIdOrEmptyString(source.getId())));
        ValidatorDataSourcesScope dataSourcesScope = new ValidatorDataSourcesScope();
        p.safeStreamOf((Object[])source.getDatasources()).forEach(d -> dataSourcesScope.put(d.getId(), d));
        ValidatorDatasourceIdsScope datasourceIdsScope = new ValidatorDatasourceIdsScope(p.safeStreamOf(datasources).map(N2oAbstractDatasource::getId).collect(Collectors.toSet()));
        p.safeStreamOf(datasources).forEach(datasource -> p.validate((Source)datasource, new Object[]{datasourceIdsScope}));
        if (source.getHeader() != null) {
            if (StringUtils.hasLink((String)source.getHeader().getTitle()) && source.getHeader().getDatasourceId() == null) {
                throw new N2oMetadataValidationException("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 <header> \u0438\u043c\u0435\u0435\u0442 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440, \u043d\u043e \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445");
            }
            if (source.getHeader().getDatasourceId() != null && !dataSourcesScope.containsKey(source.getHeader().getDatasourceId())) {
                throw new N2oMetadataValidationException(String.format("<header> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(source.getHeader().getDatasourceId())));
            }
            if (source.getHeader().getExtraMenu() != null) {
                p.checkForExists(source.getHeader().getExtraMenu().getRefId(), N2oSimpleMenu.class, String.format("<extra-menu> \u0445\u0435\u0434\u0435\u0440\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 'ref-id = %s'", ValidationUtils.getIdOrEmptyString(source.getId()), source.getHeader().getExtraMenu().getRefId()));
                p.validate((Source)source.getHeader().getExtraMenu(), new Object[]{datasourceIdsScope});
            }
            if (source.getHeader().getMenu() != null) {
                p.checkForExists(source.getHeader().getMenu().getRefId(), N2oSimpleMenu.class, String.format("<menu> \u0445\u0435\u0434\u0435\u0440\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 'ref-id = %s'", ValidationUtils.getIdOrEmptyString(source.getId()), source.getHeader().getMenu().getRefId()));
                p.validate((Source)source.getHeader().getMenu(), new Object[]{datasourceIdsScope});
            }
        }
        if (!ArrayUtils.isEmpty((Object[])source.getSidebars())) {
            p.safeStreamOf(sidebars).forEach(sidebar -> p.checkForExists(sidebar.getRefId(), N2oSidebar.class, String.format("<sidebar> \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 'ref-id = %s'", ValidationUtils.getIdOrEmptyString(source.getId()), sidebar.getRefId())));
            SidebarPathsScope sidebarsPaths = new SidebarPathsScope();
            p.safeStreamOf(sidebars).forEach(sidebar -> p.validate((Source)sidebar, new Object[]{sidebarsPaths, dataSourcesScope, datasourceIdsScope}));
        }
    }
}

