/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.action;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oSwitchAction;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.validation.TypedMetadataValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class SwitchActionValidator
extends TypedMetadataValidator<N2oSwitchAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oSwitchAction.class;
    }

    public void validate(N2oSwitchAction source, SourceProcessor p) {
        if (source.getValueFieldId() == null) {
            throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 <switch> \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d 'value-field-id'");
        }
        ValidationUtils.checkDatasourceExistenceInTag(source.getDatasourceId(), p, "<switch>");
        Object[] cases = source.getCases();
        if (ArrayUtils.isEmpty((Object[])cases)) {
            return;
        }
        if (source.getDefaultCase() != null && !(cases[cases.length - 1] instanceof N2oSwitchAction.DefaultCase)) {
            throw new N2oMetadataValidationException("\u0412 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 <switch> \u043f\u043e\u0441\u043b\u0435 <default> \u0443\u043a\u0430\u0437\u0430\u043d <case>");
        }
        source.getValueCases().forEach(this::checkValue);
        Arrays.stream(cases).forEach(c -> {
            ValidationUtils.checkOnFailActionNotExist(c.getActions(), "<switch>");
            p.validate((Source)c, new Object[0]);
        });
    }

    private void checkValue(N2oSwitchAction.Case valueCase) {
        if (valueCase.getValue() == null) {
            throw new N2oMetadataValidationException("\u0412 <case> \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f <switch> \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'value'");
        }
    }
}

