/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.action;

import javax.annotation.Nonnull;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oSubmitAction;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.datasource.Submittable;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oApplicationDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oParentDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class SubmitActionValidator
implements SourceValidator<N2oSubmitAction>,
SourceClassAware {
    public void validate(N2oSubmitAction source, SourceProcessor p) {
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        String datasourceId = this.getDatasourceId(source, componentScope);
        if (datasourceId != null) {
            this.checkDatasourceById(datasourceId, p);
        } else {
            N2oStandardDatasource datasource = ComponentScope.getFirstNotNull(componentScope, N2oWidget.class, N2oWidget::getDatasource);
            if (datasource != null) {
                this.checkDatasourceByInstance((N2oAbstractDatasource)datasource);
            } else {
                throw new N2oMetadataValidationException("\u0414\u043b\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f <submit> \u043d\u0435 \u0437\u0430\u0434\u0430\u043d 'datasource'");
            }
        }
    }

    private String getDatasourceId(N2oSubmitAction source, ComponentScope componentScope) {
        if (source.getDatasourceId() != null) {
            return source.getDatasourceId();
        }
        return ComponentScope.getFirstNotNull(componentScope, DatasourceIdAware.class, DatasourceIdAware::getDatasourceId);
    }

    private void checkDatasourceById(String datasourceId, SourceProcessor p) {
        ValidationUtils.checkDatasourceExistence(datasourceId, p, "\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'datasource' \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f <submit> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445");
        ValidatorDataSourcesScope dataSourcesScope = (ValidatorDataSourcesScope)p.getScope(ValidatorDataSourcesScope.class);
        if (dataSourcesScope != null) {
            this.checkDatasourceByInstance((N2oAbstractDatasource)dataSourcesScope.get(datasourceId));
        }
    }

    private void checkDatasourceByInstance(@Nonnull N2oAbstractDatasource datasource) {
        if (datasource instanceof N2oParentDatasource || datasource instanceof N2oApplicationDatasource) {
            return;
        }
        if (datasource instanceof Submittable) {
            if (((Submittable)datasource).getSubmit() == null) {
                throw new N2oMetadataValidationException(String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 <submit> \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445%s, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d submit", ValidationUtils.getSpaceWithIdOrEmptyString(datasource.getId())));
            }
        } else {
            throw new N2oMetadataValidationException(String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 <submit> \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445%s, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 submit", ValidationUtils.getSpaceWithIdOrEmptyString(datasource.getId())));
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oSubmitAction.class;
    }
}

