/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget.table;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.Alignment;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oSimpleColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.cell.Cell;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.table.ColumnHeader;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.widget.CellsScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.compile.widget.table.AbstractHeaderCompiler;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class SimpleColumnHeaderCompiler<T extends N2oSimpleColumn>
extends AbstractHeaderCompiler<T> {
    public Class<? extends Source> getSourceClass() {
        return N2oSimpleColumn.class;
    }

    public ColumnHeader compile(T source, CompileContext<?, ?> context, CompileProcessor p) {
        boolean sortable;
        ColumnHeader header = new ColumnHeader();
        IndexScope idx = (IndexScope)p.getScope(IndexScope.class);
        int indexNumber = idx.get();
        source.setId((String)CompileUtil.castDefault((Object)source.getId(), (Object)source.getTextFieldId(), (Object[])new String[]{"cell" + indexNumber}));
        source.setSortingFieldId((String)CompileUtil.castDefault((Object)source.getSortingFieldId(), (Object)source.getTextFieldId(), (Object[])new String[0]));
        source.setAlignment((Alignment)CompileUtil.castDefault((Object)source.getAlignment(), (Supplier[])new Supplier[]{() -> (Alignment)p.resolve(Placeholders.property((String)"n2o.api.widget.column.alignment"), Alignment.class)}));
        source.setContentAlignment((Alignment)CompileUtil.castDefault((Object)source.getContentAlignment(), (Object)source.getAlignment(), (Object[])new Alignment[0]));
        N2oCell cell = source.getCell();
        if (cell == null) {
            cell = new N2oTextCell();
        }
        Cell compiledCell = (Cell)p.compile((Object)cell, context, new Object[]{new ComponentScope(source), new IndexScope()});
        CellsScope cellsScope = (CellsScope)p.getScope(CellsScope.class);
        if (cellsScope != null && cellsScope.getCells() != null) {
            cellsScope.getCells().add(compiledCell);
        }
        this.compileBaseProperties(source, header, p);
        header.setId(source.getId());
        header.setIcon(source.getIcon());
        header.setResizable((Boolean)CompileUtil.castDefault((Object)source.getResizable(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.column.resizable"), Boolean.class)), (Object[])new Boolean[0]));
        header.getElementAttributes().put("width", StringUtils.prepareSizeAttribute((String)source.getWidth()));
        header.setResizable((Boolean)CompileUtil.castDefault((Object)source.getResizable(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.column.resizable"), Boolean.class)}));
        header.setFixed(source.getFixed());
        if (source.getAlignment() != null) {
            header.getElementAttributes().put("alignment", source.getAlignment().getId());
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getColumnVisibilities() != null) {
            for (AbstractColumn.ColumnVisibility visibility : source.getColumnVisibilities()) {
                String datasourceId = DatasourceUtil.getClientDatasourceId((String)CompileUtil.castDefault((Object)visibility.getDatasourceId(), (Object)widgetScope.getDatasourceId(), (Object[])new String[0]), p);
                ReduxModel refModel = (ReduxModel)CompileUtil.castDefault((Object)visibility.getModel(), (Object)ReduxModel.filter, (Object[])new ReduxModel[0]);
                Condition condition = new Condition();
                condition.setExpression(ScriptProcessor.resolveFunction((String)visibility.getValue()));
                condition.setModelLink(new ModelLink(refModel, datasourceId).getBindLink());
                if (!header.getConditions().containsKey(ValidationType.visible)) {
                    header.getConditions().put(ValidationType.visible, new ArrayList());
                }
                ((List)header.getConditions().get(ValidationType.visible)).add(condition);
            }
        }
        CompiledQuery query = (CompiledQuery)p.getScope(CompiledQuery.class);
        header.setLabel(this.initLabel(source, query));
        if (query != null && query.getSimpleFieldsMap().containsKey(source.getSortingFieldId()) && (sortable = ((QuerySimpleField)query.getSimpleFieldsMap().get(source.getSortingFieldId())).getIsSorted().booleanValue())) {
            header.setSortingParam(RouteUtil.normalizeParam(source.getSortingFieldId()));
        }
        header.setProperties(p.mapAttributes(source));
        return header;
    }

    private String initLabel(T source, CompiledQuery query) {
        if (source.getLabel() != null) {
            return source.getLabel();
        }
        if (query != null && query.getSimpleFieldsMap().containsKey(source.getTextFieldId())) {
            return ((QuerySimpleField)query.getSimpleFieldsMap().get(source.getTextFieldId())).getName();
        }
        return source.getId();
    }
}

