/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.util.DatasourceUtil;

public class WidgetScope {
    private String widgetId;
    private String datasourceId;
    private String clientWidgetId;
    private String clientDatasourceId;
    private ReduxModel model;
    private N2oStandardDatasource inLineDatasource;
    private MetaActions actions;

    public WidgetScope(String widgetId, String datasourceId, N2oStandardDatasource inLineDatasource) {
        this.widgetId = widgetId;
        this.datasourceId = datasourceId;
        this.inLineDatasource = inLineDatasource;
    }

    public WidgetScope(String widgetId, String datasourceId, N2oStandardDatasource inLineDatasource, MetaActions actions) {
        this.widgetId = widgetId;
        this.datasourceId = datasourceId;
        this.inLineDatasource = inLineDatasource;
        this.actions = actions;
    }

    public WidgetScope(String widgetId, String datasourceId, ReduxModel model, CompileProcessor p) {
        this.widgetId = widgetId;
        this.datasourceId = datasourceId;
        this.model = model;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        this.clientWidgetId = pageScope != null ? DatasourceUtil.getClientWidgetId(widgetId, pageScope.getPageId()) : widgetId;
        this.clientDatasourceId = DatasourceUtil.getClientDatasourceId(datasourceId, p);
    }

    public WidgetScope(String widgetId, N2oStandardDatasource inLineDatasource, ReduxModel model, CompileProcessor p) {
        this.widgetId = widgetId;
        this.inLineDatasource = inLineDatasource;
        this.model = model;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        this.clientWidgetId = pageScope != null ? DatasourceUtil.getClientWidgetId(widgetId, pageScope.getPageId()) : widgetId;
        this.clientDatasourceId = DatasourceUtil.getClientDatasourceId(this.datasourceId, p);
    }

    public String getWidgetId() {
        return this.widgetId;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public String getClientWidgetId() {
        return this.clientWidgetId;
    }

    public String getClientDatasourceId() {
        return this.clientDatasourceId;
    }

    public ReduxModel getModel() {
        return this.model;
    }

    public N2oStandardDatasource getInLineDatasource() {
        return this.inLineDatasource;
    }

    public MetaActions getActions() {
        return this.actions;
    }
}

