/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oTree;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeAware;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.api.metadata.meta.widget.Tree;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class TreeCompiler
extends BaseWidgetCompiler<Tree, N2oTree> {
    private static final String PROPERTY_PREFIX = "n2o.api.widget.tree";

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.tree.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oTree.class;
    }

    public Tree compile(N2oTree source, CompileContext<?, ?> context, CompileProcessor p) {
        Tree tree = new Tree();
        this.compileBaseWidget(tree, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.resolve, p);
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions((ActionBarAware)source, p);
        this.compileToolbarAndAction(tree, source, context, p, widgetScope, widgetActions, object, null);
        tree.setParentFieldId(p.resolveJS(source.getParentFieldId()));
        tree.setValueFieldId(p.resolveJS(source.getValueFieldId()));
        tree.setChildrenFieldId(p.resolveJS(source.getHasChildrenFieldId()));
        tree.setLabelFieldId(p.resolveJS(source.getLabelFieldId()));
        tree.setIconFieldId(p.resolveJS(source.getIconFieldId()));
        tree.setImageFieldId(p.resolveJS(source.getImageFieldId()));
        tree.setMultiselect((Boolean)CompileUtil.castDefault((Object)source.getMultiselect(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.tree.multi_select"), Boolean.class)}));
        tree.setHasCheckboxes((Boolean)CompileUtil.castDefault((Object)source.getCheckboxes(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.tree.checkboxes"), Boolean.class)}));
        tree.setAjax((Boolean)CompileUtil.castDefault((Object)source.getAjax(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.tree.ajax"), Boolean.class)}));
        tree.setBadge(BadgeUtil.compileReferringBadge((BadgeAware)source, (String)PROPERTY_PREFIX, (CompileProcessor)p));
        return tree;
    }

    @Override
    protected N2oAbstractDatasource initDatasource(Tree compiled, N2oTree source, CompileProcessor p) {
        N2oAbstractDatasource datasource = super.initDatasource(compiled, source, p);
        if (datasource.getSize() == null) {
            datasource.setSize((Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.tree.size"), Integer.class));
        }
        return datasource;
    }
}

