/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oBlock;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oTiles;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.cell.Cell;
import net.n2oapp.framework.api.metadata.meta.widget.Tiles;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class TilesCompiler
extends BaseListWidgetCompiler<Tiles, N2oTiles> {
    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.tiles.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oTiles.class;
    }

    public Tiles compile(N2oTiles source, CompileContext<?, ?> context, CompileProcessor p) {
        Tiles tiles = new Tiles();
        this.compileBaseWidget(tiles, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.resolve, p);
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions((ActionBarAware)source, p);
        this.compileToolbarAndAction(tiles, source, context, p, widgetScope, widgetActions, object, null);
        tiles.setColsSm((Integer)CompileUtil.castDefault((Object)source.getColsSm(), (Object)((Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.tiles.colsSm"), Integer.class)), (Object[])new Integer[0]));
        tiles.setColsMd((Integer)CompileUtil.castDefault((Object)source.getColsMd(), (Object)((Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.tiles.colsMd"), Integer.class)), (Object[])new Integer[0]));
        tiles.setColsLg((Integer)CompileUtil.castDefault((Object)source.getColsLg(), (Object)((Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.tiles.colsLg"), Integer.class)), (Object[])new Integer[0]));
        tiles.setHeight(StringUtils.prepareSizeAttribute((String)((String)CompileUtil.castDefault((Object)source.getHeight(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.tiles.height"), String.class)}))));
        tiles.setWidth(StringUtils.prepareSizeAttribute((String)((String)CompileUtil.castDefault((Object)source.getWidth(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.tiles.width"), String.class)}))));
        ArrayList<Tiles.Tile> tls = new ArrayList<Tiles.Tile>(source.getContent().length);
        for (N2oBlock block : source.getContent()) {
            tls.add(this.compileBlock(block, context, p, object, widgetScope, widgetActions));
        }
        tiles.setTile(tls);
        tiles.setPaging(this.compilePaging((N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.tiles.size"), Integer.class), p, widgetScope));
        return tiles;
    }

    private Tiles.Tile compileBlock(N2oBlock source, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        Tiles.Tile tile = new Tiles.Tile();
        source.setId((String)CompileUtil.castDefault((Object)source.getId(), (Object)source.getTextFieldId(), (Object[])new String[0]));
        tile.setId(source.getId());
        tile.setClassName(source.getCssClass());
        tile.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        N2oCell cell = source.getComponent();
        if (cell == null) {
            cell = new N2oTextCell();
        }
        tile.setComponent((Cell)p.compile((Object)cell, context, new Object[]{p, new IndexScope(), new ComponentScope(source), scopes}));
        return tile;
    }
}

