/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.aware.FieldsetItem;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.filter_buttons.N2oClearButton;
import net.n2oapp.framework.api.metadata.control.filter_buttons.N2oFilterButtonField;
import net.n2oapp.framework.api.metadata.control.filter_buttons.N2oSearchButtons;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ChildrenToggle;
import net.n2oapp.framework.api.metadata.global.view.widget.table.FilterPosition;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oRowOverlay;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oTable;
import net.n2oapp.framework.api.metadata.global.view.widget.table.RowSelectionEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.cell.Cell;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.table.AbstractTable;
import net.n2oapp.framework.api.metadata.meta.widget.table.ColumnHeader;
import net.n2oapp.framework.api.metadata.meta.widget.table.RowOverlay;
import net.n2oapp.framework.api.metadata.meta.widget.table.Table;
import net.n2oapp.framework.api.metadata.meta.widget.table.TableWidgetComponent;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.CellsScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.TableFiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class TableCompiler<D extends Table<?>, S extends N2oTable>
extends BaseListWidgetCompiler<D, S> {
    public Class<? extends Source> getSourceClass() {
        return N2oTable.class;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.table.src";
    }

    public D compile(S source, CompileContext<?, ?> context, CompileProcessor p) {
        D table = this.constructTable();
        this.compileBaseWidget(table, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledQuery query = this.getQuery(datasource, p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.filter, p);
        SubModelsScope subModelsScope = (SubModelsScope)CompileUtil.castDefault((Object)((SubModelsScope)p.getScope(SubModelsScope.class)), (Supplier[])new Supplier[]{SubModelsScope::new});
        ValidationScope validationScope = (ValidationScope)CompileUtil.castDefault((Object)((ValidationScope)p.getScope(ValidationScope.class)), (Supplier[])new Supplier[]{ValidationScope::new});
        FiltersScope filtersScope = (FiltersScope)p.getScope(FiltersScope.class);
        TableFiltersScope tableFiltersScope = filtersScope != null ? new TableFiltersScope(datasource.getId(), filtersScope) : null;
        table.setFilter(this.initFilter((Table)table, (N2oTable)source, context, p, widgetScope, query, object, new ModelsScope(ReduxModel.filter, widgetScope.getClientDatasourceId(), (Models)p.getScope(Models.class)), subModelsScope, new MomentScope(N2oValidation.ServerMoment.beforeQuery), validationScope, tableFiltersScope));
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions(source, p);
        TableWidgetComponent component = table.getComponent();
        this.compileToolbarAndAction(table, source, context, p, widgetScope, widgetActions, object, null);
        this.compileColumns((N2oTable)source, context, p, component, query, object, widgetScope, widgetActions, subModelsScope, tableFiltersScope);
        component.setWidth(StringUtils.prepareSizeAttribute((String)source.getWidth()));
        component.setHeight(StringUtils.prepareSizeAttribute((String)source.getHeight()));
        component.setTextWrap((Boolean)CompileUtil.castDefault((Object)source.getTextWrap(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.text_wrap"), Boolean.class)), (Object[])new Boolean[0]));
        component.getBody().setRow(this.initRows(source, context, p, object, widgetScope, widgetActions, component));
        table.setPaging(this.compilePaging((N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.table.size"), Integer.class), p, widgetScope));
        table.setChildren((ChildrenToggle)CompileUtil.castDefault((Object)source.getChildren(), (Supplier[])new Supplier[]{() -> (ChildrenToggle)p.resolve(Placeholders.property((String)"n2o.api.widget.table.children.toggle"), ChildrenToggle.class)}));
        component.setAutoSelect((Boolean)CompileUtil.castDefault((Object)source.getAutoSelect(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.auto_select"), Boolean.class)}));
        return table;
    }

    private TableWidgetComponent.BodyRow initRows(S source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject object, WidgetScope widgetScope, MetaActions widgetActions, TableWidgetComponent component) {
        if (source.getRows() == null) {
            return component.getBody().getRow();
        }
        TableWidgetComponent.BodyRow row = (TableWidgetComponent.BodyRow)CompileUtil.castDefault((Object)component.getBody().getRow(), (Supplier[])new Supplier[]{TableWidgetComponent.BodyRow::new});
        row.setSrc(source.getRows().getSrc());
        if (source.getRows().getStyle() != null) {
            row.getElementAttributes().put("style", StylesResolver.resolveStyles(p.resolveJS(source.getRows().getStyle())));
        }
        if (source.getRows().getRowClass() != null) {
            row.getElementAttributes().put("className", p.resolveJS(source.getRows().getRowClass()));
        } else if (source.getRows().getColor() != null) {
            HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
            for (String key : source.getRows().getColor().getCases().keySet()) {
                resolvedCases.put(p.resolve(key), (String)source.getRows().getColor().getCases().get(key));
            }
            source.getRows().getColor().setResolvedCases(resolvedCases);
            row.getElementAttributes().put("className", ScriptProcessor.buildSwitchExpression((N2oSwitch)source.getRows().getColor()));
        }
        row.setClick(this.compileRowClick((N2oAbstractListWidget)source, context, p, widgetScope, object));
        row.setOverlay(this.compileRowOverlay((N2oAbstractListWidget)source, context, p, widgetScope, new PageIndexScope(source.getId())));
        return row;
    }

    protected D constructTable() {
        return (D)new Table(new TableWidgetComponent());
    }

    private void compileColumns(N2oTable source, CompileContext<?, ?> context, CompileProcessor p, TableWidgetComponent component, CompiledQuery query, CompiledObject object, Object ... scopes) {
        if (source.getColumns() == null) {
            return;
        }
        ArrayList<ColumnHeader> headers = new ArrayList<ColumnHeader>();
        HashMap<String, String> sortings = new HashMap<String, String>();
        IndexScope columnIndex = new IndexScope();
        CellsScope cellsScope = new CellsScope(new ArrayList<Cell>());
        for (AbstractColumn column : source.getColumns()) {
            headers.add((ColumnHeader)p.compile((Object)column, context, new Object[]{p, new ComponentScope(column), object, columnIndex, cellsScope, query, scopes}));
            if (column.getSortingDirection() == null) continue;
            String fieldId = (String)CompileUtil.castDefault((Object)column.getSortingFieldId(), (Object)column.getTextFieldId(), (Object[])new String[0]);
            if (fieldId == null) {
                throw new N2oException(String.format("\u0412 \u043a\u043e\u043b\u043e\u043d\u043a\u0435 \"<column>\" c 'id=%s' \u0437\u0430\u0434\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'sorting-direction', \u043d\u043e \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043f\u043e\u043b\u0435 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438. \u0417\u0430\u0434\u0430\u0439\u0442\u0435 'sorting-field-id' \u0438\u043b\u0438 'text-field-id'", column.getId()));
            }
            sortings.put(RouteUtil.normalizeParam(fieldId), column.getSortingDirection().toString().toUpperCase());
        }
        component.getHeader().setCells(headers);
        component.getBody().setCells(cellsScope.getCells());
        if (MapUtils.isNotEmpty(sortings)) {
            this.passSortingToDatasource(sortings, source, p);
        }
        component.setRowSelection((RowSelectionEnum)CompileUtil.castDefault((Object)source.getSelection(), (Supplier[])new Supplier[]{() -> (RowSelectionEnum)p.resolve(Placeholders.property((String)"n2o.api.widget.table.selection"), RowSelectionEnum.class)}));
    }

    private void passSortingToDatasource(Map<String, String> sortings, N2oTable source, CompileProcessor p) {
        String sourceDatasourceId = ((PageScope)p.getScope(PageScope.class)).getWidgetIdSourceDatasourceMap().get(source.getId());
        this.getDataSourcesScope(p).ifPresent(sc -> ((N2oAbstractDatasource)sc.get(sourceDatasourceId)).setSorting(sortings));
    }

    private AbstractTable.Filter initFilter(Table compiled, N2oTable source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, CompiledQuery widgetQuery, CompiledObject object, Object ... scopes) {
        List<FieldSet> fieldSets;
        ArrayList<N2oField> searchButtons = new ArrayList<N2oField>();
        if (source.getFilters() != null) {
            this.findSearchButtons(source.getFilters().getItems(), searchButtons);
        }
        if (searchButtons.isEmpty()) {
            this.initDefaultSearchButtons(source);
        }
        if ((fieldSets = this.initFieldSets(source.getFilters() == null ? null : source.getFilters().getItems(), context, p, widgetScope, widgetQuery, object, scopes)).isEmpty()) {
            return compiled.getFilter();
        }
        AbstractTable.Filter filter = new AbstractTable.Filter();
        filter.setFilterFieldsets(fieldSets);
        filter.setFilterButtonId("filter");
        filter.setFetchOnClear((Boolean)CompileUtil.castDefault((Object)source.getFilters().getFetchOnClear(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.fetch_on_clear"), Boolean.class)}));
        filter.setBlackResetList(this.initBlackResetList(searchButtons));
        filter.setFilterPlace((FilterPosition)CompileUtil.castDefault((Object)source.getFilters().getPlace(), (Object)FilterPosition.TOP, (Object[])new FilterPosition[0]));
        filter.setFetchOnChange((Boolean)CompileUtil.castDefault((Object)source.getFilters().getFetchOnChange(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.fetch_on_change"), Boolean.class)}));
        filter.setFetchOnEnter((Boolean)CompileUtil.castDefault((Object)source.getFilters().getFetchOnEnter(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.fetch_on_enter"), Boolean.class)}));
        this.initInlineFiltersDatasource(compiled, source, p);
        return filter;
    }

    private void initDefaultSearchButtons(N2oTable source) {
        if (source.getFilters() == null || Boolean.TRUE.equals(source.getFilters().getFetchOnChange())) {
            return;
        }
        ArrayList<N2oField> searchButtons = new ArrayList<N2oField>();
        this.findSearchButtons(source.getFilters().getItems(), searchButtons);
        if (!searchButtons.isEmpty()) {
            return;
        }
        SourceComponent[] items = new SourceComponent[source.getFilters().getItems().length + 1];
        System.arraycopy(source.getFilters().getItems(), 0, items, 0, items.length - 1);
        N2oSearchButtons defaultSearchButtons = new N2oSearchButtons();
        defaultSearchButtons.setNoLabelBlock("true");
        items[items.length - 1] = defaultSearchButtons;
        source.getFilters().setItems(items);
    }

    private void findSearchButtons(SourceComponent[] filters, List<N2oField> searchButtons) {
        if (filters == null) {
            return;
        }
        for (SourceComponent filter : filters) {
            if (filter instanceof N2oSearchButtons || filter instanceof N2oFilterButtonField) {
                searchButtons.add((N2oField)filter);
                continue;
            }
            if (!(filter instanceof FieldsetItem)) continue;
            this.findSearchButtons((SourceComponent[])((FieldsetItem)filter).getItems(), searchButtons);
        }
    }

    private List<String> initBlackResetList(List<N2oField> searchButtons) {
        ArrayList<String> blackResetList = new ArrayList<String>();
        searchButtons.forEach(f -> Arrays.stream(this.getIgnore((N2oField)f)).collect(Collectors.toCollection(() -> blackResetList)));
        return blackResetList;
    }

    private String[] getIgnore(N2oField field) {
        if (field instanceof N2oSearchButtons && ((N2oSearchButtons)field).getClearIgnore() != null) {
            return ((N2oSearchButtons)field).getClearIgnore();
        }
        if (field instanceof N2oClearButton && ((N2oClearButton)field).getIgnore() != null) {
            return ((N2oClearButton)field).getIgnore();
        }
        return new String[0];
    }

    protected void initInlineFiltersDatasource(Table compiled, N2oTable source, CompileProcessor p) {
        if (source.getFilters() == null || source.getFilters().getDatasourceId() == null && source.getFilters().getDatasource() == null) {
            return;
        }
        Object datasourceId = source.getFilters().getDatasourceId();
        if (datasourceId == null) {
            datasourceId = source.getId() + "_filter";
            N2oStandardDatasource datasource = source.getFilters().getDatasource();
            source.getFilters().setDatasource(null);
            datasource.setId((String)datasourceId);
            source.getFilters().setDatasourceId((String)datasourceId);
            Object finalDatasourceId = datasourceId;
            this.getDataSourcesScope(p).ifPresent(arg_0 -> TableCompiler.lambda$initInlineFiltersDatasource$9((String)finalDatasourceId, datasource, arg_0));
        }
        compiled.setFiltersDatasourceId(DatasourceUtil.getClientDatasourceId((String)datasourceId, p));
    }

    private Optional<DataSourcesScope> getDataSourcesScope(CompileProcessor p) {
        return Optional.ofNullable((DataSourcesScope)p.getScope(DataSourcesScope.class));
    }

    protected RowOverlay compileRowOverlay(N2oAbstractListWidget source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, PageIndexScope indexScope) {
        Toolbar toolbar;
        Iterator iterator;
        if (source.getRows() == null || source.getRows().getRowOverlay() == null) {
            return null;
        }
        RowOverlay overlay = new RowOverlay();
        N2oRowOverlay rowOverlay = source.getRows().getRowOverlay();
        overlay.setClassName(rowOverlay.getClassName());
        if (rowOverlay.getToolbar() != null && (iterator = (toolbar = (Toolbar)p.compile((Object)rowOverlay.getToolbar(), context, new Object[]{widgetScope, indexScope})).values().iterator()).hasNext()) {
            overlay.setToolbar((List)iterator.next());
        }
        return overlay;
    }

    private static /* synthetic */ void lambda$initInlineFiltersDatasource$9(String finalDatasourceId, N2oStandardDatasource datasource, DataSourcesScope sc) {
        sc.put(finalDatasourceId, datasource);
    }
}

