/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.HashMap;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.list.N2oListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.cell.AbstractCell;
import net.n2oapp.framework.api.metadata.meta.widget.ListWidget;
import net.n2oapp.framework.api.metadata.meta.widget.Rows;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class ListWidgetCompiler
extends BaseListWidgetCompiler<ListWidget, N2oListWidget> {
    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.list.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oListWidget.class;
    }

    public ListWidget compile(N2oListWidget source, CompileContext<?, ?> context, CompileProcessor p) {
        ListWidget listWidget = new ListWidget();
        this.compileBaseWidget(listWidget, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.resolve, p);
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions((ActionBarAware)source, p);
        this.compileToolbarAndAction(listWidget, source, context, p, widgetScope, widgetActions, object, null);
        this.compileList(source, listWidget, context, widgetActions, p, widgetScope, widgetActions, object);
        if (source.getRows() != null) {
            listWidget.setRows(new Rows());
            listWidget.setRowClick(this.compileRowClick((N2oAbstractListWidget)source, context, p, widgetScope, object));
        }
        listWidget.setPaging(this.compilePaging((N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.list.size"), Integer.class), p, widgetScope));
        return listWidget;
    }

    private void compileList(N2oListWidget source, ListWidget compiled, CompileContext<?, ?> context, MetaActions actions, CompileProcessor p, WidgetScope widgetScope, MetaActions widgetActions, CompiledObject object) {
        if (source.getContent() == null) {
            return;
        }
        HashMap<String, AbstractCell> list = new HashMap<String, AbstractCell>();
        for (N2oListWidget.ContentElement element : source.getContent()) {
            element.setId(element.getTextFieldId());
            list.put(element.getPlace(), (AbstractCell)p.compile((Object)((N2oCell)CompileUtil.castDefault((Object)element.getCell(), (Supplier[])new Supplier[]{N2oTextCell::new})), context, new Object[]{new ComponentScope(element), actions, widgetScope, widgetActions, object, new IndexScope()}));
        }
        compiled.setList(list);
    }
}

