/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oHtmlWidget;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.widget.HtmlWidget;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class HtmlWidgetCompiler
extends BaseWidgetCompiler<HtmlWidget, N2oHtmlWidget> {
    public HtmlWidget compile(N2oHtmlWidget source, CompileContext<?, ?> context, CompileProcessor p) {
        HtmlWidget widget = new HtmlWidget();
        this.compileBaseWidget(widget, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.resolve, p);
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions((ActionBarAware)source, p);
        String html = (String)CompileUtil.castDefault((Object)source.getHtml(), (Supplier[])new Supplier[]{() -> p.getExternalFile(RouteUtil.normalize(source.getUrl()))});
        if (html != null) {
            if (StringUtils.hasLink((String)html)) {
                html = html.replace("'", "\\'");
            }
            widget.setHtml(p.resolveJS(html.trim()));
        }
        this.compileToolbarAndAction(widget, source, context, p, widgetScope, widgetActions, object, null);
        return widget;
    }

    @Override
    protected N2oAbstractDatasource initDatasource(HtmlWidget compiled, N2oHtmlWidget source, CompileProcessor p) {
        N2oAbstractDatasource datasource = super.initDatasource(compiled, source, p);
        if (datasource.getSize() == null) {
            datasource.setSize(Integer.valueOf(1));
        }
        return datasource;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.html.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oHtmlWidget.class;
    }
}

