/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oBlock;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oCards;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.cell.Cell;
import net.n2oapp.framework.api.metadata.meta.widget.Cards;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class CardsCompiler
extends BaseListWidgetCompiler<Cards, N2oCards> {
    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.cards.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oCards.class;
    }

    public Cards compile(N2oCards source, CompileContext<?, ?> context, CompileProcessor p) {
        Cards cards = new Cards();
        this.compileBaseWidget(cards, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.resolve, p);
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions((ActionBarAware)source, p);
        this.compileToolbarAndAction(cards, source, context, p, widgetScope, widgetActions, object, null);
        if (source.getContent() != null) {
            cards.setCards(this.compileCols(source.getContent(), context, p, object, widgetScope, widgetActions));
        }
        cards.setVerticalAlign((Cards.Position)CompileUtil.castDefault((Object)source.getVerticalAlign(), (Supplier[])new Supplier[]{() -> (Cards.Position)p.resolve(Placeholders.property((String)"n2o.api.widget.cards.vertical_align"), Cards.Position.class)}));
        cards.setHeight(StringUtils.prepareSizeAttribute((String)((String)CompileUtil.castDefault((Object)source.getHeight(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.cards.height"), String.class)}))));
        cards.setPaging(this.compilePaging((N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.cards.size"), Integer.class), p, widgetScope));
        return cards;
    }

    private List<Cards.Card> compileCols(N2oCards.N2oCol[] source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject object, WidgetScope widgetScope, MetaActions widgetActions) {
        ArrayList<Cards.Card> cards = new ArrayList<Cards.Card>(source.length);
        for (N2oCards.N2oCol col : source) {
            Cards.Card card = new Cards.Card();
            card.setSize(col.getSize());
            if (col.getBlocks() != null) {
                card.setContent(this.compileBlock(col.getBlocks(), context, p, object, widgetScope, widgetActions));
            }
            cards.add(card);
        }
        return cards;
    }

    private List<Cards.Block> compileBlock(N2oBlock[] source, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        ArrayList<Cards.Block> blocks = new ArrayList<Cards.Block>(source.length);
        for (N2oBlock block : source) {
            Cards.Block clientBlock = new Cards.Block();
            block.setId((String)CompileUtil.castDefault((Object)block.getId(), (Object)block.getTextFieldId(), (Object[])new String[0]));
            clientBlock.setId(block.getId());
            clientBlock.setClassName(block.getCssClass());
            clientBlock.setStyle(StylesResolver.resolveStyles(block.getStyle()));
            N2oCell cell = block.getComponent();
            if (cell == null) {
                cell = new N2oTextCell();
            }
            clientBlock.setComponent((Cell)p.compile((Object)cell, context, new Object[]{p, new IndexScope(), new ComponentScope(block), scopes}));
            blocks.add(clientBlock);
        }
        return blocks;
    }
}

