/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.Arrays;
import java.util.Date;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oCalendar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.widget.calendar.Calendar;
import net.n2oapp.framework.api.metadata.meta.widget.calendar.CalendarViewType;
import net.n2oapp.framework.api.metadata.meta.widget.calendar.CalendarWidgetComponent;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class CalendarCompiler
extends BaseWidgetCompiler<Calendar, N2oCalendar> {
    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.calendar.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oCalendar.class;
    }

    public Calendar compile(N2oCalendar source, CompileContext<?, ?> context, CompileProcessor p) {
        Calendar calendar = new Calendar();
        this.compileBaseWidget(calendar, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModel.resolve, p);
        CalendarWidgetComponent component = calendar.getComponent();
        component.setSize((Integer)CompileUtil.castDefault((Object)source.getSize(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.calendar.size"), Integer.class)}));
        component.setHeight(StringUtils.prepareSizeAttribute((String)source.getHeight()));
        String dateDomain = (String)p.resolve(Placeholders.property((String)"n2o.api.control.date_time.domain"), String.class);
        component.setDate((Date)p.resolve(source.getDefaultDate(), dateDomain));
        component.setDefaultView(source.getDefaultView() != null ? source.getDefaultView().getTitle() : (String)p.resolve(Placeholders.property((String)"n2o.api.widget.calendar.view"), String.class));
        component.setViews((String[])Arrays.stream(source.getViews()).map(v -> CalendarViewType.valueOf((String)v).getTitle()).toArray(String[]::new));
        component.setMinTime(p.resolveJS(source.getMinTime()));
        component.setMaxTime(p.resolveJS(source.getMaxTime()));
        component.setMarkDaysOff((Boolean)CompileUtil.castDefault((Object)source.getMarkDaysOff(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.calendar.mark_days_off"), Boolean.class)}));
        component.setSelectable((Boolean)CompileUtil.castDefault((Object)source.getSelectable(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.calendar.selectable"), Boolean.class)}));
        component.setStep((Integer)CompileUtil.castDefault((Object)source.getStep(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.calendar.step"), Integer.class)}));
        component.setTimeSlots((Integer)CompileUtil.castDefault((Object)source.getTimeSlotCount(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.calendar.time_slot_count"), Integer.class)}));
        component.setTitleFieldId(source.getTitleFieldId());
        component.setTooltipFieldId(source.getTooltipFieldId());
        component.setStartFieldId(source.getStartFieldId());
        component.setEndFieldId(source.getEndFieldId());
        component.setCellColorFieldId(source.getCellColorFieldId());
        component.setDisabledFieldId(source.getDisabledFieldId());
        component.setResourceFieldId(source.getResourcesFieldId());
        component.setResources(source.getResources());
        if (source.getActionOnSelectSlot() != null) {
            component.setOnSelectSlot((Action)p.compile((Object)source.getActionOnSelectSlot(), context, new Object[]{object, new ComponentScope(source), widgetScope}));
        }
        if (source.getActionOnSelectEvent() != null) {
            component.setOnSelectEvent((Action)p.compile((Object)source.getActionOnSelectEvent(), context, new Object[]{object, new ComponentScope(source), widgetScope}));
        }
        component.setFormats(source.getFormats());
        return calendar;
    }
}

