/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.GenerateAware;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Group;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.toolbar.ButtonCompileUtil;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class ToolbarCompiler
implements BaseSourceCompiler<Toolbar, N2oToolbar, CompileContext<?, ?>>,
SourceClassAware,
MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public Class<? extends Source> getSourceClass() {
        return N2oToolbar.class;
    }

    public Toolbar compile(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p) {
        Toolbar toolbar = new Toolbar();
        ArrayList<Group> groups = new ArrayList<Group>();
        int groupIndex = 0;
        String toolbarPlace = ToolbarCompiler.getPlace(source, p);
        this.fillGroups(source, context, p, groups, groupIndex, toolbarPlace);
        if (ArrayUtils.isNotEmpty((Object[])source.getGenerate())) {
            groups.add(this.compileGeneratedButtons(source, context, p, groupIndex, toolbarPlace));
        }
        if (groups.size() != 0) {
            toolbar.put((Object)toolbarPlace, groups);
        }
        return toolbar;
    }

    private void fillGroups(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p, List<Group> groups, int groupIndex, String toolbarPlace) {
        if (ArrayUtils.isEmpty((Object[])source.getItems())) {
            return;
        }
        List<ToolbarItem> toolbarItems = List.of(source.getItems());
        int itemIndex = 0;
        while (itemIndex < toolbarItems.size()) {
            Group group = this.initGroup(source, toolbarPlace, groupIndex++);
            if (toolbarItems.get(itemIndex) instanceof N2oGroup) {
                group.setButtons(this.compileButtonsOfGroup(source, context, p, (N2oGroup)toolbarItems.get(itemIndex)));
                ++itemIndex;
            } else {
                itemIndex = this.compileSingleButtons(source, context, p, toolbarItems, group, itemIndex);
            }
            groups.add(group);
        }
    }

    private int compileSingleButtons(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p, List<ToolbarItem> toolbarItems, Group group, int itemIndex) {
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        boolean shouldBeGrouped = Boolean.FALSE.equals(this.shouldBeGrouped(p));
        while (itemIndex < toolbarItems.size() && !(toolbarItems.get(itemIndex) instanceof N2oGroup)) {
            buttons.add((AbstractButton)p.compile((Object)toolbarItems.get(itemIndex), context, new Object[]{source}));
            ++itemIndex;
            if (!shouldBeGrouped) continue;
        }
        group.setButtons(buttons);
        return itemIndex;
    }

    private ArrayList<AbstractButton> compileButtonsOfGroup(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p, N2oGroup item) {
        ArrayList<AbstractButton> result = new ArrayList<AbstractButton>();
        if (ArrayUtils.isNotEmpty((Object[])item.getGenerate())) {
            result.addAll(ButtonCompileUtil.generateButtons((GenerateAware)item, source, this.buttonGeneratorFactory, context, p));
        }
        if (item.getItems() == null) {
            return result;
        }
        for (int i = 0; i < item.getItems().length; ++i) {
            result.add((AbstractButton)p.compile((Object)item.getItems()[i], context, new Object[]{source}));
        }
        return result;
    }

    private Group compileGeneratedButtons(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p, int groupIndex, String toolbarPlace) {
        Group group = this.initGroup(source, toolbarPlace, groupIndex);
        List<AbstractButton> generatedButtons = ButtonCompileUtil.generateButtons((GenerateAware)source, source, this.buttonGeneratorFactory, context, p);
        group.setButtons(generatedButtons);
        return group;
    }

    private Group initGroup(N2oToolbar source, String place, Integer groupIndex) {
        Group group = new Group(place + groupIndex);
        group.setClassName(source.getCssClass());
        group.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        return group;
    }

    private static String getPlace(N2oToolbar source, CompileProcessor p) {
        ToolbarPlaceScope toolbarPlaceScope = (ToolbarPlaceScope)p.getScope(ToolbarPlaceScope.class);
        String defaultPlace = toolbarPlaceScope != null ? toolbarPlaceScope.getPlace() : (String)p.resolve(Placeholders.property((String)"n2o.api.widget.toolbar.place"), String.class);
        return (String)CompileUtil.castDefault((Object)source.getPlace(), (Object)defaultPlace, (Object[])new String[0]);
    }

    private Boolean shouldBeGrouped(CompileProcessor p) {
        Object buttonGrouping = p.resolve(Placeholders.property((String)"n2o.api.toolbar.grouping"));
        return buttonGrouping instanceof Boolean ? (Boolean)buttonGrouping : true;
    }
}

