/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.GenerateAware;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.PerformButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Submenu;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.BaseButtonCompiler;
import net.n2oapp.framework.config.metadata.compile.toolbar.ButtonCompileUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class SubmenuCompiler
extends BaseButtonCompiler<N2oSubmenu, Submenu>
implements MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public Class<? extends Source> getSourceClass() {
        return N2oSubmenu.class;
    }

    public Submenu compile(N2oSubmenu source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        Submenu submenu = new Submenu();
        IndexScope idx = (IndexScope)p.getScope(IndexScope.class);
        this.compileBase((AbstractButton)submenu, (N2oAbstractButton)source, context, p);
        submenu.setId((String)(source.getId() == null ? "subMenu" + idx.get() : source.getId()));
        source.setId(submenu.getId());
        submenu.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.action.submenu.src"), String.class)}));
        submenu.setShowToggleIcon((Boolean)CompileUtil.castDefault((Object)source.getShowToggleIcon(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.submenu.show_toggle_icon"), Boolean.class)}));
        this.compileCondition((N2oAbstractButton)source, (AbstractButton)submenu, p, (ComponentScope)p.getScope(ComponentScope.class));
        this.initMenuItems(source, submenu, idx, context, p);
        this.initGenerate(source, submenu, context, p);
        return submenu;
    }

    private void initMenuItems(N2oSubmenu source, Submenu button, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getMenuItems() != null) {
            button.setSubMenu(Stream.of(source.getMenuItems()).map(mi -> {
                if (mi.getDatasourceId() == null) {
                    mi.setDatasourceId(source.getDatasourceId());
                }
                if (mi.getModel() == null) {
                    mi.setModel(source.getModel());
                }
                mi.setIsGeneratedForSubMenu(Boolean.valueOf(true));
                PerformButton menuItem = (PerformButton)p.compile(mi, context, new Object[]{p, idx});
                menuItem.setColor(null);
                return menuItem;
            }).toList());
        }
    }

    private void initGenerate(N2oSubmenu sub, Submenu button, CompileContext<?, ?> context, CompileProcessor p) {
        if (!ArrayUtils.isEmpty((Object[])sub.getGenerate())) {
            if (button.getSubMenu() == null) {
                button.setSubMenu(new ArrayList());
            }
            N2oToolbar toolbar = (N2oToolbar)p.getScope(N2oToolbar.class);
            toolbar.setIsGeneratedForSubMenu(Boolean.valueOf(true));
            List<AbstractButton> generatedButtons = ButtonCompileUtil.generateButtons((GenerateAware)sub, toolbar, this.buttonGeneratorFactory, context, p);
            button.getSubMenu().addAll(generatedButtons.stream().map(b -> (PerformButton)b).peek(b -> b.setColor(null)).toList());
            if (Arrays.asList(sub.getGenerate()).contains("tableSettings")) {
                button.setIcon((String)p.resolve(Placeholders.property((String)"n2o.api.generate.button.tableSettings.icon"), String.class));
            }
        }
    }
}

