/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeAware;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.api.metadata.meta.badge.Position;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.ButtonCompileUtil;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class BaseButtonCompiler<S extends N2oAbstractButton, B extends AbstractButton>
implements BaseSourceCompiler<B, S, CompileContext<?, ?>> {
    private static final String PROPERTY_PREFIX = "n2o.api.control.button";

    protected void compileBase(AbstractButton button, N2oAbstractButton source, CompileContext<?, ?> context, CompileProcessor p) {
        button.setId(source.getId());
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        button.setIcon(source.getIcon());
        button.setIconPosition((Position)CompileUtil.castDefault((Object)source.getIconPosition(), (Supplier[])new Supplier[]{() -> (Position)p.resolve(Placeholders.property((String)"n2o.api.button.icon_position"), Position.class)}));
        button.setLabel(p.resolveJS(source.getLabel()));
        button.setDatasource(DatasourceUtil.getClientDatasourceId(source.getDatasourceId(), p));
        button.setClassName(source.getCssClass());
        button.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        button.setColor(p.resolveJS(source.getColor()));
        button.setModel(source.getModel());
        button.setBadge(BadgeUtil.compileSimpleBadge((BadgeAware)source, (String)PROPERTY_PREFIX, (CompileProcessor)p));
        this.initHint(source, button, p);
    }

    private void initHint(N2oAbstractButton source, AbstractButton button, CompileProcessor p) {
        String hint = source.getDescription();
        if (hint != null) {
            button.setHint(p.resolveJS(hint.trim()));
            button.setHintPosition(source.getTooltipPosition());
        }
    }

    private String initColor(N2oAbstractButton source, CompileProcessor p) {
        N2oCell cell;
        ComponentScope componentScope;
        if (source.getColor() == null && (componentScope = (ComponentScope)p.getScope(ComponentScope.class)) != null && (cell = componentScope.unwrap(N2oCell.class)) != null) {
            return (String)p.resolve(Placeholders.property((String)"n2o.api.cell.toolbar.button-color"), String.class);
        }
        return source.getColor();
    }

    protected void initDefaults(S source, CompileContext<?, ?> context, CompileProcessor p) {
        PageIndexScope pageIndexScope = (PageIndexScope)p.getScope(PageIndexScope.class);
        String defaultId = (String)("_".equals(pageIndexScope.getPageId()) ? "mi" : pageIndexScope.getPageId() + "_mi") + pageIndexScope.get();
        source.setId((String)CompileUtil.castDefault((Object)source.getId(), (Object)defaultId, (Object[])new String[0]));
        if (((Boolean)p.resolve(Placeholders.property((String)"n2o.api.button.generate-label"), Boolean.class)).booleanValue()) {
            source.setLabel((String)CompileUtil.castDefault((Object)source.getLabel(), (Object)source.getId(), (Object[])new String[0]));
        }
        source.setTooltipPosition(this.initTooltipPosition(source, p));
        source.setColor(this.initColor((N2oAbstractButton)source, p));
        source.setDatasourceId(ButtonCompileUtil.initDatasource(source, p));
        source.setModel((ReduxModel)CompileUtil.castDefault((Object)source.getModel(), (Object)ReduxModel.resolve, (Object[])new ReduxModel[0]));
    }

    private String initTooltipPosition(S source, CompileProcessor p) {
        if (source.getTooltipPosition() != null) {
            return source.getTooltipPosition();
        }
        return source instanceof N2oButton ? (String)p.resolve(Placeholders.property((String)"n2o.api.button.tooltip_position"), String.class) : (String)p.resolve(Placeholders.property((String)"n2o.api.menuitem.tooltip_position"), String.class);
    }

    protected void compileCondition(N2oAbstractButton source, AbstractButton button, CompileProcessor p, ComponentScope componentScope) {
        if (componentScope != null && componentScope.unwrap(N2oCell.class) != null) {
            String widgetDs;
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            String string = widgetDs = Objects.nonNull(widgetScope) && Objects.nonNull(widgetScope.getDatasourceId()) ? widgetScope.getDatasourceId() : null;
            if (widgetDs != null && !widgetDs.equals(source.getDatasourceId())) {
                this.compileLinkConditions(source, button, p);
            } else {
                this.resolveConditions(source, button, p);
            }
        } else {
            this.compileLinkConditions(source, button, p);
        }
    }

    private void compileLinkConditions(N2oAbstractButton source, AbstractButton button, CompileProcessor p) {
        String clientDatasource = DatasourceUtil.getClientDatasourceId(source.getDatasourceId(), p);
        if (StringUtils.isLink((Object)source.getVisible())) {
            this.compileLink(button, clientDatasource, ValidationType.visible, source.getVisible(), source.getModel());
        } else {
            button.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        }
        if (StringUtils.isLink((Object)source.getEnabled())) {
            this.compileLink(button, clientDatasource, ValidationType.enabled, source.getEnabled(), source.getModel());
        } else {
            button.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
        }
    }

    private void resolveConditions(N2oAbstractButton source, AbstractButton button, CompileProcessor p) {
        button.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        button.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
    }

    private void compileLink(AbstractButton button, String clientDatasource, ValidationType type, String linkCondition, ReduxModel model) {
        Condition condition = new Condition();
        condition.setExpression(StringUtils.unwrapLink((String)linkCondition));
        condition.setModelLink(new ModelLink(model, clientDatasource).getBindLink());
        if (!button.getConditions().containsKey(type)) {
            button.getConditions().put(type, new ArrayList());
        }
        ((List)button.getConditions().get(type)).add(condition);
    }
}

