/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.region;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.region.N2oTabsRegion;
import net.n2oapp.framework.api.metadata.global.view.region.RoutableRegion;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.region.TabsRegion;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.region.BaseRegionCompiler;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class TabsRegionCompiler
extends BaseRegionCompiler<TabsRegion, N2oTabsRegion> {
    private static final String ALWAYS_REFRESH = "n2o.api.region.tabs.always_refresh";
    private static final String LAZY = "n2o.api.region.tabs.lazy";
    private static final String SCROLLBAR = "n2o.api.region.tabs.scrollbar";
    private static final String MAX_HEIGHT = "n2o.api.region.tabs.max_height";
    private static final String HIDE_SINGLE_TAB = "n2o.api.region.tabs.hide_single_tab";
    private static final String ROUTABLE = "n2o.api.region.tabs.routable";

    @Override
    protected String getSrcProperty() {
        return "n2o.api.region.tabs.src";
    }

    public Class<N2oTabsRegion> getSourceClass() {
        return N2oTabsRegion.class;
    }

    public TabsRegion compile(N2oTabsRegion source, PageContext context, CompileProcessor p) {
        TabsRegion region = new TabsRegion();
        this.build(region, source, p);
        region.setItems(this.initItems(source, context, p));
        region.setAlwaysRefresh((Boolean)CompileUtil.castDefault((Object)source.getAlwaysRefresh(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)ALWAYS_REFRESH), Boolean.class)}));
        region.setLazy((Boolean)CompileUtil.castDefault((Object)source.getLazy(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)LAZY), Boolean.class)}));
        region.setScrollbar((Boolean)CompileUtil.castDefault((Object)source.getScrollbar(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)SCROLLBAR), Boolean.class)}));
        region.setMaxHeight(StringUtils.prepareSizeAttribute((String)((String)CompileUtil.castDefault((Object)source.getMaxHeight(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)MAX_HEIGHT), String.class)}))));
        region.setHideSingleTab((Boolean)CompileUtil.castDefault((Object)source.getHideSingleTab(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)HIDE_SINGLE_TAB), Boolean.class)}));
        region.setActiveTabFieldId(source.getActiveTabFieldId());
        region.setDatasource(DatasourceUtil.getClientDatasourceId(source.getDatasourceId(), p));
        region.setActiveParam(source.getActiveParam());
        this.compileRoute((RoutableRegion)source, region.getId(), ROUTABLE, p);
        if (!(context instanceof ModalPageContext)) {
            region.setRoutable((Boolean)CompileUtil.castDefault((Object)source.getRoutable(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)ROUTABLE), Boolean.class)}));
        }
        return region;
    }

    @Override
    protected String createId(CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String regionName = this.getDefaultId(pageScope, "tabs");
        return this.createId(regionName, p);
    }

    protected List<TabsRegion.Tab> initItems(N2oTabsRegion source, PageContext context, CompileProcessor p) {
        ArrayList<TabsRegion.Tab> items = new ArrayList<TabsRegion.Tab>();
        if (source.getTabs() != null) {
            for (N2oTabsRegion.Tab t : source.getTabs()) {
                TabsRegion.Tab tab = new TabsRegion.Tab();
                tab.setId(this.createTabId(t.getId(), source.getAlias(), p));
                tab.setLabel(t.getName());
                tab.setProperties(p.mapAttributes((ExtensionAttributesAware)t));
                tab.setContent(this.initContent(t.getContent(), context, p, (Source)t));
                tab.setOpened(Boolean.valueOf(items.isEmpty()));
                if (t.getDatasource() == null) {
                    t.setDatasource(source.getDatasourceId());
                }
                tab.setDatasource(DatasourceUtil.getClientDatasourceId(t.getDatasource(), p));
                this.compileLinkConditions(t, tab, p);
                items.add(tab);
            }
        }
        return items;
    }

    private void compileLinkConditions(N2oTabsRegion.Tab source, TabsRegion.Tab tab, CompileProcessor p) {
        if (StringUtils.isLink((Object)source.getVisible())) {
            this.compileLink(tab, ValidationType.visible, source.getVisible(), ReduxModel.resolve);
        } else {
            tab.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        }
        if (StringUtils.isLink((Object)source.getEnabled())) {
            this.compileLink(tab, ValidationType.enabled, source.getEnabled(), ReduxModel.resolve);
        } else {
            tab.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
        }
    }

    private void compileLink(TabsRegion.Tab tab, ValidationType type, String linkCondition, ReduxModel model) {
        if (tab.getDatasource() == null) {
            throw new N2oException(String.format("\u0414\u043b\u044f \u0432\u043a\u043b\u0430\u0434\u043a\u0438 '%s' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u0435 'visible'/'enabled', \u0442.\u043a. \u043d\u0435 \u0437\u0430\u0434\u0430\u043d 'datasource'", tab.getLabel()));
        }
        Condition condition = new Condition();
        condition.setExpression(StringUtils.unwrapLink((String)linkCondition));
        condition.setModelLink(new ModelLink(model, tab.getDatasource()).getBindLink());
        tab.getConditions().put(type, List.of(condition));
    }

    private String createTabId(String regionId, String alias, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String regionName = this.getDefaultId(pageScope, alias);
        String id = (String)CompileUtil.castDefault((Object)regionId, (Object)this.createId(regionName, p), (Object[])new String[0]);
        if (pageScope != null) {
            if (pageScope.getTabIds() == null) {
                pageScope.setTabIds(new HashSet<String>());
            } else if (pageScope.getTabIds().contains(id)) {
                throw new N2oException(String.format("\u0412\u043a\u043b\u0430\u0434\u043a\u0430 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c '%s' \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", id));
            }
            pageScope.getTabIds().add(id);
        }
        return id;
    }

    private String getDefaultId(PageScope scope, String id) {
        return scope == null || "_".equals(scope.getPageId()) ? id : scope.getPageId().concat("_").concat(id);
    }
}

