/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.query;

import java.util.Arrays;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oMongoDbDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class MongodbEngineQueryTransformer
implements SourceTransformer<N2oQuery>,
SourceClassAware {
    public N2oQuery transform(N2oQuery source, SourceProcessor p) {
        if (!this.isMongodb(source)) {
            return source;
        }
        if (source.getFields() != null) {
            for (AbstractField field : source.getFields()) {
                if (!Boolean.FALSE.equals(field.getIsSelected()) && field.getSelectExpression() == null) {
                    this.transformSelect(field);
                }
                if (!(field instanceof QuerySimpleField)) continue;
                this.transformSimpleField((QuerySimpleField)field);
            }
        }
        if (source.getFilters() != null) {
            this.transformFilters(source.getFilters());
        }
        return source;
    }

    private void transformSimpleField(QuerySimpleField field) {
        if (Boolean.TRUE.equals(field.getIsSorted()) && field.getSortingExpression() == null) {
            this.transformSortings(field);
        }
    }

    private void transformSelect(AbstractField field) {
        if (field.getId().equals("id")) {
            field.setSelectExpression("_id");
            field.setMapping("['_id'].toString()");
        } else {
            field.setSelectExpression(field.getId());
        }
    }

    private void transformSortings(QuerySimpleField field) {
        if (field.getId().equals("id")) {
            field.setSortingExpression("_id :idDirection");
        } else {
            field.setSortingExpression(field.getId() + " " + Placeholders.colon((String)(field.getId() + "Direction")));
        }
    }

    private void transformFilters(N2oQuery.Filter[] filters) {
        block10: for (N2oQuery.Filter filter : filters) {
            String domain = MongodbEngineQueryTransformer.getDomain(filter);
            if (filter.getFilterId() == null) {
                filter.setFilterId(RouteUtil.normalizeParam(filter.getFieldId()) + "_" + String.valueOf(filter.getType()));
            }
            if (filter.getText() != null) continue;
            if ("id".equals(filter.getFieldId())) {
                if (!filter.getType().equals((Object)FilterType.eq)) continue;
                filter.setText("{ _id: new ObjectId('#" + filter.getFilterId() + "') }");
                continue;
            }
            switch (filter.getType()) {
                case eq: {
                    filter.setText("{ '" + filter.getFieldId() + "': " + this.getFilterField(filter, domain) + " }");
                    continue block10;
                }
                case notEq: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$ne: " + this.getFilterField(filter, domain) + " }}");
                    continue block10;
                }
                case like: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$regex: '.*" + Placeholders.hash((String)filter.getFilterId()) + ".*'}}");
                    continue block10;
                }
                case likeStart: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$regex: '" + Placeholders.hash((String)filter.getFilterId()) + ".*'}}");
                    continue block10;
                }
                case more: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$gte: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
                case less: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$lte: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
                case in: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$in: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
                case notIn: {
                    filter.setText("{ '" + filter.getFieldId() + "': {$nin: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
            }
        }
    }

    private String getFilterField(N2oQuery.Filter filter, String domain) {
        if (domain.equals("string") || domain.equals("date") || domain.equals("localdate") || domain.equals("localdatetime")) {
            return "'" + Placeholders.hash((String)filter.getFilterId()) + "'";
        }
        return Placeholders.hash((String)filter.getFilterId());
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }

    private static String getDomain(N2oQuery.Filter filter) {
        return filter.getDomain() != null ? filter.getDomain().toLowerCase().trim() : "string";
    }

    private boolean isMongodb(N2oQuery source) {
        return this.checkMondodb(source.getLists()) && this.checkMondodb(source.getUniques()) && this.checkMondodb(source.getCounts());
    }

    private boolean checkMondodb(N2oQuery.Selection[] selection) {
        if (selection == null) {
            return true;
        }
        return Arrays.stream(selection).noneMatch(elem -> !(elem.getInvocation() instanceof N2oMongoDbDataProvider));
    }
}

