/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.datasource.AbstractDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oSimplePage;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oApplicationDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oParentDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.SimplePage;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.datasource.ClientDatasourceIdsScope;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.page.PageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SimplePageCompiler
extends PageCompiler<N2oSimplePage, SimplePage> {
    private static final String MAIN_WIDGET_ID = "w1";

    public SimplePage compile(N2oSimplePage source, PageContext context, CompileProcessor p) {
        SimplePage page = new SimplePage();
        String pageName = (String)CompileUtil.castDefault((Object)context.getPageName(), (Object)source.getName(), (Object[])new String[0]);
        page.setPageProperty(this.initPageName((N2oPage)source, pageName, context, p));
        this.compileBaseProperties(source, page, context, p);
        this.compileComponent(page, source, p);
        page.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        page.setBreadcrumb((List)this.initBreadcrumb((N2oPage)source, pageName, context, p));
        String refId = source.getWidget().getRefId();
        if (refId != null && !DynamicUtil.isDynamic((String)refId)) {
            source.setWidget((N2oWidget)p.merge((Source)((N2oWidget)p.getSource(refId, N2oWidget.class)), (Source)source.getWidget()));
        }
        N2oWidget widget = source.getWidget();
        widget.setId((String)CompileUtil.castDefault((Object)widget.getId(), (Object)MAIN_WIDGET_ID, (Object[])new String[0]));
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        PageRoutes routes = new PageRoutes(pageRoute);
        ParentRouteScope pageRouteScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        BreadcrumbList breadcrumbs = new BreadcrumbList(page.getBreadcrumb());
        ValidationScope validationScope = new ValidationScope();
        CopiedFieldScope copiedFieldScope = new CopiedFieldScope();
        DataSourcesScope datasourcesScope = new DataSourcesScope();
        ClientDatasourceIdsScope clientDatasourceIdsScope = new ClientDatasourceIdsScope();
        PageScope pageScope = this.initPageScope(page.getId(), widget, context, p);
        PageIndexScope pageIndexScope = new PageIndexScope(page.getId());
        FiltersScope filtersScope = new FiltersScope();
        SubModelsScope subModelsScope = new SubModelsScope();
        Widget compiledWidget = (Widget)p.compile((Object)widget, (CompileContext)context, new Object[]{routes, pageScope, pageRouteScope, breadcrumbs, validationScope, page.getModels(), pageRoutesScope, datasourcesScope, clientDatasourceIdsScope, filtersScope, copiedFieldScope, subModelsScope, pageIndexScope});
        this.initContextDatasources(datasourcesScope, clientDatasourceIdsScope, pageScope, context, p);
        page.setDatasources(this.initDatasources(datasourcesScope, context, p, clientDatasourceIdsScope, pageScope, validationScope, routes, pageRouteScope, pageScope, filtersScope, copiedFieldScope, subModelsScope));
        page.setWidget(compiledWidget);
        page.getPageProperty().setDatasource(compiledWidget.getDatasource());
        this.registerRoutes(routes, context, p);
        page.setRoutes(routes);
        page.setToolbar(this.compileToolbar(context, widget, p, pageScope, new MetaActions(), pageRouteScope, breadcrumbs, validationScope, datasourcesScope, clientDatasourceIdsScope, pageIndexScope));
        return page;
    }

    private Toolbar compileToolbar(PageContext context, N2oWidget resultWidget, CompileProcessor p, PageScope pageScope, Object ... scopes) {
        if (CollectionUtils.isEmpty(context.getToolbars())) {
            return null;
        }
        Toolbar result = new Toolbar();
        IndexScope indexScope = new IndexScope();
        context.getToolbars().forEach(t -> {
            N2oToolbar toolbar = this.cloneToolbar((N2oToolbar)t, resultWidget, p);
            CompiledObject object = null;
            if (pageScope.getObjectId() != null) {
                object = (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(pageScope.getObjectId()));
            }
            Toolbar compiledToolbar = (Toolbar)p.compile((Object)toolbar, (CompileContext)context, new Object[]{indexScope, object, pageScope, scopes});
            result.putAll((Map)compiledToolbar);
        });
        return result;
    }

    private PageScope initPageScope(String pageId, N2oWidget widget, PageContext context, CompileProcessor p) {
        PageScope pageScope = new PageScope();
        pageScope.setPageId(pageId);
        pageScope.setResultWidgetId(widget.getId());
        if (widget.getDatasource() != null) {
            pageScope.setObjectId(widget.getDatasource().getObjectId());
        }
        pageScope.setWidgetIdSourceDatasourceMap(new HashMap<String, String>());
        pageScope.getWidgetIdSourceDatasourceMap().put(widget.getId(), widget.getDatasourceId() == null ? widget.getId() : widget.getDatasourceId());
        return pageScope;
    }

    private Map<String, AbstractDatasource> initDatasources(DataSourcesScope dataSourcesScope, PageContext context, CompileProcessor p, Object ... scopes) {
        HashMap<String, AbstractDatasource> compiledDatasources = new HashMap<String, AbstractDatasource>();
        if (!dataSourcesScope.isEmpty()) {
            dataSourcesScope.values().stream().filter(ds -> !(ds instanceof N2oApplicationDatasource) && !(ds instanceof N2oParentDatasource)).forEach(ds -> {
                AbstractDatasource compiled = (AbstractDatasource)p.compile(ds, (CompileContext)context, new Object[]{dataSourcesScope, scopes});
                compiledDatasources.put(compiled.getId(), compiled);
            });
        }
        return compiledDatasources;
    }

    public Class<N2oSimplePage> getSourceClass() {
        return N2oSimplePage.class;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.page.simple.src";
    }
}

