/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.N2oSearchablePage;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.page.SearchablePage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.SearchBarScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class SearchablePageCompiler
extends BasePageCompiler<N2oSearchablePage, SearchablePage> {
    public SearchablePage compile(N2oSearchablePage source, PageContext context, CompileProcessor p) {
        SearchablePage page = new SearchablePage();
        this.initDefaults(source);
        SearchBarScope searchBarScope = new SearchBarScope(source.getSearchBar().getDatasourceId(), source.getSearchBar().getSearchFilterId());
        searchBarScope.setParam(source.getSearchBar().getSearchParam());
        page = this.compilePage(source, page, context, p, searchBarScope);
        page.setSearchBar(this.compileSearchBar(source, page, p));
        return page;
    }

    private void initDefaults(N2oSearchablePage source) {
        source.setSearchBar(this.initSearchBar(source.getSearchBar()));
    }

    private N2oSearchablePage.N2oSearchBar initSearchBar(N2oSearchablePage.N2oSearchBar source) {
        N2oSearchablePage.N2oSearchBar result = source;
        if (result == null) {
            result = new N2oSearchablePage.N2oSearchBar();
        }
        result.setSearchParam((String)CompileUtil.castDefault((Object)result.getSearchParam(), (Object)(result.getDatasourceId() + "_" + result.getSearchFilterId()), (Object[])new String[0]));
        return result;
    }

    @Override
    protected Map<String, List<Region>> initRegions(N2oSearchablePage source, SearchablePage page, CompileProcessor p, PageContext context, Object ... scopes) {
        HashMap<String, List<Region>> regions = new HashMap<String, List<Region>>();
        this.initRegions(source.getItems(), regions, "single", context, p, scopes);
        return regions;
    }

    protected SearchablePage.SearchBar compileSearchBar(N2oSearchablePage source, SearchablePage page, CompileProcessor p) {
        SearchablePage.SearchBar searchBar = new SearchablePage.SearchBar();
        searchBar.setClassName(source.getSearchBar().getClassName());
        searchBar.setTrigger(SearchablePage.SearchBar.TriggerType.valueOf((String)((String)p.resolve(Placeholders.property((String)"n2o.api.page.searchable.trigger"), String.class))));
        searchBar.setPlaceholder(source.getSearchBar().getPlaceholder());
        if (SearchablePage.SearchBar.TriggerType.BUTTON.equals((Object)searchBar.getTrigger())) {
            searchBar.setButton(new SearchablePage.SearchBar.Button());
        } else if (SearchablePage.SearchBar.TriggerType.CHANGE.equals((Object)searchBar.getTrigger())) {
            searchBar.setThrottleDelay((Integer)p.resolve(Placeholders.property((String)"n2o.api.page.searchable.throttle_delay"), Integer.class));
        }
        searchBar.setFieldId(source.getSearchBar().getSearchFilterId());
        String clientDatasourceId = DatasourceUtil.getClientDatasourceId(source.getSearchBar().getDatasourceId(), page.getId(), p);
        if (!page.getDatasources().containsKey(clientDatasourceId)) {
            clientDatasourceId = source.getSearchBar().getDatasourceId();
        }
        searchBar.setDatasource(clientDatasourceId);
        return searchBar;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.page.searchable.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oSearchablePage.class;
    }
}

