/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.datasource.AbstractDatasource;
import net.n2oapp.framework.api.metadata.datasource.StandardDatasource;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.Breadcrumb;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseMetadataBinder;

public abstract class PageBinder<D extends Page>
implements BaseMetadataBinder<D> {
    public D bindPage(D page, BindProcessor p, List<Widget<?>> widgets) {
        if (widgets != null) {
            widgets.forEach(x$0 -> p.bind(x$0, new Object[0]));
        }
        this.bindDatasources(page, p);
        if (page.getRoutes() != null) {
            if (page.getRoutes().getPath() != null) {
                page.getRoutes().setPath(p.resolveUrl(page.getRoutes().getPath()));
            }
            if (page.getRoutes().getQueryMapping() != null) {
                if (page.getModels() == null) {
                    page.setModels(new Models());
                }
                page.getRoutes().getQueryMapping().keySet().stream().filter(arg_0 -> ((BindProcessor)p).canResolveParam(arg_0)).filter(param -> ((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet() instanceof ModelLink).forEach(param -> {
                    ModelLink modelLink = (ModelLink)((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet();
                    this.removeDuplicateModels(page, modelLink);
                    page.getModels().add(modelLink.getModel(), modelLink.getDatasource(), modelLink.getFieldId(), modelLink);
                });
            }
        }
        if (page.getBreadcrumb() != null) {
            page.setBreadcrumb((List)new BreadcrumbList(page.getBreadcrumb()));
            page.getBreadcrumb().forEach(b -> {
                b.setPath(p.resolveUrl(b.getPath()));
                b.setLabel(this.tryToResolve(b.getLabel(), b.getModelLinks(), p));
            });
        }
        this.collectFiltersToModels(page, widgets, p);
        if (page.getModels() != null) {
            page.getModels().values().forEach(bl -> {
                if (bl.getValue() instanceof String) {
                    bl.setValue((Object)p.resolveText((String)bl.getValue()));
                } else if (bl.getValue() instanceof DefaultValues) {
                    DefaultValues dv = (DefaultValues)bl.getValue();
                    for (String key : dv.getValues().keySet()) {
                        if (!(dv.getValues().get(key) instanceof String)) continue;
                        dv.getValues().put(key, p.resolveText((String)dv.getValues().get(key)));
                    }
                }
            });
            this.resolveLinks(page.getModels(), p);
        }
        if (page.getPageProperty() != null) {
            page.getPageProperty().setTitle(this.tryToResolve(page.getPageProperty().getTitle(), page.getPageProperty().getModelLinks(), p));
            page.getPageProperty().setHtmlTitle(this.tryToResolve(page.getPageProperty().getHtmlTitle(), page.getPageProperty().getModelLinks(), p));
            page.getPageProperty().setModalHeaderTitle(this.tryToResolve(page.getPageProperty().getModalHeaderTitle(), page.getPageProperty().getModelLinks(), p));
        }
        if (page.getBreadcrumb() != null) {
            for (Breadcrumb crumb : page.getBreadcrumb()) {
                crumb.setLabel(p.resolveText(crumb.getLabel(), crumb.getModelLinks()));
            }
        }
        return page;
    }

    private void removeDuplicateModels(D page, ModelLink modelLink) {
        String modelLinkValue = StringUtils.unwrapJs((String)((String)modelLink.getValue()));
        if (Objects.isNull(modelLinkValue)) {
            return;
        }
        String modelId = modelLink.getBindLink().split("\\.")[1] + "." + modelLinkValue.split("\\.")[0];
        ModelLink link = (ModelLink)page.getModels().get((Object)modelId);
        if (link != null && link.getValue() instanceof DefaultValues) {
            DefaultValues defaultValues = (DefaultValues)link.getValue();
            defaultValues.getValues().remove(modelLinkValue.split("\\.")[1]);
            page.getModels().remove((Object)modelId);
        }
    }

    private void collectFiltersToModels(D page, List<Widget<?>> widgets, BindProcessor p) {
        if (widgets == null) {
            return;
        }
        widgets.stream().filter(w -> w.getFiltersDatasourceId() != null).forEach(w -> {
            AbstractDatasource filterDatasource = (AbstractDatasource)page.getDatasources().get(w.getFiltersDatasourceId());
            if (!(filterDatasource instanceof StandardDatasource)) {
                return;
            }
            StandardDatasource datasource = (StandardDatasource)filterDatasource;
            DataSet data = p.executeQuery(datasource.getQueryId(), PageBinder.getFilterDefaultValueCriteria(datasource));
            if (data != null) {
                data.forEach((k, v) -> {
                    ModelLink existParam = page.getModels().get(ReduxModel.filter, w.getDatasource(), k);
                    if (!(v == null || existParam != null && p.canResolveParam(existParam.getParam()))) {
                        page.getModels().add(ReduxModel.filter, w.getDatasource(), k, new ModelLink(v));
                    }
                });
            }
        });
    }

    private static N2oPreparedCriteria getFilterDefaultValueCriteria(StandardDatasource datasource) {
        N2oPreparedCriteria criteria = new N2oPreparedCriteria();
        if (datasource.getProvider() == null || datasource.getProvider().getQueryMapping() == null) {
            return criteria;
        }
        datasource.getProvider().getQueryMapping().forEach((param, modelLink) -> {
            if (modelLink.getValue() != null && !StringUtils.isJs((Object)modelLink.getValue())) {
                criteria.addRestriction(new Restriction(modelLink.getQueryParam(), modelLink.getValue()));
            }
        });
        return criteria;
    }

    private String tryToResolve(String value, List<ModelLink> modelLinks, BindProcessor p) {
        String resolved = p.resolveText(value, modelLinks);
        return StringUtils.hasLink((String)resolved) ? ScriptProcessor.resolveLinks((String)resolved) : resolved;
    }

    private void resolveLinks(Models models, BindProcessor p) {
        new HashSet(models.entrySet()).stream().filter(e -> !((ModelLink)e.getValue()).isConst()).forEach(e -> {
            ModelLink link = (ModelLink)models.get(e.getKey());
            ModelLink resolvedLink = (ModelLink)p.resolveLink((BindLink)link, true, false);
            models.put((Object)((String)e.getKey()), (Object)resolvedLink);
        });
        new HashSet(models.entrySet()).stream().filter(e -> ((ModelLink)e.getValue()).isConst() && ((ModelLink)e.getValue()).getSubModelLink() != null).forEach(e -> {
            ModelLink link = (ModelLink)models.get(e.getKey());
            ModelLink resolvedSubModelLink = p.resolveSubModels(link);
            models.add(link.getSubModelLink(), resolvedSubModelLink);
        });
    }

    private void bindDatasources(D page, BindProcessor p) {
        if (page.getDatasources() != null) {
            page.getDatasources().values().forEach(x$0 -> p.bind(x$0, new Object[0]));
        }
    }
}

