/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.datasource.AbstractDatasource;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.global.view.page.BasePageUtil;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesMode;
import net.n2oapp.framework.api.metadata.global.view.page.N2oBasePage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oApplicationDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oParentDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.region.N2oCustomRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.event.Event;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.datasource.ClientDatasourceIdsScope;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.page.PageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.SearchBarScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;

public abstract class BasePageCompiler<S extends N2oBasePage, D extends StandardPage>
extends PageCompiler<S, D> {
    protected abstract Map<String, List<Region>> initRegions(S var1, D var2, CompileProcessor var3, PageContext var4, Object ... var5);

    public D compilePage(S source, D page, PageContext context, CompileProcessor p, SearchBarScope searchBarScope) {
        String pageName = (String)CompileUtil.castDefault((Object)context.getPageName(), (Object)source.getName(), (Object[])new String[0]);
        page.setPageProperty(this.initPageName((N2oPage)source, pageName, context, p));
        this.compileBaseProperties(source, page, context, p);
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        List<N2oWidget> sourceWidgets = this.collectWidgets(source, p);
        N2oWidget resultWidget = this.initResultWidget(sourceWidgets);
        BreadcrumbList breadcrumb = this.initBreadcrumb((N2oPage)source, pageName, context, p);
        page.setBreadcrumb((List)breadcrumb);
        CompiledObject object = this.initObject(source, p);
        page.setClassName(source.getCssClass());
        page.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        this.compileComponent(page, source, p);
        PageRoutes pageRoutes = new PageRoutes(pageRoute);
        ParentRouteScope routeScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        ValidationScope validationScope = new ValidationScope();
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        SubModelsScope subModelsScope = new SubModelsScope();
        CopiedFieldScope copiedFieldScope = new CopiedFieldScope();
        ClientDatasourceIdsScope clientDatasourceIdsScope = new ClientDatasourceIdsScope();
        DataSourcesScope datasourcesScope = this.initDataSourcesScope(source, sourceWidgets, clientDatasourceIdsScope, context);
        PageScope pageScope = this.initPageScope(source, page.getId(), sourceWidgets, resultWidget, context);
        this.initContextDatasources(datasourcesScope, clientDatasourceIdsScope, pageScope, context, p);
        this.mergeActions(source, context);
        MetaActions metaActions = ActionCompileStaticProcessor.initMetaActions(source, p);
        if (Objects.nonNull(source.getActions())) {
            context.setActions(Arrays.stream(source.getActions()).collect(Collectors.toMap(ActionBar::getId, Function.identity())));
        }
        FiltersScope filtersScope = new FiltersScope();
        PageIndexScope pageIndexScope = new PageIndexScope(page.getId());
        page.setRegions(this.initRegions(source, page, p, context, pageScope, pageRoutes, routeScope, breadcrumb, validationScope, page.getModels(), pageRoutesScope, searchBarScope, subModelsScope, copiedFieldScope, datasourcesScope, clientDatasourceIdsScope, metaActions, filtersScope, new IndexScope(), pageIndexScope));
        Map<String, AbstractDatasource> compiledDatasources = this.compileDatasources(context, p, datasourcesScope, pageScope, validationScope, subModelsScope, copiedFieldScope, pageRoutes, routeScope, searchBarScope, filtersScope, clientDatasourceIdsScope);
        page.setDatasources(compiledDatasources);
        this.registerRoutes(pageRoutes, context, p);
        page.setRoutes(pageRoutes);
        this.mergeToolbars(source, context, resultWidget, p);
        this.compileToolbarAndAction((StandardPage)page, source, context, p, metaActions, pageIndexScope, pageScope, routeScope, pageRoutes, object, breadcrumb, metaActions, validationScope, datasourcesScope, clientDatasourceIdsScope);
        page.setEvents(this.initEvents(source, context, p, metaActions, pageScope, pageIndexScope, datasourcesScope, clientDatasourceIdsScope, new IndexScope()));
        if (Objects.nonNull(source.getDatasourceId())) {
            page.getPageProperty().setDatasource(DatasourceUtil.getClientDatasourceId(source.getDatasourceId(), page.getId(), clientDatasourceIdsScope));
        }
        return page;
    }

    private List<Event> initEvents(S source, PageContext context, CompileProcessor p, Object ... scopes) {
        if (ArrayUtils.isNotEmpty((Object[])source.getEvents())) {
            return Arrays.stream(source.getEvents()).map(n2oEvent -> (Event)p.compile(n2oEvent, (CompileContext)context, scopes)).collect(Collectors.toList());
        }
        return null;
    }

    private DataSourcesScope initDataSourcesScope(S source, List<N2oWidget> sourceWidgets, ClientDatasourceIdsScope clientDatasourceIdsScope, PageContext context) {
        DataSourcesScope datasourcesScope = new DataSourcesScope();
        HashSet<String> parentDatasourceIds = new HashSet<String>();
        if (Objects.nonNull(source.getDatasources())) {
            for (N2oAbstractDatasource ds : source.getDatasources()) {
                if (ds instanceof N2oApplicationDatasource) {
                    clientDatasourceIdsScope.put(ds.getId(), (String)CompileUtil.castDefault((Object)((N2oApplicationDatasource)ds).getSourceDatasource(), (Object)ds.getId(), (Object[])new String[0]));
                }
                if (ds instanceof N2oParentDatasource) {
                    parentDatasourceIds.add(ds.getId());
                    String sourceDatasourceId = null;
                    if (context.getDatasources() != null) {
                        sourceDatasourceId = context.getDatasources().stream().filter(datasource -> ds.getId().equals(datasource.getId()) && datasource instanceof N2oParentDatasource).map(datasource -> (String)CompileUtil.castDefault((Object)((N2oParentDatasource)datasource).getSourceDatasource(), (Object)datasource.getId(), (Object[])new String[0])).findFirst().orElse(null);
                    }
                    if (context.getParentDatasourceIdsMap() != null && !context.getParentDatasourceIdsMap().containsKey(ds.getId()) && !context.getParentDatasourceIdsMap().containsKey(sourceDatasourceId)) {
                        throw new N2oException("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \"<parent-datasource>\" \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b");
                    }
                }
                datasourcesScope.put(ds.getId(), ds);
            }
        }
        if (!parentDatasourceIds.isEmpty() && Objects.isNull(context.getParentClientPageId())) {
            throw new N2oException("\u041d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0437\u0430\u0434\u0430\u043d \"<parent-datasource>\", \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u043e\u043d\u0430 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b");
        }
        this.addInlineDatasourcesToScope(sourceWidgets, datasourcesScope);
        if (Objects.nonNull(context.getParentDatasourceIdsMap())) {
            for (String dsId : context.getParentDatasourceIdsMap().keySet()) {
                if (datasourcesScope.containsKey(dsId) && !parentDatasourceIds.contains(dsId)) continue;
                if (!datasourcesScope.containsKey(dsId)) {
                    datasourcesScope.put(dsId, new N2oParentDatasource(dsId, context.getParentDatasourceIdsMap().get(dsId), true));
                }
                clientDatasourceIdsScope.put(dsId, context.getParentDatasourceIdsMap().get(dsId));
            }
        }
        return datasourcesScope;
    }

    @Deprecated
    private void addInlineDatasourcesToScope(List<N2oWidget> sourceWidgets, DataSourcesScope dataSourcesScope) {
        for (N2oWidget widget : sourceWidgets) {
            N2oStandardDatasource datasource;
            if (!Objects.isNull(widget.getDatasourceId()) || !Objects.isNull(widget.getRefId()) && DynamicUtil.isDynamic((String)widget.getRefId())) continue;
            String datasourceId = widget.getId();
            if (Objects.isNull(widget.getDatasource())) {
                datasource = new N2oStandardDatasource();
                datasource.setDefaultValuesMode(DefaultValuesMode.defaults);
            } else {
                datasource = widget.getDatasource();
                datasourceId = Objects.nonNull(datasource.getId()) ? datasource.getId() : datasourceId;
                widget.setDatasource(null);
            }
            datasource.setId(datasourceId);
            widget.setDatasourceId(datasourceId);
            dataSourcesScope.put(datasourceId, datasource);
        }
    }

    private PageScope initPageScope(S source, String pageId, List<N2oWidget> sourceWidgets, N2oWidget resultWidget, PageContext context) {
        PageScope pageScope = new PageScope();
        pageScope.setPageId(pageId);
        if (Objects.nonNull(context.getParentTabIds())) {
            pageScope.setTabIds(context.getParentTabIds());
        }
        pageScope.setObjectId(source.getObjectId());
        pageScope.setResultWidgetId(Objects.isNull(resultWidget) ? null : resultWidget.getId());
        pageScope.getWidgetIdSourceDatasourceMap().putAll(sourceWidgets.stream().collect(Collectors.toMap(N2oMetadata::getId, w -> Objects.isNull(w.getDatasourceId()) ? w.getId() : w.getDatasourceId())));
        return pageScope;
    }

    private CompiledObject initObject(S source, CompileProcessor p) {
        return Objects.nonNull(source.getObjectId()) ? (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId())) : null;
    }

    private Map<String, AbstractDatasource> compileDatasources(PageContext context, CompileProcessor p, DataSourcesScope dataSourcesScope, PageScope pageScope, Object ... scopes) {
        HashMap<String, AbstractDatasource> compiledDataSources = new HashMap<String, AbstractDatasource>();
        for (N2oAbstractDatasource ds : dataSourcesScope.values()) {
            if (ds instanceof N2oApplicationDatasource || ds instanceof N2oParentDatasource) continue;
            AbstractDatasource compiled = (AbstractDatasource)p.compile((Object)ds, (CompileContext)context, new Object[]{pageScope, dataSourcesScope, scopes});
            compiledDataSources.put(compiled.getId(), compiled);
        }
        return compiledDataSources;
    }

    protected List<N2oWidget> collectWidgets(S source, CompileProcessor p) {
        List widgets = source.getWidgets();
        return this.mergeNotDynamic(widgets, p);
    }

    private List<N2oWidget> mergeNotDynamic(List<N2oWidget> widgets, CompileProcessor p) {
        ArrayList<N2oWidget> result = new ArrayList<N2oWidget>();
        for (N2oWidget w : widgets) {
            String refId = w.getRefId();
            if (Objects.nonNull(refId) && !DynamicUtil.isDynamic((String)refId)) {
                w = (N2oWidget)p.merge((Source)((N2oWidget)p.getSource(refId, N2oWidget.class)), (Source)w);
            }
            result.add(w);
        }
        return result;
    }

    protected void initRegions(SourceComponent[] pageItems, Map<String, List<Region>> regionMap, String defaultPlace, PageContext context, CompileProcessor p, Object ... scopes) {
        if (Objects.isNull(pageItems)) {
            return;
        }
        ArrayList<N2oWidget> widgets = new ArrayList<N2oWidget>();
        BasePageUtil.resolveRegionItems((SourceComponent[])pageItems, item -> {
            if (!widgets.isEmpty()) {
                this.createCustomRegion(widgets, regionMap, defaultPlace, context, p, scopes);
            }
            this.createRegion((N2oRegion)item, regionMap, defaultPlace, context, p, scopes);
        }, widgets::add);
        if (!widgets.isEmpty()) {
            this.createCustomRegion(widgets, regionMap, defaultPlace, context, p, scopes);
        }
    }

    private void createCustomRegion(List<N2oWidget> widgets, Map<String, List<Region>> regionMap, String defaultPlace, PageContext context, CompileProcessor p, Object ... scopes) {
        N2oCustomRegion n2oRegion = new N2oCustomRegion();
        N2oWidget[] content = new N2oWidget[widgets.size()];
        widgets.toArray(content);
        n2oRegion.setContent((SourceComponent[])content);
        this.createRegion((N2oRegion)n2oRegion, regionMap, defaultPlace, context, p, scopes);
        widgets.clear();
    }

    private void createRegion(N2oRegion n2oRegion, Map<String, List<Region>> regionMap, String defaultPlace, PageContext context, CompileProcessor p, Object ... scopes) {
        Region region = (Region)p.compile((Object)n2oRegion, (CompileContext)context, scopes);
        if (Objects.nonNull(regionMap.get(defaultPlace))) {
            regionMap.get(defaultPlace).add(region);
        } else {
            ArrayList<Region> regionList = new ArrayList<Region>();
            regionList.add(region);
            regionMap.put(defaultPlace, regionList);
        }
    }

    private N2oWidget initResultWidget(List<N2oWidget> sourceWidgets) {
        return !sourceWidgets.isEmpty() ? sourceWidgets.get(0) : null;
    }

    private void compileToolbarAndAction(StandardPage compiled, S source, PageContext context, CompileProcessor p, MetaActions metaActions, PageIndexScope pageIndexScope, Object ... scopes) {
        ActionCompileStaticProcessor.compileMetaActions(source, context, p, pageIndexScope, new Object[]{metaActions, scopes});
        compiled.setToolbar(ActionCompileStaticProcessor.compileToolbar(source, "n2o.api.page.toolbar.place", context, p, new Object[]{metaActions, new ComponentScope(source), pageIndexScope, scopes}));
    }

    private void mergeActions(S source, PageContext context) {
        if (CollectionUtils.isEmpty(context.getActions())) {
            return;
        }
        HashMap<String, ActionBar> actionBars = new HashMap<String, ActionBar>(context.getActions());
        if (Objects.nonNull(source.getActions())) {
            Arrays.stream(source.getActions()).forEach(a -> actionBars.putIfAbsent(a.getId(), (ActionBar)a));
        }
        source.setActions(actionBars.values().toArray(new ActionBar[0]));
    }

    private void mergeToolbars(S source, PageContext context, N2oWidget resultWidget, CompileProcessor p) {
        if (CollectionUtils.isEmpty(context.getToolbars())) {
            return;
        }
        HashMap toolbars = new HashMap();
        context.getToolbars().forEach(t -> {
            N2oToolbar toolbar = this.cloneToolbar((N2oToolbar)t, resultWidget, p);
            toolbars.put(t.getPlace(), toolbar);
        });
        if (Objects.nonNull(source.getToolbars())) {
            Arrays.stream(source.getToolbars()).forEach(t -> toolbars.putIfAbsent(t.getPlace(), t));
        }
        source.setToolbars(toolbars.values().toArray(new N2oToolbar[0]));
    }
}

