/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.object;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.dataprovider.N2oJavaDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.invocation.Argument;
import net.n2oapp.framework.api.metadata.global.dao.invocation.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oInvocationValidation;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.action.DefaultActions;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import org.springframework.stereotype.Component;

@Component
public class N2oObjectCompiler<C extends ObjectContext>
implements BaseSourceCompiler<CompiledObject, N2oObject, C> {
    private static final int OBJECT_REFERENCE_NESTING_MAX_DEPTH = 3;

    public Class<N2oObject> getSourceClass() {
        return N2oObject.class;
    }

    public CompiledObject compile(N2oObject source, C context, CompileProcessor p) {
        CompiledObject compiled = new CompiledObject();
        compiled.setId(source.getId());
        compiled.setTableName(source.getTableName());
        compiled.setAppName(source.getAppName());
        compiled.setModuleName(source.getModuleName());
        compiled.setServiceName(source.getServiceName());
        compiled.setOperations(new HashMap());
        compiled.setObjectFields(new ArrayList());
        compiled.setObjectFieldsMap(new HashMap());
        this.initObjectFields(source, compiled, p);
        compiled.setName((String)CompileUtil.castDefault((Object)source.getName(), (Object)source.getId(), (Object[])new String[0]));
        compiled.setValidationsMap(new HashMap());
        compiled.setValidations(this.initValidations(source, compiled, context, p));
        compiled.setValidationsMap(N2oObjectCompiler.initValidationsMap(compiled.getValidations()));
        this.initOperationsMap(source, compiled, context, p);
        return compiled;
    }

    private void initObjectFields(N2oObject source, CompiledObject compiled, CompileProcessor p) {
        if (source.getObjectFields() != null) {
            for (AbstractParameter field : source.getObjectFields()) {
                if (field instanceof ObjectReferenceField && ((ObjectReferenceField)field).getReferenceObjectId() != null) {
                    this.initReferenceFieldByObjectId((ObjectReferenceField)field, p, 1);
                }
                compiled.getObjectFields().add(field);
                compiled.getObjectFieldsMap().put(field.getId(), field);
            }
        }
    }

    private void compileSwitch(ObjectSimpleField field, CompileProcessor p) {
        N2oSwitch n2oSwitch = field.getN2oSwitch();
        if (Objects.isNull(n2oSwitch)) {
            return;
        }
        n2oSwitch.setValueFieldId(field.getId());
        HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
        if (Objects.nonNull(n2oSwitch.getCases())) {
            for (String key : n2oSwitch.getCases().keySet()) {
                resolvedCases.put(p.resolve(key), (String)n2oSwitch.getCases().get(key));
            }
        }
        n2oSwitch.setResolvedCases(resolvedCases);
    }

    private void initReferenceFieldByObjectId(ObjectReferenceField refField, CompileProcessor p, int currentDepth) {
        if (currentDepth > 3) {
            return;
        }
        N2oObject refObject = (N2oObject)p.getSource(refField.getReferenceObjectId(), N2oObject.class);
        refField.setEntityClass((String)CompileUtil.castDefault((Object)refField.getEntityClass(), (Object)refObject.getEntityClass(), (Object[])new String[0]));
        if (this.isNotEmpty(refField.getFields())) {
            if (this.isNotEmpty(refObject.getObjectFields())) {
                for (int i = 0; i < refField.getFields().length; ++i) {
                    AbstractParameter parameter = refField.getFields()[i];
                    Optional<AbstractParameter> objectRefField = Arrays.stream(refObject.getObjectFields()).filter(f -> f.getId().equals(parameter.getId())).findFirst();
                    if (!objectRefField.isPresent() || !objectRefField.get().getClass().equals(parameter.getClass())) continue;
                    refField.getFields()[i] = (AbstractParameter)p.merge((Source)objectRefField.get(), (Source)parameter);
                }
            }
        } else {
            refField.setFields(refObject.getObjectFields());
        }
        refField.setReferenceObjectId(null);
        if (this.isNotEmpty(refField.getFields())) {
            for (AbstractParameter field : refField.getFields()) {
                if (!(field instanceof ObjectReferenceField) || ((ObjectReferenceField)field).getReferenceObjectId() == null) continue;
                this.initReferenceFieldByObjectId((ObjectReferenceField)field, p, currentDepth++);
            }
        }
    }

    private List<Validation> initValidations(N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        ArrayList<Validation> result = new ArrayList<Validation>();
        if (source.getN2oValidations() != null) {
            for (N2oValidation validation : source.getN2oValidations()) {
                if (validation instanceof N2oInvocationValidation) {
                    this.prepareInvocationValidation(source, (N2oInvocationValidation)validation, compiled);
                }
                result.add((Validation)p.compile((Object)validation, context, new Object[0]));
            }
        }
        return result;
    }

    private void initOperationsMap(N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        if (source.getOperations() != null) {
            for (N2oObject.Operation operation : source.getOperations()) {
                CompiledObject.Operation compileOperation = this.compileOperation(operation, compiled, p);
                this.prepareOperationInvocation(operation.getInvocation(), source);
                compiled.getOperations().put(compileOperation.getId(), compileOperation);
                this.initOperationValidations(compileOperation, source, compiled, context, p);
            }
        }
    }

    private void prepareOperationInvocation(N2oInvocation invocation, N2oObject source) {
        if (invocation instanceof N2oJavaDataProvider) {
            N2oJavaDataProvider javaDataProvider = (N2oJavaDataProvider)invocation;
            if (javaDataProvider.getClassName() == null) {
                javaDataProvider.setClassName(source.getServiceClass());
            }
            if (source.getEntityClass() != null && javaDataProvider.getArguments() != null) {
                Arrays.stream(javaDataProvider.getArguments()).filter(arg -> arg.getClassName() == null && arg.getType() == Argument.Type.ENTITY).forEach(arg -> arg.setClassName(source.getEntityClass()));
            }
        }
    }

    private void initOperationValidations(CompiledObject.Operation compiledOperation, N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        List<Validation> requiredParamValidations;
        if (compiledOperation.getValidations() != null) {
            boolean activateAll = false;
            if (compiledOperation.getValidations().getBlackList() == null && compiledOperation.getValidations().getWhiteList() == null && source.getN2oValidations() != null) {
                String[] whiteList = (String[])Arrays.stream(source.getN2oValidations()).map(N2oValidation::getId).toArray(String[]::new);
                compiledOperation.getValidations().setWhiteList(whiteList);
                activateAll = true;
            } else if (compiledOperation.getValidations().getBlackList() != null && compiledOperation.getValidations().getWhiteList() != null) {
                throw new N2oException("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'whitelist' \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u043c 'blacklist'");
            }
            ArrayList<Validation> validationList = new ArrayList<Validation>();
            List<Object> whiteListValidationList = new ArrayList();
            if (compiledOperation.getValidations().getWhiteList() != null) {
                whiteListValidationList = this.getWhiteListValidations(compiledOperation.getValidations().getWhiteList(), compiled.getValidationsMap(), validationList, activateAll);
            } else if (compiledOperation.getValidations().getBlackList() != null) {
                validationList.addAll(this.getBlackListValidations(compiledOperation.getValidations().getBlackList(), compiled.getValidationsMap()));
            }
            List<Validation> inlineValidations = this.getInlineValidations(compiledOperation.getValidations().getInlineValidations(), source, compiled, context, p);
            if (inlineValidations != null) {
                validationList.addAll(inlineValidations);
                whiteListValidationList.addAll(inlineValidations);
            }
            compiledOperation.setValidationList(validationList);
            compiledOperation.setValidationsMap(N2oObjectCompiler.initValidationsMap(validationList));
            compiledOperation.setWhiteListValidationsMap(N2oObjectCompiler.initValidationsMap(whiteListValidationList));
        }
        if (!(requiredParamValidations = this.getRequiredParamValidations(compiledOperation.getInParametersMap(), p)).isEmpty()) {
            if (compiledOperation.getValidationList() == null) {
                compiledOperation.setValidationList(new ArrayList());
            }
            compiledOperation.getValidationList().addAll(requiredParamValidations);
        }
        if (context instanceof ActionContext && ((ActionContext)context).getValidations() != null) {
            if (compiledOperation.getValidationList() == null) {
                compiledOperation.setValidationList(new ArrayList());
            }
            this.mergeValidations(compiledOperation.getValidationList(), ((ActionContext)context).getValidations());
        }
    }

    private List<Validation> getWhiteListValidations(String[] whiteList, Map<String, Validation> validationsMap, List<Validation> validationList, boolean activateAll) {
        ArrayList<Validation> whiteListValidations = new ArrayList<Validation>();
        for (String name : whiteList) {
            Validation validation = validationsMap.get(name);
            if (Boolean.FALSE.equals(validation.getEnabled())) continue;
            validationList.add(validation);
            if (!activateAll) continue;
            whiteListValidations.add(validation);
        }
        return whiteListValidations;
    }

    private List<Validation> getBlackListValidations(String[] blackList, Map<String, Validation> validationsMap) {
        HashMap<String, Validation> blackListValidationsMap = new HashMap<String, Validation>(validationsMap);
        for (String name : blackList) {
            blackListValidationsMap.remove(name);
        }
        return new ArrayList<Validation>(blackListValidationsMap.values());
    }

    private List<Validation> getInlineValidations(N2oValidation[] validations, N2oObject source, CompiledObject compiled, C context, CompileProcessor p) {
        if (validations == null) {
            return null;
        }
        ArrayList<Validation> inlineValidations = new ArrayList<Validation>();
        for (N2oValidation n2oValidation : validations) {
            if ("false".equals(n2oValidation.getEnabled())) continue;
            if (n2oValidation instanceof N2oInvocationValidation) {
                this.prepareInvocationValidation(source, (N2oInvocationValidation)n2oValidation, compiled);
            }
            inlineValidations.add((Validation)p.compile((Object)n2oValidation, context, new Object[0]));
        }
        return inlineValidations;
    }

    private void prepareInvocationValidation(N2oObject source, N2oInvocationValidation validation, CompiledObject compiled) {
        if (validation.getInFields() != null) {
            for (AbstractParameter parameter : validation.getInFields()) {
                AbstractParameter field = (AbstractParameter)compiled.getObjectFieldsMap().get(parameter.getId());
                if (parameter instanceof ObjectSimpleField) {
                    if (field instanceof ObjectSimpleField) {
                        this.resolveSimpleFieldDefault((ObjectSimpleField)parameter, (ObjectSimpleField)field);
                    }
                    parameter.setRequired(parameter.getRequired());
                    continue;
                }
                if (!(parameter instanceof ObjectReferenceField) || !(field instanceof ObjectReferenceField)) continue;
                this.resolveReferenceFieldDefault((ObjectReferenceField)parameter, (ObjectReferenceField)field);
            }
        }
        this.prepareOperationInvocation(validation.getN2oInvocation(), source);
    }

    private List<Validation> getRequiredParamValidations(Map<String, AbstractParameter> inParamsMap, CompileProcessor p) {
        ArrayList<Validation> requiredParamValidations = new ArrayList<Validation>();
        for (AbstractParameter parameter : inParamsMap.values()) {
            if (!Boolean.TRUE.equals(parameter.getRequired())) continue;
            MandatoryValidation validation = new MandatoryValidation(parameter.getId(), p.getMessage("n2o.required.field", new Object[0]), parameter.getId());
            validation.setMoment(N2oValidation.ServerMoment.beforeOperation);
            requiredParamValidations.add((Validation)validation);
        }
        return requiredParamValidations;
    }

    private void mergeValidations(List<Validation> operationValidations, List<Validation> controlValidations) {
        for (Validation cv : controlValidations) {
            operationValidations.removeIf(validation -> validation.getId().equals(cv.getId()));
            operationValidations.add(cv);
        }
    }

    private static Map<String, Validation> initValidationsMap(List<Validation> validations) {
        return validations.stream().collect(Collectors.toMap(Validation::getId, Function.identity()));
    }

    private CompiledObject.Operation compileOperation(N2oObject.Operation operation, CompiledObject compiled, CompileProcessor p) {
        CompiledObject.Operation compiledOperation = new CompiledObject.Operation();
        compiledOperation.setInParametersMap(this.prepareOperationInParameters(operation.getInFields(), compiled, p));
        compiledOperation.setOutParametersMap(operation.getOutFields() != null ? Arrays.stream(operation.getOutFields()).peek(f -> {
            if (f instanceof ObjectSimpleField) {
                this.compileSwitch((ObjectSimpleField)f, p);
            }
        }).collect(Collectors.toMap(AbstractParameter::getId, Function.identity())) : Collections.emptyMap());
        compiledOperation.setFailOutParametersMap(operation.getFailOutFields() != null ? Arrays.stream(operation.getFailOutFields()).collect(Collectors.toMap(AbstractParameter::getId, Function.identity())) : Collections.emptyMap());
        this.compileOperationProperties(operation, compiledOperation, p);
        compiledOperation.setProperties(p.mapAttributes((ExtensionAttributesAware)operation));
        return compiledOperation;
    }

    private void compileOperationProperties(N2oObject.Operation operation, CompiledObject.Operation compiledOperation, CompileProcessor p) {
        compiledOperation.setId(operation.getId());
        compiledOperation.setDescription(operation.getDescription());
        compiledOperation.setName(operation.getName());
        compiledOperation.setSuccessText((String)CompileUtil.castDefault((Object)operation.getSuccessText(), (Supplier[])new Supplier[]{() -> p.getMessage("n2o.success", new Object[0])}));
        compiledOperation.setSuccessTitle(operation.getSuccessTitle());
        compiledOperation.setFailText(operation.getFailText());
        compiledOperation.setFailTitle(operation.getFailTitle());
        compiledOperation.setInvocation(operation.getInvocation());
        compiledOperation.setValidations(operation.getValidations());
        DefaultActions defaultOperations = DefaultActions.get(operation.getId());
        if (defaultOperations != null) {
            compiledOperation.setName((String)CompileUtil.castDefault((Object)operation.getName(), (Object)defaultOperations.getLabel(), (Object[])new String[0]));
        }
    }

    private Map<String, AbstractParameter> prepareOperationInParameters(AbstractParameter[] parameters, CompiledObject compiled, CompileProcessor p) {
        LinkedHashMap<String, AbstractParameter> inFieldsMap = new LinkedHashMap<String, AbstractParameter>();
        if (parameters != null) {
            for (AbstractParameter parameter : parameters) {
                this.prepareOperationInParameter(parameter, (AbstractParameter)compiled.getObjectFieldsMap().get(parameter.getId()), p);
                parameter.setRequired((Boolean)CompileUtil.castDefault((Object)parameter.getRequired(), (Object)false, (Object[])new Boolean[0]));
                if (parameter instanceof ObjectSimpleField) {
                    this.compileSwitch((ObjectSimpleField)parameter, p);
                }
                inFieldsMap.put(parameter.getId(), parameter);
            }
        }
        return inFieldsMap;
    }

    private void prepareOperationInParameter(AbstractParameter parameter, AbstractParameter field, CompileProcessor p) {
        if (parameter instanceof ObjectSimpleField && field instanceof ObjectSimpleField) {
            this.resolveSimpleFieldDefault((ObjectSimpleField)parameter, (ObjectSimpleField)field);
        } else if (parameter instanceof ObjectReferenceField && field instanceof ObjectReferenceField) {
            ObjectReferenceField refParam = (ObjectReferenceField)parameter;
            if (refParam.getReferenceObjectId() != null) {
                this.initReferenceFieldByObjectId(refParam, p, 1);
            }
            ObjectReferenceField refField = (ObjectReferenceField)field;
            this.resolveReferenceFieldDefault(refParam, refField);
            if (this.isNotEmpty(refParam.getFields())) {
                Map nestedFieldsMap = Arrays.stream(refField.getFields()).collect(Collectors.toMap(AbstractParameter::getId, Function.identity()));
                for (AbstractParameter refParamField : refParam.getFields()) {
                    if (!nestedFieldsMap.containsKey(refParamField.getId())) continue;
                    this.prepareOperationInParameter(refParamField, (AbstractParameter)nestedFieldsMap.get(refParamField.getId()), p);
                }
            } else if (this.isNotEmpty(refField.getFields())) {
                refParam.setFields(refField.getFields());
            }
        }
    }

    private void resolveSimpleFieldDefault(ObjectSimpleField parameter, ObjectSimpleField field) {
        if (field == null) {
            return;
        }
        this.resolveFieldDefault((AbstractParameter)parameter, (AbstractParameter)field);
        if (parameter.getDomain() == null) {
            parameter.setDomain(field.getDomain());
        }
        if (parameter.getDefaultValue() == null) {
            parameter.setDefaultValue(field.getDefaultValue());
        }
    }

    private void resolveReferenceFieldDefault(ObjectReferenceField parameter, ObjectReferenceField field) {
        if (field == null) {
            return;
        }
        this.resolveFieldDefault((AbstractParameter)parameter, (AbstractParameter)field);
        if (parameter.getEntityClass() == null) {
            parameter.setEntityClass(field.getEntityClass());
        }
        if (parameter.getReferenceObjectId() == null) {
            parameter.setReferenceObjectId(field.getReferenceObjectId());
        }
    }

    private void resolveFieldDefault(AbstractParameter parameter, AbstractParameter field) {
        if (parameter.getRequired() == null) {
            parameter.setRequired(field.getRequired());
        }
        if (parameter.getMapping() == null) {
            parameter.setMapping(field.getMapping());
        }
        if (parameter.getNormalize() == null) {
            parameter.setNormalize(field.getNormalize());
        }
    }

    public boolean isNotEmpty(Object[] array) {
        return array != null && array.length != 0;
    }
}

