/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.menu;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.action.N2oAnchor;
import net.n2oapp.framework.api.metadata.action.N2oOpenPage;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.api.metadata.header.MenuItem;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.menu.N2oSimpleMenu;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeAware;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.api.metadata.meta.badge.Position;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class SimpleMenuCompiler
implements BaseSourceCompiler<SimpleMenu, N2oSimpleMenu, ApplicationContext>,
SourceClassAware {
    private static final String PROPERTY_PREFIX = "n2o.api.menu.item";

    public Class<? extends Source> getSourceClass() {
        return N2oSimpleMenu.class;
    }

    public SimpleMenu compile(N2oSimpleMenu source, ApplicationContext context, CompileProcessor p) {
        SimpleMenu simpleMenu = new SimpleMenu();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        simpleMenu.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        IndexScope idx = (IndexScope)CompileUtil.castDefault((Object)((IndexScope)p.getScope(IndexScope.class)), (Supplier[])new Supplier[]{() -> new IndexScope(1)});
        if (ArrayUtils.isNotEmpty((Object[])source.getMenuItems())) {
            for (N2oSimpleMenu.AbstractMenuItem mi : source.getMenuItems()) {
                items.add(this.createMenuItem(mi, p, context, idx));
            }
        }
        simpleMenu.setItems(items);
        return simpleMenu;
    }

    private MenuItem createMenuItem(N2oSimpleMenu.AbstractMenuItem source, CompileProcessor p, ApplicationContext context, IndexScope idx) {
        MenuItem compiled = new MenuItem();
        source.setId((String)CompileUtil.castDefault((Object)source.getId(), (Object)("mi" + idx.get()), (Object[])new String[0]));
        compiled.setId(source.getId());
        compiled.setIcon(source.getIcon());
        compiled.setIconPosition((Position)CompileUtil.castDefault((Object)source.getIconPosition(), (Supplier[])new Supplier[]{() -> (Position)p.resolve(Placeholders.property((String)"n2o.api.menu.item.icon_position"), Position.class)}));
        compiled.setImageSrc(p.resolveJS(source.getImage()));
        compiled.setImageShape((ShapeType)CompileUtil.castDefault((Object)source.getImageShape(), (Supplier[])new Supplier[]{() -> (ShapeType)p.resolve(Placeholders.property((String)"n2o.api.menu.item.image_shape"), ShapeType.class)}));
        if (StringUtils.hasLink((String)source.getName()) && source.getDatasourceId() == null && ((ComponentScope)p.getScope(ComponentScope.class)).unwrap(DatasourceIdAware.class).getDatasourceId() == null) {
            throw new N2oException(String.format("\u041c\u0435\u043d\u044e \u0438\u043c\u0435\u0435\u0442 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440 'name=%s', \u043d\u043e \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445", ValidationUtils.getIdOrEmptyString(source.getName())));
        }
        compiled.setTitle(p.resolveJS(source.getName()));
        if (source.getDatasourceId() != null) {
            compiled.setDatasource(source.getDatasourceId());
        } else if (p.getScope(ComponentScope.class) != null) {
            compiled.setDatasource(((ComponentScope)p.getScope(ComponentScope.class)).unwrap(DatasourceIdAware.class).getDatasourceId());
        }
        if (source instanceof N2oSimpleMenu.MenuItem) {
            N2oSimpleMenu.MenuItem item = (N2oSimpleMenu.MenuItem)source;
            this.menuItem(item, compiled, p, context);
        } else if (source instanceof N2oSimpleMenu.DropdownMenuItem) {
            N2oSimpleMenu.DropdownMenuItem dropdownItem = (N2oSimpleMenu.DropdownMenuItem)source;
            this.initDropdownMenu(dropdownItem, compiled, p, context, idx);
        }
        compiled.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        return compiled;
    }

    private void menuItem(N2oSimpleMenu.MenuItem source, MenuItem compiled, CompileProcessor p, ApplicationContext context) {
        compiled.setBadge(BadgeUtil.compileSimpleBadge((BadgeAware)source, (String)PROPERTY_PREFIX, (CompileProcessor)p));
        compiled.setSrc(this.initSrc(source.getSrc(), source.getAction(), p));
        compiled.setClassName(source.getCssClass());
        compiled.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        compiled.setPageId(this.initPageId(source.getAction()));
        if (source.getName() == null) {
            compiled.setTitle(p.resolveJS(this.initDefaultName(source.getAction(), p)));
        }
        if (source.getAction() != null) {
            Action action = (Action)p.compile((Object)source.getAction(), (CompileContext)context, new Object[]{new ComponentScope(source, (ComponentScope)p.getScope(ComponentScope.class))});
            if (action instanceof LinkAction) {
                LinkAction linkAction = (LinkAction)action;
                compiled.setHref(linkAction.getUrl());
                compiled.setPathMapping(linkAction.getPathMapping());
                compiled.setQueryMapping(linkAction.getQueryMapping());
                compiled.setTarget(linkAction.getTarget());
                if (linkAction.getTarget().equals((Object)Target.application)) {
                    compiled.setLinkType(MenuItem.LinkType.inner);
                } else {
                    compiled.setLinkType(MenuItem.LinkType.outer);
                }
            } else {
                compiled.setAction(action);
            }
        }
    }

    private String initSrc(String src, N2oAction action, CompileProcessor p) {
        if (src != null) {
            return src;
        }
        if (action instanceof N2oAnchor || action instanceof N2oOpenPage) {
            return (String)p.resolve(Placeholders.property((String)"n2o.api.menu.item.link.src"), String.class);
        }
        if (action != null) {
            return (String)p.resolve(Placeholders.property((String)"n2o.api.menu.item.action.src"), String.class);
        }
        return (String)p.resolve(Placeholders.property((String)"n2o.api.menu.item.static.src"), String.class);
    }

    private String initPageId(N2oAction action) {
        String string;
        if (action instanceof N2oAbstractPageAction) {
            N2oAbstractPageAction pageAction = (N2oAbstractPageAction)action;
            string = pageAction.getPageId();
        } else {
            string = null;
        }
        return string;
    }

    private String initDefaultName(N2oAction action, CompileProcessor p) {
        String pageId = this.initPageId(action);
        return pageId == null ? null : ((N2oPage)p.getSource(pageId, N2oPage.class)).getName();
    }

    private void initDropdownMenu(N2oSimpleMenu.DropdownMenuItem source, MenuItem item, CompileProcessor p, ApplicationContext context, IndexScope idx) {
        item.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.menu.dropdown.src"), String.class)}));
        ArrayList<MenuItem> subItems = new ArrayList<MenuItem>();
        for (N2oSimpleMenu.AbstractMenuItem subItem : source.getMenuItems()) {
            subItem.setDatasourceId((String)CompileUtil.castDefault((Object)subItem.getDatasourceId(), (Object)source.getDatasourceId(), (Object[])new String[0]));
            subItems.add(this.createMenuItem(subItem, p, context, idx));
        }
        item.setSubItems(subItems);
    }
}

