/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.fieldset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.aware.FieldsetItem;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.fieldset.FieldLabelAlign;
import net.n2oapp.framework.api.metadata.global.view.fieldset.FieldLabelLocation;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldSet;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetRow;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.api.metadata.meta.control.ControlDependency;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetVisibilityScope;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class AbstractFieldSetCompiler<D extends FieldSet, S extends N2oFieldSet>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    private static final String PROPERTY_PREFIX = "n2o.api.fieldset";

    protected void compileFieldSet(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        compiled.setLabel(p.resolveJS(source.getLabel()));
        compiled.setDescription(source.getDescription());
        compiled.setClassName(source.getCssClass());
        compiled.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        compiled.setProperties(p.mapAndResolveAttributes(source));
        compiled.setHelp(p.resolveJS(source.getHelp()));
        compiled.setBadge(BadgeUtil.compileSimpleBadge(source, (String)PROPERTY_PREFIX, (CompileProcessor)p));
        if (source.getFieldLabelLocation() != null) {
            compiled.setLabelPosition(FieldSet.LabelPosition.map((FieldLabelLocation)source.getFieldLabelLocation(), (FieldLabelAlign)source.getFieldLabelAlign()));
        }
        if (source.getFieldLabelAlign() != null) {
            compiled.setLabelAlignment(FieldSet.LabelAlignment.map((FieldLabelAlign)source.getFieldLabelAlign()));
        }
        compiled.setLabelWidth((Object)StringUtils.prepareSizeAttribute((String)source.getFieldLabelWidth()));
        compiled.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        compiled.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
        if (source.getDependsOn() != null) {
            ControlDependency[] dependency = new ControlDependency[1];
            ControlDependency dep = new ControlDependency();
            dep.setType(ValidationType.reRender);
            List<String> ons = Arrays.asList(source.getDependsOn());
            dep.setOn(ons);
            dependency[0] = dep;
            compiled.setDependency(dependency);
        }
        this.compileContent(compiled, source, context, p, scopes);
    }

    private void compileContent(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        if (source.getItems() == null) {
            return;
        }
        FieldSetVisibilityScope visibilityScope = this.initVisibilityScope(source, p);
        ArrayList<FieldSet.Row> rows = new ArrayList<FieldSet.Row>();
        for (FieldsetItem item : source.getItems()) {
            if (item instanceof N2oFieldsetRow) {
                rows.add((FieldSet.Row)p.compile((Object)item, context, new Object[]{visibilityScope, scopes}));
                continue;
            }
            N2oFieldsetRow newRow = new N2oFieldsetRow();
            newRow.setItems(new FieldsetItem[]{item});
            rows.add((FieldSet.Row)p.compile((Object)newRow, context, new Object[]{visibilityScope, scopes}));
        }
        compiled.setRows(rows);
    }

    private FieldSetVisibilityScope initVisibilityScope(S source, CompileProcessor p) {
        FieldSetVisibilityScope scope = new FieldSetVisibilityScope((FieldSetVisibilityScope)p.getScope(FieldSetVisibilityScope.class));
        if (source.getVisible() != null && !Objects.equals(source.getVisible(), "true")) {
            String value = p.resolveJS(source.getVisible());
            if (StringUtils.isJs((Object)value)) {
                scope.add(StringUtils.unwrapJs((String)value));
            } else {
                scope.add(value);
            }
        }
        return scope;
    }
}

