/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.Submit;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oMandatoryValidation;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesMode;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.SearchBarScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.QueryContextUtil;

public class DatasourceCompileStaticProcessor {
    public static final String SORTING = "sorting.";

    private DatasourceCompileStaticProcessor() {
        throw new IllegalStateException("Utility class");
    }

    public static CompiledQuery initQuery(String queryId, CompileProcessor p) {
        return queryId != null ? (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(queryId)) : null;
    }

    public static CompiledObject initObject(String objectId, String queryId, CompileProcessor p) {
        if (objectId != null) {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(objectId));
        }
        if (queryId != null) {
            return ((CompiledQuery)p.getCompiled((CompileContext)new QueryContext(queryId))).getObject();
        }
        return null;
    }

    public static N2oClientDataProvider initSubmit(Submit submit, String datasourceId, CompiledObject object, CompileProcessor p) {
        if (object == null) {
            throw new N2oException(String.format("For compilation submit for datasource [%s] is necessary object!", datasourceId));
        }
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        dataProvider.setMethod(RequestMethod.POST);
        dataProvider.setUrl(RouteUtil.normalize(submit.getRoute()));
        dataProvider.setTargetModel(ReduxModel.resolve);
        dataProvider.setPathParams(submit.getPathParams());
        dataProvider.setHeaderParams(submit.getHeaderParams());
        dataProvider.setFormParams(submit.getFormParams());
        dataProvider.setAutoSubmitOn(submit.getSubmitOn());
        N2oClientDataProvider.ActionContextData actionContextData = new N2oClientDataProvider.ActionContextData();
        actionContextData.setObjectId(object.getId());
        actionContextData.setOperationId(submit.getOperationId());
        actionContextData.setRoute(RouteUtil.normalize(submit.getRoute()));
        actionContextData.setMessageOnSuccess(((Boolean)CompileUtil.castDefault((Object)submit.getMessageOnSuccess(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.submit.message_on_success"), Boolean.class)})).booleanValue());
        actionContextData.setMessageOnFail(((Boolean)CompileUtil.castDefault((Object)submit.getMessageOnFail(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.submit.message_on_fail"), Boolean.class)})).booleanValue());
        actionContextData.setMessagePosition(submit.getMessagePosition());
        actionContextData.setMessagePlacement(submit.getMessagePlacement());
        actionContextData.setOperation((CompiledObject.Operation)object.getOperations().get(submit.getOperationId()));
        if (submit.getRefreshOnSuccess() != null) {
            actionContextData.setRefresh(new RefreshSaga());
            if (submit.getRefreshDatasourceIds() != null) {
                actionContextData.getRefresh().setDatasources(DatasourceUtil.getClientDatasourceIds(Arrays.asList(submit.getRefreshDatasourceIds()), p));
            }
        }
        dataProvider.setActionContextData(actionContextData);
        dataProvider.setSubmitForm((Boolean)CompileUtil.castDefault((Object)submit.getSubmitAll(), (Object)true, (Object[])new Boolean[0]));
        dataProvider.getActionContextData().setMessagesForm(submit.getMessageWidgetId());
        return dataProvider;
    }

    public static void compileSubmitClientDataProvider(N2oClientDataProvider source, ClientDataProvider submit, CompileContext<?, ?> context, CompileProcessor p) {
        String clientDatasourceId = source.getClientDatasourceId();
        ReduxModel targetModel = DatasourceCompileStaticProcessor.initTargetWidgetModel(p, source.getTargetModel());
        HashMap<String, ModelLink> pathMapping = new HashMap<String, ModelLink>(DatasourceCompileStaticProcessor.compileParams(source.getPathParams(), context, targetModel, clientDatasourceId));
        submit.setFormMapping(DatasourceCompileStaticProcessor.compileParams((N2oParam[])source.getFormParams(), context, targetModel, clientDatasourceId));
        submit.setHeadersMapping(DatasourceCompileStaticProcessor.compileParams(source.getHeaderParams(), context, targetModel, clientDatasourceId));
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        String path = (String)CompileUtil.castDefault((Object)(routeScope != null ? routeScope.getUrl() : null), (Supplier[])new Supplier[]{() -> context.getRoute((BindProcessor)((N2oCompileProcessor)p)), () -> ""});
        if (context.getPathRouteMapping() != null) {
            pathMapping.putAll(context.getPathRouteMapping());
        }
        path = RouteUtil.normalize(path + RouteUtil.normalize((String)CompileUtil.castDefault((Object)source.getUrl(), (Object)source.getDatasourceId(), (Object[])new String[0])));
        submit.setPathMapping(pathMapping);
        submit.setMethod(source.getMethod());
        submit.setOptimistic(source.getOptimistic());
        submit.setSubmitForm(source.getSubmitForm());
        ClientDataProviderUtil.initActionContext(source, pathMapping, path, p);
        submit.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + (String)CompileUtil.castDefault((Object)path, (Object)"", (Object[])new String[0]));
        submit.setQueryMapping(DatasourceCompileStaticProcessor.compileParams(source.getQueryParams(), context, targetModel, clientDatasourceId));
        submit.setQuickSearchParam(source.getQuickSearchParam());
        submit.setSize(source.getSize());
        submit.setAutoSubmitOn(source.getAutoSubmitOn());
    }

    public static void compileRoutes(String sourceId, String compiledId, List<Filter> filters, CompiledQuery query, CompileProcessor p) {
        PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
        if (routes == null) {
            return;
        }
        if (query == null) {
            return;
        }
        filters.stream().filter(Filter::getRoutable).filter(f -> !f.getLink().isConst()).forEach(filter -> routes.addQueryMapping(filter.getParam(), null, (BindLink)filter.getLink()));
        for (QuerySimpleField field : query.getSortingFields()) {
            String sortParam = RouteUtil.normalizeParam(SORTING + sourceId + "_" + field.getId());
            BindLink onSet = Redux.createSortLink(compiledId, field.getId());
            routes.addQueryMapping(sortParam, Redux.dispatchRoutableSortingLink(compiledId, field.getId(), sortParam, p), onSet);
        }
    }

    public static String getDatasourceRoute(String sourceId, String compiledId, String sourceRoute, CompileProcessor p) {
        ParentRouteScope parentRouteScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        String datasourceRoute = parentRouteScope != null && "/".equals(parentRouteScope.getUrl()) ? compiledId : sourceId;
        String route = (String)CompileUtil.castDefault((Object)RouteUtil.normalize(sourceRoute), (Supplier[])new Supplier[]{() -> RouteUtil.normalize(datasourceRoute)});
        return parentRouteScope != null ? RouteUtil.normalize(parentRouteScope.getUrl() + route) : route;
    }

    public static void initSearchBar(String datasourceId, List<Filter> filters, CompileProcessor p) {
        SearchBarScope searchBarScope = (SearchBarScope)p.getScope(SearchBarScope.class);
        if (searchBarScope == null || searchBarScope.getDatasource() == null || !searchBarScope.getDatasource().equals(datasourceId)) {
            return;
        }
        if (filters.stream().anyMatch(f -> f.getFilterId().equals(searchBarScope.getFilterId()) || f.getParam().equals(searchBarScope.getParam()))) {
            return;
        }
        Filter searchBarFilter = new Filter();
        searchBarFilter.setFilterId(searchBarScope.getFilterId());
        searchBarFilter.setParam(searchBarScope.getParam());
        searchBarFilter.setRoutable(Boolean.valueOf(true));
        ModelLink modelLink = new ModelLink(searchBarScope.getModelPrefix(), DatasourceUtil.getClientDatasourceId(datasourceId, p), searchBarScope.getFilterId());
        modelLink.setQueryParam(searchBarScope.getFilterId());
        searchBarFilter.setLink(modelLink);
        filters.add(searchBarFilter);
    }

    public static void initFiltersScope(String datasourceId, List<Filter> filters, CompileProcessor p) {
        FiltersScope filtersScope = (FiltersScope)p.getScope(FiltersScope.class);
        if (filtersScope == null) {
            return;
        }
        Map<String, Filter> filterMap = filters.stream().collect(Collectors.toMap(Filter::getFilterId, f -> f, (f1, f2) -> f2));
        filtersScope.getFilters(datasourceId).stream().filter(f -> !filterMap.containsKey(f.getFilterId())).forEach(filters::add);
    }

    public static void initMandatoryValidation(String datasourceId, N2oPreFilter preFilter, N2oQuery.Filter queryFilter, CompileContext<?, ?> context, CompileProcessor p) {
        if (!Boolean.TRUE.equals(preFilter.getRequired()) || p.getScope(ValidationScope.class) == null) {
            return;
        }
        N2oMandatoryValidation n2oMandatoryValidation = new N2oMandatoryValidation();
        n2oMandatoryValidation.setId(queryFilter.getFilterId());
        n2oMandatoryValidation.setMessage(p.getMessage("n2o.required.filter", new Object[0]));
        n2oMandatoryValidation.setFieldId(queryFilter.getFilterId());
        n2oMandatoryValidation.setServerMoment(N2oValidation.ServerMoment.beforeQuery);
        n2oMandatoryValidation.setSeverity(SeverityType.danger);
        MandatoryValidation v = (MandatoryValidation)p.compile((Object)n2oMandatoryValidation, context, new Object[0]);
        ValidationScope validationScope = (ValidationScope)p.getScope(ValidationScope.class);
        validationScope.add(datasourceId, ReduxModel.filter, (Validation)v);
    }

    public static QueryContext getQueryContext(String datasourceId, String datasourceCompiledId, String queryId, Integer size, DefaultValuesMode mode, CompileContext<?, ?> context, CompileProcessor p, String route, List<Filter> filters, CompiledQuery query) {
        CopiedFieldScope copiedFieldScope;
        QueryContext queryContext = new QueryContext(queryId, route, context.getUrlPattern());
        ValidationScope validationScope = (ValidationScope)p.getScope(ValidationScope.class);
        List<Validation> validations = validationScope == null ? null : validationScope.get(datasourceId, ReduxModel.filter);
        queryContext.setValidations(validations);
        queryContext.setFilters(filters);
        queryContext.setMode(mode);
        queryContext.setMessagesForm(datasourceCompiledId);
        queryContext.setQuerySize(size);
        queryContext.setSortingMap(QueryContextUtil.initSortingMap(query));
        SubModelsScope subModelsScope = (SubModelsScope)p.getScope(SubModelsScope.class);
        if (subModelsScope != null) {
            queryContext.setSubModelQueries(subModelsScope.get(datasourceId));
        }
        if ((copiedFieldScope = (CopiedFieldScope)p.getScope(CopiedFieldScope.class)) != null) {
            queryContext.setCopiedFields(copiedFieldScope.getCopiedFields(datasourceId));
        }
        return queryContext;
    }

    public static List<Filter> initFilters(String datasourceId, N2oPreFilter[] preFilters, CompileContext<?, ?> context, CompileProcessor p, CompiledQuery query) {
        if (query == null) {
            return null;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (preFilters != null) {
            for (N2oPreFilter preFilter : preFilters) {
                N2oQuery.Filter queryFilter = query.getFilterByPreFilter(preFilter);
                if (queryFilter == null) {
                    throw new N2oException("Pre-filter " + String.valueOf(preFilter) + " not found in query " + query.getId());
                }
                Filter filter = new Filter();
                DatasourceCompileStaticProcessor.initMandatoryValidation(datasourceId, preFilter, queryFilter, context, p);
                String queryParam = queryFilter.getParam();
                String param = (String)CompileUtil.castDefault((Object)preFilter.getParam(), (Supplier[])new Supplier[]{() -> datasourceId + "_" + queryParam});
                filter.setParam(param);
                filter.setRoutable((Boolean)CompileUtil.castDefault((Object)preFilter.getRoutable(), (Object)false, (Object[])new Boolean[0]));
                filter.setFilterId(queryFilter.getFilterId());
                ModelLink link = DatasourceCompileStaticProcessor.getFilterModelLink(datasourceId, preFilter, param, p);
                link.setQueryParam(queryParam);
                if (preFilter.getRequired() != null) {
                    link.setRequired(preFilter.getRequired().booleanValue());
                }
                filter.setLink(link);
                filters.add(filter);
            }
        }
        DatasourceCompileStaticProcessor.initSearchBar(datasourceId, filters, p);
        DatasourceCompileStaticProcessor.initFiltersScope(datasourceId, filters, p);
        return filters;
    }

    private static ModelLink getFilterModelLink(String datasourceId, N2oPreFilter preFilter, String filterParam, CompileProcessor p) {
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        if (routeScope != null && routeScope.getQueryMapping() != null && routeScope.getQueryMapping().containsKey(filterParam)) {
            return routeScope.getQueryMapping().get(filterParam);
        }
        Object prefilterValue = DatasourceCompileStaticProcessor.getPrefilterValue(preFilter);
        if (StringUtils.isJs((Object)prefilterValue)) {
            String clientDatasourceId = preFilter.getRefPageId() != null ? DatasourceUtil.getClientDatasourceId(preFilter.getDatasourceId(), preFilter.getRefPageId(), p) : DatasourceUtil.getClientDatasourceId(preFilter.getDatasourceId(), p);
            ReduxModel model = (ReduxModel)CompileUtil.castDefault((Object)preFilter.getModel(), (Object)ReduxModel.resolve, (Object[])new ReduxModel[0]);
            ModelLink link = new ModelLink(model, clientDatasourceId != null ? clientDatasourceId : DatasourceUtil.getClientDatasourceId(datasourceId, p));
            link.setValue(prefilterValue);
            link.setParam(filterParam);
            return link;
        }
        ModelLink link = new ModelLink(prefilterValue);
        link.setParam(filterParam);
        return link;
    }

    private static Object getPrefilterValue(N2oPreFilter n2oPreFilter) {
        if (n2oPreFilter.getValues() == null) {
            return ScriptProcessor.resolveExpression((String)n2oPreFilter.getValue());
        }
        return ScriptProcessor.resolveArrayExpression((String[])n2oPreFilter.getValues());
    }

    private static ReduxModel initTargetWidgetModel(CompileProcessor p, ReduxModel defaultModel) {
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope == null) {
            return defaultModel;
        }
        ModelAware modelAware = componentScope.unwrap(ModelAware.class);
        if (modelAware != null && modelAware.getModel() != null) {
            return modelAware.getModel();
        }
        return defaultModel;
    }

    private static Map<String, ModelLink> compileParams(N2oParam[] params, CompileContext<?, ?> context, ReduxModel model, String clientDatasourceId) {
        if (params == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ModelLink> result = new HashMap<String, ModelLink>();
        for (N2oParam param : params) {
            ModelLink link = param.getValueParam() == null ? DatasourceCompileStaticProcessor.getModelLink(model, clientDatasourceId, param) : DatasourceCompileStaticProcessor.getModelLinkByParam(context, param);
            result.put(param.getName(), link);
        }
        return result;
    }

    private static ModelLink getModelLink(ReduxModel model, String clientDatasourceId, N2oParam param) {
        Object value;
        Object object = value = param.getValueList() != null ? param.getValueList() : ScriptProcessor.resolveExpression((String)param.getValue());
        if (value != null && !StringUtils.isJs((Object)value)) {
            return new ModelLink(value);
        }
        ModelLink link = new ModelLink((ReduxModel)CompileUtil.castDefault((Object)param.getModel(), (Object)model, (Object[])new ReduxModel[0]), clientDatasourceId);
        link.setValue(value);
        return link;
    }

    private static ModelLink getModelLinkByParam(CompileContext<?, ?> context, N2oParam param) {
        ModelLink link;
        if (context.getPathRouteMapping() != null && context.getPathRouteMapping().containsKey(param.getValueParam())) {
            link = (ModelLink)context.getPathRouteMapping().get(param.getValueParam());
            link.setParam(param.getValueParam());
        } else if (context.getQueryRouteMapping() != null && context.getQueryRouteMapping().containsKey(param.getValueParam())) {
            link = (ModelLink)context.getQueryRouteMapping().get(param.getValueParam());
            link.setParam(param.getValueParam());
        } else {
            link = new ModelLink();
            link.setParam(param.getValueParam());
        }
        return link;
    }
}

