/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.dataprovider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.aware.WidgetIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePlacement;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePosition;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;

public class ClientDataProviderUtil {
    private ClientDataProviderUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ClientDataProvider compile(N2oClientDataProvider source, CompileContext<?, ?> context, CompileProcessor p) {
        ClientDataProvider dataProvider = new ClientDataProvider();
        String path = null;
        ReduxModel targetModel = ClientDataProviderUtil.getTargetActionModel(p, source.getTargetModel());
        if (RequestMethod.POST == source.getMethod() || RequestMethod.PUT == source.getMethod() || RequestMethod.DELETE == source.getMethod()) {
            HashMap<String, ModelLink> pathMapping = new HashMap<String, ModelLink>();
            pathMapping.putAll(ClientDataProviderUtil.compileParams(source.getPathParams(), context, p, targetModel, source.getClientDatasourceId()));
            dataProvider.setFormMapping(ClientDataProviderUtil.compileParams((N2oParam[])source.getFormParams(), context, p, targetModel, source.getClientDatasourceId()));
            dataProvider.setHeadersMapping(ClientDataProviderUtil.compileParams(source.getHeaderParams(), context, p, targetModel, source.getClientDatasourceId()));
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            path = (String)CompileUtil.castDefault((Object)(routeScope != null ? routeScope.getUrl() : null), (Supplier[])new Supplier[]{() -> context.getRoute((BindProcessor)((N2oCompileProcessor)p)), () -> ""});
            if (context.getPathRouteMapping() != null) {
                pathMapping.putAll(context.getPathRouteMapping());
            }
            path = RouteUtil.normalize(path + RouteUtil.normalize((String)CompileUtil.castDefault((Object)source.getUrl(), (Object)source.getId(), (Object[])new String[]{""})));
            dataProvider.setPathMapping(pathMapping);
            dataProvider.setMethod(source.getMethod());
            dataProvider.setOptimistic(source.getOptimistic());
            dataProvider.setSubmitForm(source.getSubmitForm());
            ClientDataProviderUtil.initActionContext(source, pathMapping, (String)CompileUtil.castDefault((Object)path, (Object)source.getUrl(), (Object[])new String[0]), p);
        }
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + (String)CompileUtil.castDefault(path, (Object)source.getUrl(), (Object[])new String[0]));
        dataProvider.setQueryMapping(ClientDataProviderUtil.compileParams(source.getQueryParams(), context, p, targetModel, source.getClientDatasourceId()));
        dataProvider.setQuickSearchParam(source.getQuickSearchParam());
        dataProvider.setSize(source.getSize());
        return dataProvider;
    }

    public static String getWidgetIdByComponentScope(CompileProcessor p) {
        WidgetIdAware widgetIdAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
            return widgetIdAware.getWidgetId();
        }
        return null;
    }

    private static Map<String, ModelLink> compileParams(N2oParam[] params, CompileContext<?, ?> context, CompileProcessor p, ReduxModel defaultModel, String defaultClientDatasourceId) {
        if (params == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, ModelLink> result = new LinkedHashMap<String, ModelLink>();
        for (N2oParam param : params) {
            ModelLink link = param.getValueParam() == null ? ClientDataProviderUtil.getModelLink(p, (ReduxModel)CompileUtil.castDefault((Object)param.getModel(), (Object)defaultModel, (Object[])new ReduxModel[0]), (String)CompileUtil.castDefault((Object)param.getDatasourceId(), (Object)defaultClientDatasourceId, (Object[])new String[0]), param) : ClientDataProviderUtil.getModelLinkByParam(context, param);
            if (param.getRequired() != null && param.getRequired().booleanValue()) {
                link.setRequired(true);
            }
            result.put(param.getName(), link);
        }
        return result;
    }

    private static ModelLink getModelLink(CompileProcessor p, ReduxModel model, String defaultClientDatasourceId, N2oParam param) {
        ModelLink link;
        Object value;
        Object object = value = param.getValueList() != null ? param.getValueList() : ScriptProcessor.resolveExpression((String)param.getValue());
        if (value == null || StringUtils.isJs((Object)value)) {
            String clientDatasourceId = param.getDatasourceId() == null ? defaultClientDatasourceId : (param.getRefPageId() != null ? DatasourceUtil.getClientDatasourceId(param.getDatasourceId(), param.getRefPageId(), p) : DatasourceUtil.getClientDatasourceId(param.getDatasourceId(), p));
            link = new ModelLink((ReduxModel)CompileUtil.castDefault((Object)param.getModel(), (Object)model, (Object[])new ReduxModel[0]), clientDatasourceId);
            link.setValue(value);
        } else {
            link = new ModelLink(value);
        }
        return link;
    }

    private static ModelLink getModelLinkByParam(CompileContext<?, ?> context, N2oParam param) {
        ModelLink link;
        if (context.getPathRouteMapping() != null && context.getPathRouteMapping().containsKey(param.getValueParam())) {
            link = (ModelLink)context.getPathRouteMapping().get(param.getValueParam());
            link.setParam(param.getValueParam());
        } else if (context.getQueryRouteMapping() != null && context.getQueryRouteMapping().containsKey(param.getValueParam())) {
            link = (ModelLink)context.getQueryRouteMapping().get(param.getValueParam());
            link.setParam(param.getValueParam());
        } else {
            link = new ModelLink();
            link.setParam(param.getValueParam());
        }
        return link;
    }

    public static void initActionContext(N2oClientDataProvider source, Map<String, ModelLink> pathMapping, String url, CompileProcessor p) {
        if (source.getActionContextData() != null) {
            PageScope pageScope;
            ValidationScope validationScope;
            N2oClientDataProvider.ActionContextData actionContextData = source.getActionContextData();
            ActionContext actionContext = new ActionContext(actionContextData.getObjectId(), actionContextData.getOperationId(), url);
            HashMap<String, ModelLink> routePathMapping = new HashMap<String, ModelLink>();
            LinkedHashMap<String, ModelLink> routeQueryMapping = new LinkedHashMap<String, ModelLink>();
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            if (routeScope != null) {
                routePathMapping.putAll(routeScope.getPathMapping());
                routePathMapping.putAll(pathMapping);
                routeQueryMapping.putAll(routeScope.getQueryMapping());
            }
            actionContext.setPathRouteMapping(routePathMapping);
            actionContext.setQueryRouteMapping(routeQueryMapping);
            ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
            if ((componentScope == null || componentScope.unwrap(N2oButton.class) == null || componentScope.unwrap(N2oButton.class).getValidate().booleanValue()) && (validationScope = (ValidationScope)p.getScope(ValidationScope.class)) != null) {
                actionContext.setValidations(validationScope.get(source.getDatasourceId(), ClientDataProviderUtil.getTargetActionModel(p, source.getTargetModel())));
            }
            actionContext.setRedirect(actionContextData.getRedirect());
            actionContext.setRefresh(actionContextData.getRefresh());
            actionContext.setLoading(actionContextData.getLoading());
            actionContext.setClearDatasource(actionContextData.getClearDatasource());
            if (actionContextData.getPolling() != null) {
                actionContext.setPolling(actionContextData.getPolling());
                actionContext.setPollingEndCondition(actionContextData.getPolling().getResult());
            }
            if ((pageScope = (PageScope)p.getScope(PageScope.class)) != null) {
                actionContext.setParentPageId(pageScope.getPageId());
            }
            actionContext.setParentClientWidgetId(actionContextData.getParentWidgetId());
            actionContext.setParentSourceDatasourceId(source.getDatasourceId());
            actionContext.setMessagesForm(actionContextData.getMessagesForm());
            actionContext.setMessageOnSuccess(actionContextData.isMessageOnSuccess());
            actionContext.setMessageOnFail((Boolean)CompileUtil.castDefault((Object)actionContextData.isMessageOnFail(), (Object)true, (Object[])new Boolean[0]));
            actionContext.setUseFailOut(actionContextData.isUseFailOut());
            actionContext.setMessagePosition((MessagePosition)CompileUtil.castDefault((Object)actionContextData.getMessagePosition(), (Supplier[])new Supplier[]{() -> (MessagePosition)p.resolve(Placeholders.property((String)"n2o.api.message.position"), MessagePosition.class)}));
            actionContext.setMessagePlacement((MessagePlacement)CompileUtil.castDefault((Object)actionContextData.getMessagePlacement(), (Supplier[])new Supplier[]{() -> (MessagePlacement)p.resolve(Placeholders.property((String)"n2o.api.message.placement"), MessagePlacement.class)}));
            HashSet formParams = new HashSet();
            if (source.getFormParams() != null) {
                Arrays.stream(source.getFormParams()).forEach(fp -> formParams.add(fp.getName()));
            }
            HashMap<String, String> operationMapping = new HashMap<String, String>();
            for (AbstractParameter inParameter : actionContextData.getOperation().getInParametersMap().values()) {
                String param;
                if (!(inParameter instanceof ObjectSimpleField) || (param = ((ObjectSimpleField)inParameter).getParam()) == null || formParams.contains(param)) continue;
                operationMapping.put(param, inParameter.getId());
            }
            actionContext.setOperationMapping(operationMapping);
            p.addRoute((CompileContext)actionContext);
        }
    }

    private static ReduxModel getTargetActionModel(CompileProcessor p, ReduxModel defaultModel) {
        ModelAware modelAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (modelAware = componentScope.unwrap(ModelAware.class)) != null && modelAware.getModel() != null) {
            return modelAware.getModel();
        }
        return defaultModel;
    }
}

