/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.HashMap;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.N2oMarkdown;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.meta.control.Markdown;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class MarkdownCompiler
extends FieldCompiler<Markdown, N2oMarkdown> {
    @Override
    protected String getSrcProperty() {
        return "n2o.api.control.markdown.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oMarkdown.class;
    }

    public Markdown compile(N2oMarkdown source, CompileContext<?, ?> context, CompileProcessor p) {
        Markdown field = new Markdown();
        if (source.getContent() != null) {
            String content = source.getContent();
            if (StringUtils.hasLink((String)content)) {
                content = content.replace("'", "\\'");
            }
            field.setContent(p.resolveJS(content.trim()));
        }
        if (!ArrayUtils.isEmpty((Object[])source.getActionIds())) {
            MetaActions metaActions = (MetaActions)p.getScope(MetaActions.class);
            field.setActions(new HashMap());
            for (String actionId : source.getActionIds()) {
                field.getActions().put(actionId, ActionCompileStaticProcessor.compileAction(((ActionBar)metaActions.get(actionId)).getN2oActions(), null, context, p, new Object[0]));
            }
        }
        this.initDefaults(source, context, p);
        this.compileField(field, source, context, p);
        return field;
    }
}

