/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.list.ListType;
import net.n2oapp.framework.api.metadata.control.list.N2oInputSelect;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.control.InputSelect;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.ListControlCompiler;
import org.springframework.stereotype.Component;

@Component
public class InputSelectCompiler
extends ListControlCompiler<InputSelect, N2oInputSelect> {
    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.input_select.src";
    }

    public StandardField<InputSelect> compile(N2oInputSelect source, CompileContext<?, ?> context, CompileProcessor p) {
        InputSelect inputSelect = new InputSelect();
        source.setSearch((Boolean)CompileUtil.castDefault((Object)source.getSearch(), (Supplier[])new Supplier[]{() -> source.getQueryId() != null}));
        inputSelect.setResetOnBlur((Boolean)CompileUtil.castDefault((Object)source.getResetOnBlur(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.input_select.reset_on_blur"), Boolean.class)}));
        inputSelect.setDescriptionFieldId(source.getDescriptionFieldId());
        inputSelect.setThrottleDelay((Integer)CompileUtil.castDefault((Object)source.getThrottleDelay(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.control.input_select.throttle_delay"), Integer.class)}));
        inputSelect.setSearchMinLength((Integer)CompileUtil.castDefault((Object)source.getSearchMinLength(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.control.input_select.search_min_length"), Integer.class)}));
        inputSelect.setMaxTagCount(source.getMaxTagCount());
        inputSelect.setMaxTagTextLength((Integer)CompileUtil.castDefault((Object)source.getMaxTagTextLength(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.control.input_select.max_tag_text_length"), Integer.class)}));
        ListType type = (ListType)CompileUtil.castDefault((Object)source.getType(), (Object)ListType.SINGLE, (Object[])new ListType[0]);
        switch (type) {
            case CHECKBOXES: {
                inputSelect.setClosePopupOnSelect(Boolean.valueOf(false));
                inputSelect.setHasCheckboxes(Boolean.valueOf(true));
                inputSelect.setMultiSelect(Boolean.valueOf(true));
                break;
            }
            case MULTI: {
                inputSelect.setClosePopupOnSelect(Boolean.valueOf(false));
                inputSelect.setHasCheckboxes(Boolean.valueOf(false));
                inputSelect.setMultiSelect(Boolean.valueOf(true));
                break;
            }
            case SINGLE: {
                inputSelect.setHasCheckboxes(Boolean.valueOf(false));
                inputSelect.setMultiSelect(Boolean.valueOf(false));
            }
        }
        return this.compileListControl(inputSelect, source, context, p);
    }

    public Class<? extends Source> getSourceClass() {
        return N2oInputSelect.class;
    }
}

