/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oActionField;
import net.n2oapp.framework.api.metadata.control.N2oImageField;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oImageStatusElement;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.cell.ImageStatusElement;
import net.n2oapp.framework.api.metadata.meta.cell.ImageStatusElementPlace;
import net.n2oapp.framework.api.metadata.meta.control.ActionField;
import net.n2oapp.framework.api.metadata.meta.control.ImageField;
import net.n2oapp.framework.api.metadata.meta.control.TextPosition;
import net.n2oapp.framework.config.metadata.compile.control.ActionFieldCompiler;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class ImageFieldCompiler
extends ActionFieldCompiler<ImageField, N2oImageField> {
    public Class<? extends Source> getSourceClass() {
        return N2oImageField.class;
    }

    public ImageField compile(N2oImageField source, CompileContext<?, ?> context, CompileProcessor p) {
        ImageField imageField = new ImageField();
        this.initDefaults(source, context, p);
        this.compileField(imageField, source, context, p);
        imageField.setData((String)CompileUtil.castDefault((Object)p.resolveJS(source.getData()), (Supplier[])new Supplier[]{() -> StringUtils.hasLink((String)source.getUrl()) ? p.resolveJS(source.getUrl()) : RouteUtil.normalize(source.getUrl())}));
        imageField.setTitle(p.resolveJS(source.getTitle()));
        imageField.setDescription(p.resolveJS(source.getDescription()));
        imageField.setTextPosition((TextPosition)CompileUtil.castDefault((Object)source.getTextPosition(), (Supplier[])new Supplier[]{() -> (TextPosition)p.resolve(Placeholders.property((String)"n2o.api.control.image.text_position"), TextPosition.class)}));
        imageField.setWidth(StringUtils.prepareSizeAttribute((String)((String)CompileUtil.castDefault((Object)source.getWidth(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.image.width"), String.class)}))));
        imageField.setShape((ShapeType)CompileUtil.castDefault((Object)source.getShape(), (Supplier[])new Supplier[]{() -> (ShapeType)p.resolve(Placeholders.property((String)"n2o.api.control.image.shape"), ShapeType.class)}));
        imageField.setStatuses(this.compileStatuses(source.getStatuses(), p));
        this.compileAction((N2oActionField)source, (ActionField)imageField, context, p);
        return imageField;
    }

    private ImageStatusElement[] compileStatuses(N2oImageStatusElement[] statuses, CompileProcessor p) {
        if (statuses == null) {
            return null;
        }
        int i = 0;
        ImageStatusElement[] statusElements = new ImageStatusElement[statuses.length];
        for (N2oImageStatusElement e : statuses) {
            ImageStatusElement statusElement = new ImageStatusElement();
            statusElement.setSrc((String)CompileUtil.castDefault((Object)e.getSrc(), (Object)"Status", (Object[])new String[0]));
            statusElement.setFieldId(e.getFieldId());
            statusElement.setIcon(p.resolveJS(e.getIcon()));
            statusElement.setPlace((ImageStatusElementPlace)CompileUtil.castDefault((Object)e.getPlace(), (Supplier[])new Supplier[]{() -> (ImageStatusElementPlace)p.resolve(Placeholders.property((String)"n2o.api.control.image.status.place"), ImageStatusElementPlace.class)}));
            statusElements[i++] = statusElement;
        }
        return statusElements;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.control.image.src";
    }
}

