/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.PageRef;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oFilterColumn;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.control.ControlDependency;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.EnablingDependency;
import net.n2oapp.framework.api.metadata.meta.control.FetchValueDependency;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Group;
import net.n2oapp.framework.api.script.ScriptParserException;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetVisibilityScope;
import net.n2oapp.framework.config.metadata.compile.fieldset.MultiFieldSetScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.TableFiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.FieldCompileUtil;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;

public abstract class FieldCompiler<D extends Field, S extends N2oField>
extends ComponentCompiler<D, S, CompileContext<?, ?>> {
    private static final Pattern EXT_EXPRESSION_PATTERN = Pattern.compile(".*\\(.*\\).*");

    @Override
    protected String getSrcProperty() {
        return "n2o.api.field.src";
    }

    protected void initDefaults(S source, CompileContext<?, ?> context, CompileProcessor p) {
        source.setNoLabel((String)CompileUtil.castDefault((Object)source.getNoLabel(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.no_label"), String.class)}));
        source.setNoLabelBlock((String)CompileUtil.castDefault((Object)source.getNoLabelBlock(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.no_label_block"), String.class)}));
        source.setRefPage((PageRef)CompileUtil.castDefault((Object)source.getRefPage(), (Object)PageRef.THIS, (Object[])new PageRef[0]));
        source.setRefDatasourceId((String)CompileUtil.castDefault((Object)source.getRefDatasourceId(), (Supplier[])new Supplier[]{() -> {
            if (source.getRefPage().equals((Object)PageRef.THIS)) {
                return this.initLocalDatasourceId(p);
            }
            if (source.getRefPage().equals((Object)PageRef.PARENT)) {
                if (context instanceof PageContext) {
                    PageContext pageContext = (PageContext)context;
                    return pageContext.getParentLocalDatasourceId();
                }
                throw new N2oException(String.format("\u041f\u043e\u043b\u0435 '%s' \u0438\u043c\u0435\u0435\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'ref-page=parent', \u043d\u043e PageContext \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", source.getId()));
            }
            return null;
        }}));
        source.setRefModel((ReduxModel)CompileUtil.castDefault((Object)source.getRefModel(), (Supplier[])new Supplier[]{() -> Optional.ofNullable((WidgetScope)p.getScope(WidgetScope.class)).map(WidgetScope::getModel).orElse(null), () -> ReduxModel.resolve}));
        this.initCondition(source, () -> source.getVisible(), (N2oField.Dependency)new N2oField.VisibilityDependency(), b -> source.setVisible(b.toString()), !"false".equals(source.getVisible()));
        this.initCondition(source, () -> source.getEnabled(), (N2oField.Dependency)new N2oField.EnablingDependency(), b -> source.setEnabled(b.toString()), !"false".equals(source.getEnabled()));
        this.initCondition(source, () -> source.getRequired(), (N2oField.Dependency)new N2oField.RequiringDependency(), b -> source.setRequired(b.toString()), "true".equals(source.getRequired()));
    }

    protected void compileField(D field, S source, CompileContext<?, ?> context, CompileProcessor p) {
        this.compileComponent(field, source, p);
        IndexScope idx = (IndexScope)p.getScope(IndexScope.class);
        field.setId((String)CompileUtil.castDefault((Object)source.getId(), (Supplier[])new Supplier[]{() -> "f" + idx.get()}));
        field.setLabel(this.initLabel(source, p));
        field.setNoLabel(StringUtils.isBoolean((String)source.getNoLabel()) ? Boolean.valueOf(source.getNoLabel()) : p.resolveJS(source.getNoLabel()));
        field.setNoLabelBlock(StringUtils.isBoolean((String)source.getNoLabelBlock()) ? Boolean.valueOf(source.getNoLabelBlock()) : p.resolveJS(source.getNoLabelBlock()));
        field.setLabelClass(p.resolveJS(source.getLabelClass()));
        field.setHelp(p.resolveJS(source.getHelp()));
        field.setDescription(p.resolveJS(source.getDescription()));
        field.setClassName(p.resolveJS(source.getCssClass()));
        field.setRequired((Boolean)p.resolve(source.getRequired(), Boolean.class));
        field.setVisible((Boolean)p.resolve(source.getVisible(), Boolean.class));
        field.setEnabled((Boolean)p.resolve(source.getEnabled(), Boolean.class));
        this.compileFieldToolbar(field, source, context, p);
        this.compileDependencies((Field)field, source, context, p);
    }

    private void initCondition(S source, Supplier<String> conditionGetter, N2oField.Dependency dependency, Consumer<Boolean> conditionSetter, Boolean defaultValue) {
        if (StringUtils.isLink((Object)conditionGetter.get())) {
            try {
                Set onFields = ScriptProcessor.extractVars((String)conditionGetter.get());
                dependency.setOn((String[])onFields.toArray(String[]::new));
            }
            catch (ScriptParserException e) {
                throw new N2oException(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 \u0438\u0437 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f '%s'. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u0435\u0439 \u0441 \u044f\u0432\u043d\u044b\u043c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435\u043c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0435 'on'", StringUtils.unwrapLink((String)conditionGetter.get())));
            }
            dependency.setValue(StringUtils.unwrapLink((String)conditionGetter.get()));
            source.addDependency(dependency);
            conditionSetter.accept(false);
        } else {
            conditionSetter.accept(defaultValue);
        }
    }

    protected String initLabel(S source, CompileProcessor p) {
        if (!"true".equals(source.getNoLabel())) {
            return p.resolveJS(source.getLabel());
        }
        return null;
    }

    protected void compileDependencies(Field field, S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getDependencies() != null) {
            for (N2oField.Dependency d : source.getDependencies()) {
                ControlDependency dependency = this.compileControlDependency(field, d, p, context);
                this.addToField(dependency, field, d, p);
            }
        }
        if (source.getDependsOn() != null) {
            ControlDependency dependency = new ControlDependency();
            List<String> ons = Arrays.asList(source.getDependsOn());
            dependency.setOn(ons);
            dependency.setType(ValidationType.reRender);
            field.addDependency(dependency);
        }
    }

    private void addToField(ControlDependency compiled, Field field, N2oField.Dependency source, CompileProcessor p) {
        compiled.setApplyOnInit((Boolean)CompileUtil.castDefault((Object)source.getApplyOnInit(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.dependency.apply_on_init"), Boolean.class)}));
        if (Boolean.TRUE.equals(compiled.getApplyOnInit())) {
            if (source instanceof N2oField.VisibilityDependency) {
                field.setVisible(Boolean.valueOf(false));
            } else if (source instanceof N2oField.EnablingDependency) {
                field.setEnabled(Boolean.valueOf(false));
            }
        }
        if (source.getOn() != null) {
            List<String> ons = Arrays.asList(source.getOn());
            compiled.getOn().addAll(ons);
        }
        field.addDependency(compiled);
    }

    private void compileFieldToolbar(D field, S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getToolbar() != null) {
            Toolbar toolbar = (Toolbar)p.compile((Object)source.getToolbar(), context, new Object[0]);
            field.setToolbar((Group[])toolbar.getGroups().toArray(Group[]::new));
        }
    }

    private ControlDependency compileControlDependency(Field field, N2oField.Dependency source, CompileProcessor p, CompileContext<?, ?> context) {
        ControlDependency dependency = new ControlDependency();
        if (source instanceof N2oField.FetchValueDependency) {
            N2oField.FetchValueDependency fetchValue = (N2oField.FetchValueDependency)source;
            FetchValueDependency fetchValueDependency = new FetchValueDependency();
            fetchValueDependency.setType(ValidationType.fetchValue);
            fetchValueDependency.setValueFieldId(fetchValue.getValueFieldId());
            fetchValueDependency.setDataProvider(this.compileFetchDependencyDataProvider((N2oField.FetchValueDependency)source, context, p));
            return fetchValueDependency;
        }
        if (source instanceof N2oField.EnablingDependency) {
            N2oField.EnablingDependency enabling = (N2oField.EnablingDependency)source;
            EnablingDependency enablingDependency = new EnablingDependency();
            enablingDependency.setType(ValidationType.enabled);
            enablingDependency.setMessage(enabling.getMessage());
            dependency = enablingDependency;
        } else if (source instanceof N2oField.RequiringDependency) {
            dependency.setType(ValidationType.required);
        } else if (source instanceof N2oField.VisibilityDependency) {
            N2oField.VisibilityDependency visibility = (N2oField.VisibilityDependency)source;
            dependency.setType(ValidationType.visible);
            Boolean isResettable = (Boolean)CompileUtil.castDefault((Object)visibility.getReset(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.dependency.visibility.reset"), Boolean.class)});
            if (Boolean.TRUE.equals(isResettable)) {
                ControlDependency reset = new ControlDependency();
                reset.setType(ValidationType.reset);
                reset.setExpression(ScriptProcessor.resolveFunction((String)source.getValue()));
                this.addToField(reset, field, source, p);
            }
        } else if (source instanceof N2oField.SetValueDependency) {
            dependency.setType(ValidationType.setValue);
        } else if (source instanceof N2oField.FetchDependency) {
            dependency.setType(ValidationType.fetch);
        } else if (source instanceof N2oField.ResetDependency) {
            dependency.setType(ValidationType.reset);
            if (source.getValue() == null) {
                source.setValue(String.valueOf(Boolean.TRUE));
            }
        }
        dependency.setExpression(ScriptProcessor.resolveFunction((String)source.getValue()));
        return dependency;
    }

    private ClientDataProvider compileFetchDependencyDataProvider(N2oField.FetchValueDependency field, CompileContext<?, ?> context, CompileProcessor p) {
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromField(field.getPreFilters(), field.getQueryId(), p);
        dataProvider.setSize(field.getSize());
        return ClientDataProviderUtil.compile(dataProvider, context, p);
    }

    protected void compileFilters(S source, CompileProcessor p) {
        TableFiltersScope filtersScope = (TableFiltersScope)p.getScope(TableFiltersScope.class);
        if (filtersScope != null) {
            CompiledQuery query = (CompiledQuery)p.getScope(CompiledQuery.class);
            if (query == null) {
                return;
            }
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            List<N2oQuery.Filter> filters = FieldCompileUtil.getFilters(source.getId(), query);
            filters.forEach(f -> {
                Filter filter = new Filter();
                filter.setFilterId(f.getFilterId());
                filter.setParam((String)CompileUtil.castDefault((Object)source.getParam(), (Supplier[])new Supplier[]{() -> widgetScope.getWidgetId() + "_" + f.getParam()}));
                filter.setRoutable(Boolean.valueOf(true));
                SubModelQuery subModelQuery = this.findSubModelQuery(source.getId(), p);
                ModelLink link = new ModelLink(ReduxModel.filter, widgetScope.getClientDatasourceId());
                link.setSubModelQuery(subModelQuery);
                link.setValue((Object)p.resolveJS(Placeholders.ref((String)f.getFilterId())));
                link.setParam(filter.getParam());
                link.setObserve(true);
                filter.setLink(link);
                filtersScope.addFilter(filter);
            });
        }
    }

    protected SubModelQuery findSubModelQuery(String fieldId, CompileProcessor p) {
        if (fieldId == null) {
            return null;
        }
        SubModelsScope subModelsScope = (SubModelsScope)p.getScope(SubModelsScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (subModelsScope != null && widgetScope != null && subModelsScope.get(widgetScope.getDatasourceId()) != null) {
            String fullFieldId = this.getIdWithMultisetPrefix(fieldId, p);
            return subModelsScope.get(widgetScope.getDatasourceId()).stream().filter(subModelQuery -> fullFieldId.equals(subModelQuery.getFullName())).findAny().orElse(null);
        }
        return null;
    }

    protected void initValidations(S source, Field field, CompileContext<?, ?> context, CompileProcessor p) {
        Set<String> visibilityConditions = p.getScope(FieldSetVisibilityScope.class) != null ? ((FieldSetVisibilityScope)p.getScope(FieldSetVisibilityScope.class)).getConditions() : Collections.emptySet();
        String fieldId = this.getIdWithMultisetPrefix(field.getId(), p);
        List<Validation> fieldValidations = this.initInlineValidations(fieldId, source, context, p, visibilityConditions);
        ArrayList<Validation> validations = new ArrayList<Validation>(fieldValidations);
        Optional<Validation> mandatory = fieldValidations.stream().filter(MandatoryValidation.class::isInstance).findFirst();
        if (mandatory.isEmpty()) {
            Validation requiredValidation = this.initRequiredValidation(fieldId, field, source, p, visibilityConditions);
            if (requiredValidation != null) {
                validations.add(requiredValidation);
            } else {
                N2oFilterColumn component;
                ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
                if (componentScope != null && (component = componentScope.unwrap(N2oFilterColumn.class)) != null) {
                    validations.forEach(v -> v.addEnablingCondition(String.format("%s || %s === 0", source.getId(), source.getId())));
                }
            }
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        ValidationScope validationScope = (ValidationScope)p.getScope(ValidationScope.class);
        if (widgetScope != null && validationScope != null) {
            validationScope.addAll(widgetScope.getDatasourceId(), widgetScope.getModel(), validations);
        }
    }

    private Validation initRequiredValidation(String fieldId, Field field, S source, CompileProcessor p, Set<String> visibilityConditions) {
        String requiredMessage;
        MomentScope momentScope = (MomentScope)p.getScope(MomentScope.class);
        String string = requiredMessage = momentScope != null && N2oValidation.ServerMoment.beforeQuery.equals((Object)momentScope.getMoment()) ? "n2o.required.filter" : "n2o.required.field";
        if (source.containsDependency(N2oField.RequiringDependency.class)) {
            MandatoryValidation mandatory = new MandatoryValidation(fieldId, p.getMessage(requiredMessage, new Object[0]), fieldId);
            if (momentScope != null) {
                mandatory.setMoment(momentScope.getMoment());
            }
            mandatory.addEnablingConditions(visibilityConditions);
            mandatory.addEnablingConditions(this.collectConditions(source, N2oField.RequiringDependency.class, N2oField.EnablingDependency.class, N2oField.VisibilityDependency.class));
            if (mandatory.getEnablingConditions() != null && !mandatory.getEnablingConditions().isEmpty()) {
                return mandatory;
            }
        } else if ("true".equals(source.getRequired())) {
            MandatoryValidation mandatory = new MandatoryValidation(fieldId, p.getMessage(requiredMessage, new Object[0]), fieldId);
            if (momentScope != null) {
                mandatory.setMoment(momentScope.getMoment());
            }
            mandatory.addEnablingConditions(visibilityConditions);
            mandatory.addEnablingConditions(this.collectConditions(source, N2oField.VisibilityDependency.class, N2oField.EnablingDependency.class));
            field.setRequired(Boolean.valueOf(true));
            return mandatory;
        }
        return null;
    }

    private List<Validation> initInlineValidations(String fieldId, S source, CompileContext<?, ?> context, CompileProcessor p, Set<String> visibilityConditions) {
        ArrayList<Validation> result = new ArrayList<Validation>();
        N2oField.Validations validations = source.getValidations();
        if (validations == null) {
            return result;
        }
        if (validations.getWhiteList() != null) {
            for (String validation : validations.getWhiteList()) {
                Validation compiledValidation = this.initWhiteListValidation(fieldId, validation, source, p, visibilityConditions);
                if (compiledValidation == null) continue;
                result.add(compiledValidation);
            }
        }
        if (validations.getInlineValidations() != null) {
            ArrayList<String> fieldVisibilityConditions = new ArrayList<String>();
            if (source.getDependencies() != null) {
                for (N2oField.Dependency dependency : source.getDependencies()) {
                    if (!dependency.getClass().equals(N2oField.VisibilityDependency.class) && !dependency.getClass().equals(N2oField.EnablingDependency.class)) continue;
                    fieldVisibilityConditions.add(dependency.getValue());
                }
            } else if ("false".equals(source.getVisible()) || "false".equals(source.getEnabled())) {
                fieldVisibilityConditions.add("false");
            }
            for (N2oValidation v : validations.getInlineValidations()) {
                if (v.getFieldId() == null) {
                    v.setFieldId(fieldId);
                }
                Validation compiledValidation = (Validation)p.compile((Object)v, context, new Object[0]);
                MomentScope momentScope = (MomentScope)p.getScope(MomentScope.class);
                if (momentScope != null) {
                    compiledValidation.setMoment(momentScope.getMoment());
                }
                if (!fieldVisibilityConditions.isEmpty()) {
                    compiledValidation.addEnablingConditions(fieldVisibilityConditions);
                }
                compiledValidation.addEnablingConditions(visibilityConditions);
                result.add(compiledValidation);
            }
        }
        return result;
    }

    private Validation initWhiteListValidation(String fieldId, String refId, S source, CompileProcessor p, Set<String> visibilityConditions) {
        CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
        if (object == null) {
            return null;
        }
        Validation objectValidation = null;
        if (object.getValidationsMap() != null && object.getValidationsMap().containsKey(refId)) {
            objectValidation = (Validation)object.getValidationsMap().get(refId);
        } else if (object.getOperations() != null && !object.getOperations().isEmpty()) {
            for (CompiledObject.Operation operation : object.getOperations().values()) {
                Optional<Validation> result = operation.getValidationList().stream().filter(v -> v.getId().equals(refId)).findFirst();
                if (!result.isPresent()) continue;
                objectValidation = result.get();
                break;
            }
        }
        if (objectValidation == null) {
            throw new N2oException(String.format("\u041f\u043e\u043b\u0435 '%s' \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044e", fieldId));
        }
        ConstraintValidation validation = null;
        if (objectValidation instanceof ConstraintValidation) {
            ConstraintValidation constraint = (ConstraintValidation)objectValidation;
            validation = new ConstraintValidation(constraint);
        } else if (objectValidation instanceof ConditionValidation) {
            ConditionValidation condition = (ConditionValidation)objectValidation;
            validation = new ConditionValidation(condition);
        } else if (objectValidation instanceof MandatoryValidation) {
            MandatoryValidation mandatory = (MandatoryValidation)objectValidation;
            validation = new MandatoryValidation(mandatory);
        }
        if (validation == null) {
            return null;
        }
        ArrayList<String> enablingConditions = new ArrayList<String>();
        if (source.getDependencies() != null) {
            for (N2oField.Dependency dependency : source.getDependencies()) {
                if (!(dependency instanceof N2oField.VisibilityDependency)) continue;
                enablingConditions.add(dependency.getValue());
            }
        }
        validation.setFieldId(fieldId);
        validation.addEnablingConditions(enablingConditions);
        validation.addEnablingConditions(visibilityConditions);
        return validation;
    }

    private List<String> collectConditions(S source, Class ... types) {
        ArrayList<String> result = new ArrayList<String>();
        if (source.getDependencies() != null && types != null) {
            for (N2oField.Dependency dependency : source.getDependencies()) {
                for (Class clazz : types) {
                    if (!dependency.getClass().equals(clazz)) continue;
                    result.add(ScriptProcessor.resolveFunction((String)dependency.getValue()));
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    protected void compileCopied(S source, CompileProcessor p) {
        if (Boolean.TRUE.equals(source.getCopied())) {
            CopiedFieldScope scope = (CopiedFieldScope)p.getScope(CopiedFieldScope.class);
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            if (scope != null && widgetScope != null) {
                scope.addCopiedFields(source.getId(), widgetScope.getDatasourceId());
            }
        }
    }

    protected void compileDefaultValues(D control, S source, CompileContext<?, ?> context, CompileProcessor p) {
        ModelsScope defaultValues;
        WidgetParamScope paramScope = (WidgetParamScope)p.getScope(WidgetParamScope.class);
        if (paramScope != null) {
            this.compileParams(control, source, paramScope, p);
        }
        if ((defaultValues = (ModelsScope)p.getScope(ModelsScope.class)) != null && defaultValues.hasModels()) {
            String controlId = this.getIdWithMultisetPrefix(control.getId(), p);
            Object defValue = source.getDefaultValue() != null ? p.resolve(source.getDefaultValue(), source.getDomain()) : this.compileDefValues(source, p);
            if (defValue != null) {
                if (defValue instanceof String) {
                    String strDefValue = (String)defValue;
                    defValue = ScriptProcessor.resolveExpression((String)strDefValue);
                }
                if (StringUtils.isJs((Object)defValue)) {
                    ModelLink defaultValue = this.getDefaultValueModelLink(source, context, p);
                    if (source.getRefFieldId() == null) {
                        defaultValue.setValue(defValue);
                    }
                    if (this.isExternalExpression((String)defValue)) {
                        defaultValue.setObserve(false);
                    }
                    defaultValue.setParam(source.getParam());
                    defaultValues.add(controlId, defaultValue);
                } else {
                    DefaultValues defVals;
                    Map values;
                    SubModelQuery subModelQuery = this.findSubModelQuery(control.getId(), p);
                    ModelLink modelLink = this.getDefaultValueModelLink(source, context, p);
                    if (defValue instanceof DefaultValues && (values = (defVals = (DefaultValues)defValue).getValues()) != null) {
                        for (Map.Entry entry : values.entrySet()) {
                            String strValue;
                            Object value;
                            Object v = entry.getValue();
                            if (!(v instanceof String) || (value = ScriptProcessor.resolveExpression((String)(strValue = (String)v))) == null) continue;
                            values.put((String)entry.getKey(), value);
                        }
                    }
                    modelLink.setValue(defValue);
                    modelLink.setSubModelQuery(subModelQuery);
                    modelLink.setParam(source.getParam());
                    defaultValues.add(controlId, modelLink);
                }
            } else if (PageRef.PARENT.equals((Object)source.getRefPage()) || source.getRefFieldId() != null) {
                ModelLink modelLink = this.getDefaultValueModelLink(source, context, p);
                modelLink.setParam(source.getParam());
                defaultValues.add(controlId, modelLink);
            }
        }
    }

    protected Object compileDefValues(S source, CompileProcessor p) {
        return null;
    }

    protected void compileParams(D control, S source, WidgetParamScope paramScope, CompileProcessor p) {
        WidgetScope widgetScope;
        if (source.getParam() != null && (widgetScope = (WidgetScope)p.getScope(WidgetScope.class)) != null) {
            ModelLink onSet = new ModelLink(widgetScope.getModel(), widgetScope.getClientDatasourceId(), control.getId());
            onSet.setParam(source.getParam());
            ReduxAction onGet = Redux.dispatchUpdateModel(widgetScope.getClientDatasourceId(), widgetScope.getModel(), control.getId(), Placeholders.colon((String)source.getParam()));
            paramScope.addQueryMapping(source.getParam(), onGet, (BindLink)onSet);
        }
    }

    private ModelLink getDefaultValueModelLink(S source, CompileContext<?, ?> context, CompileProcessor p) {
        ModelLink defaultValue;
        String clientDatasourceId = null;
        switch (source.getRefPage()) {
            case THIS: {
                clientDatasourceId = DatasourceUtil.getClientDatasourceId(source.getRefDatasourceId(), p);
                break;
            }
            case PARENT: {
                if (context instanceof PageContext) {
                    PageContext pageContext = (PageContext)context;
                    clientDatasourceId = DatasourceUtil.getClientDatasourceId(source.getRefDatasourceId(), pageContext.getParentClientPageId(), p);
                    break;
                }
                throw new N2oException(String.format("\u041f\u043e\u043b\u0435 '%s' \u0438\u043c\u0435\u0435\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'ref-page=parent', \u043d\u043e PageContext \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", source.getId()));
            }
        }
        if (source.getRefFieldId() != null) {
            defaultValue = new ModelLink(source.getRefModel(), clientDatasourceId, source.getRefFieldId());
        } else {
            defaultValue = new ModelLink(source.getRefModel(), clientDatasourceId);
            defaultValue.setValue((Object)p.resolveJS(source.getDefaultValue()));
        }
        if (PageRef.THIS.equals((Object)source.getRefPage())) {
            defaultValue.setObserve(true);
        }
        return defaultValue;
    }

    private boolean isExternalExpression(String expression) {
        return EXT_EXPRESSION_PATTERN.matcher(expression).find();
    }

    protected String initLocalDatasourceId(CompileProcessor p) {
        DatasourceIdAware datasourceIdAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (datasourceIdAware = componentScope.unwrap(DatasourceIdAware.class)) != null) {
            return datasourceIdAware.getDatasourceId();
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getDatasourceId();
        }
        return null;
    }

    private String getIdWithMultisetPrefix(String fieldId, CompileProcessor p) {
        return p.getScope(MultiFieldSetScope.class) == null ? fieldId : ((MultiFieldSetScope)p.getScope(MultiFieldSetScope.class)).getPathWithIndexes() + "." + fieldId;
    }
}

