/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oCodeViewer;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.control.CodeViewer;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import org.springframework.stereotype.Component;

@Component
public class CodeViewerCompiler
extends StandardFieldCompiler<CodeViewer, N2oCodeViewer> {
    public Class<? extends Source> getSourceClass() {
        return N2oCodeViewer.class;
    }

    public StandardField<CodeViewer> compile(N2oCodeViewer source, CompileContext<?, ?> context, CompileProcessor p) {
        CodeViewer codeViewer = new CodeViewer();
        if (source.getText() != null) {
            codeViewer.setText(source.getText().trim().replaceAll("\n( )+", "\n"));
        }
        codeViewer.setLanguage(source.getLanguage());
        N2oCodeViewer.ColorTheme theme = (N2oCodeViewer.ColorTheme)CompileUtil.castDefault((Object)source.getTheme(), (Supplier[])new Supplier[]{() -> (N2oCodeViewer.ColorTheme)p.resolve(Placeholders.property((String)"n2o.api.control.code.theme"), N2oCodeViewer.ColorTheme.class)});
        codeViewer.setDarkTheme(Boolean.valueOf(theme.equals((Object)N2oCodeViewer.ColorTheme.dark)));
        codeViewer.setShowLineNumbers((Boolean)CompileUtil.castDefault((Object)source.getShowLineNumbers(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.code.show_line_numbers"), Boolean.class)}));
        codeViewer.setStartingLineNumber((Integer)CompileUtil.castDefault((Object)source.getStartingLineNumber(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.control.code.starting_line_number"), Integer.class)}));
        codeViewer.setHideButtons((Boolean)CompileUtil.castDefault((Object)source.getHideButtons(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.code.hide_buttons"), Boolean.class)}));
        return this.compileStandardField(codeViewer, source, context, p);
    }

    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.code_viewer.src";
    }
}

