/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.saga.LoadingSaga;
import net.n2oapp.framework.api.metadata.meta.saga.PollingSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePlacement;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePosition;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;

public class ActionContext
extends ObjectContext {
    private String operationId;
    private List<Validation> validations;
    private String parentPageId;
    private String parentClientWidgetId;
    private String parentSourceDatasourceId;
    private String messagesForm;
    private String clearDatasource;
    private String pollingEndCondition;
    private PollingSaga polling;
    private LoadingSaga loading;
    private RedirectSaga redirect;
    private RefreshSaga refresh;
    private boolean messageOnSuccess = true;
    private boolean messageOnFail = true;
    private boolean useFailOut;
    private MessagePosition messagePosition;
    private MessagePlacement messagePlacement;
    private Map<String, String> operationMapping;

    public ActionContext(String objectId, String operationId, String route) {
        super(objectId, route);
        this.operationId = operationId;
    }

    public void setRedirect(RedirectSaga redirect) {
        if (redirect == null) {
            return;
        }
        this.redirect = new RedirectSaga();
        this.redirect.setPath(redirect.getPath());
        this.redirect.setPathMapping(new HashMap(redirect.getPathMapping()));
        this.redirect.setQueryMapping(new HashMap(redirect.getQueryMapping()));
        this.redirect.setTarget(redirect.getTarget());
        this.redirect.setServer(redirect.isServer());
    }

    public void setRefresh(RefreshSaga refresh) {
        if (refresh == null) {
            return;
        }
        this.refresh = refresh;
    }

    @Override
    public boolean isIdentical(CompileContext<CompiledObject, N2oObject> obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActionContext that = (ActionContext)obj;
        return super.isIdentical(that) && Objects.equals(this.operationId, that.operationId) && Objects.equals(this.validations, that.validations) && Objects.equals(this.parentPageId, that.parentPageId) && Objects.equals(this.parentClientWidgetId, that.parentClientWidgetId) && Objects.equals(this.parentSourceDatasourceId, that.parentSourceDatasourceId) && Objects.equals(this.messagesForm, that.messagesForm) && Objects.equals(this.clearDatasource, that.clearDatasource) && Objects.equals(this.redirect, that.redirect) && Objects.equals(this.refresh, that.refresh) && this.messageOnSuccess == that.messageOnSuccess && this.messageOnFail == that.messageOnFail && this.useFailOut == that.useFailOut && this.messagePosition == that.messagePosition && this.messagePlacement == that.messagePlacement && Objects.equals(this.operationMapping, that.operationMapping);
    }

    public String getOperationId() {
        return this.operationId;
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    public String getParentClientWidgetId() {
        return this.parentClientWidgetId;
    }

    public String getParentSourceDatasourceId() {
        return this.parentSourceDatasourceId;
    }

    public String getMessagesForm() {
        return this.messagesForm;
    }

    public String getClearDatasource() {
        return this.clearDatasource;
    }

    public String getPollingEndCondition() {
        return this.pollingEndCondition;
    }

    public PollingSaga getPolling() {
        return this.polling;
    }

    public LoadingSaga getLoading() {
        return this.loading;
    }

    public RedirectSaga getRedirect() {
        return this.redirect;
    }

    public RefreshSaga getRefresh() {
        return this.refresh;
    }

    public boolean isMessageOnSuccess() {
        return this.messageOnSuccess;
    }

    public boolean isMessageOnFail() {
        return this.messageOnFail;
    }

    public boolean isUseFailOut() {
        return this.useFailOut;
    }

    public MessagePosition getMessagePosition() {
        return this.messagePosition;
    }

    public MessagePlacement getMessagePlacement() {
        return this.messagePlacement;
    }

    public Map<String, String> getOperationMapping() {
        return this.operationMapping;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    public void setParentPageId(String parentPageId) {
        this.parentPageId = parentPageId;
    }

    public void setParentClientWidgetId(String parentClientWidgetId) {
        this.parentClientWidgetId = parentClientWidgetId;
    }

    public void setParentSourceDatasourceId(String parentSourceDatasourceId) {
        this.parentSourceDatasourceId = parentSourceDatasourceId;
    }

    public void setMessagesForm(String messagesForm) {
        this.messagesForm = messagesForm;
    }

    public void setClearDatasource(String clearDatasource) {
        this.clearDatasource = clearDatasource;
    }

    public void setPollingEndCondition(String pollingEndCondition) {
        this.pollingEndCondition = pollingEndCondition;
    }

    public void setPolling(PollingSaga polling) {
        this.polling = polling;
    }

    public void setLoading(LoadingSaga loading) {
        this.loading = loading;
    }

    public void setMessageOnSuccess(boolean messageOnSuccess) {
        this.messageOnSuccess = messageOnSuccess;
    }

    public void setMessageOnFail(boolean messageOnFail) {
        this.messageOnFail = messageOnFail;
    }

    public void setUseFailOut(boolean useFailOut) {
        this.useFailOut = useFailOut;
    }

    public void setMessagePosition(MessagePosition messagePosition) {
        this.messagePosition = messagePosition;
    }

    public void setMessagePlacement(MessagePlacement messagePlacement) {
        this.messagePlacement = messagePlacement;
    }

    public void setOperationMapping(Map<String, String> operationMapping) {
        this.operationMapping = operationMapping;
    }
}

