/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.cell;

import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oActionCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oImageCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oImageStatusElement;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.cell.ActionCell;
import net.n2oapp.framework.api.metadata.meta.cell.ImageCell;
import net.n2oapp.framework.api.metadata.meta.cell.ImageStatusElement;
import net.n2oapp.framework.api.metadata.meta.cell.ImageStatusElementPlace;
import net.n2oapp.framework.config.metadata.compile.cell.AbstractCellCompiler;
import org.springframework.stereotype.Component;

@Component
public class ImageCellCompiler
extends AbstractCellCompiler<ImageCell, N2oImageCell> {
    public Class<? extends Source> getSourceClass() {
        return N2oImageCell.class;
    }

    public ImageCell compile(N2oImageCell source, CompileContext<?, ?> context, CompileProcessor p) {
        ImageCell cell = new ImageCell();
        this.build(cell, source, context, p, Placeholders.property((String)"n2o.api.cell.image.src"));
        cell.setShape((ShapeType)CompileUtil.castDefault((Object)source.getShape(), (Supplier[])new Supplier[]{() -> (ShapeType)p.resolve(Placeholders.property((String)"n2o.api.cell.image.shape"), ShapeType.class)}));
        cell.setWidth(StringUtils.prepareSizeAttribute((String)((String)CompileUtil.castDefault((Object)source.getWidth(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.cell.image.width"), String.class)}))));
        this.compileAction((ActionCell)cell, (N2oActionCell)source, context, p);
        cell.setTitle(p.resolveJS(source.getTitle()));
        cell.setDescription(p.resolveJS(source.getDescription()));
        cell.setData(p.resolveJS(source.getData()));
        cell.setTextPosition((N2oImageCell.Position)CompileUtil.castDefault((Object)source.getTextPosition(), (Supplier[])new Supplier[]{() -> (N2oImageCell.Position)p.resolve(Placeholders.property((String)"n2o.api.cell.image.text_position"), N2oImageCell.Position.class)}));
        cell.setStatuses(this.compileStatuses(source.getStatuses(), p));
        return cell;
    }

    private ImageStatusElement[] compileStatuses(N2oImageStatusElement[] statuses, CompileProcessor p) {
        if (statuses == null) {
            return null;
        }
        int i = 0;
        ImageStatusElement[] statusElements = new ImageStatusElement[statuses.length];
        for (N2oImageStatusElement e : statuses) {
            ImageStatusElement statusElement = new ImageStatusElement();
            statusElement.setSrc((String)CompileUtil.castDefault((Object)e.getSrc(), (Object)"Status", (Object[])new String[0]));
            statusElement.setFieldId(e.getFieldId());
            statusElement.setIcon(p.resolveJS(e.getIcon()));
            statusElement.setPlace((ImageStatusElementPlace)CompileUtil.castDefault((Object)e.getPlace(), (Supplier[])new Supplier[]{() -> (ImageStatusElementPlace)p.resolve(Placeholders.property((String)"n2o.api.cell.image.status_place"), ImageStatusElementPlace.class)}));
            statusElements[i++] = statusElement;
        }
        return statusElements;
    }
}

