/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.application;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.application.Application;
import net.n2oapp.framework.api.metadata.application.Footer;
import net.n2oapp.framework.api.metadata.application.Logo;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.application.N2oFooter;
import net.n2oapp.framework.api.metadata.application.N2oSidebar;
import net.n2oapp.framework.api.metadata.application.NavigationLayout;
import net.n2oapp.framework.api.metadata.application.Sidebar;
import net.n2oapp.framework.api.metadata.application.SidebarState;
import net.n2oapp.framework.api.metadata.application.StompDatasource;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.datasource.AbstractDatasource;
import net.n2oapp.framework.api.metadata.event.N2oAbstractEvent;
import net.n2oapp.framework.api.metadata.header.Header;
import net.n2oapp.framework.api.metadata.header.N2oHeader;
import net.n2oapp.framework.api.metadata.header.SearchBar;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.event.Event;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCompiler
implements BaseSourceCompiler<Application, N2oApplication, ApplicationContext>,
SourceClassAware {
    public Application compile(N2oApplication source, ApplicationContext context, CompileProcessor p) {
        Application application = new Application();
        this.initWelcomePage(source, p);
        Application.Layout layout = new Application.Layout();
        layout.setFixed((Boolean)CompileUtil.castDefault((Object)source.getNavigationLayoutFixed(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.application.navigation_layout_fixed"), Boolean.class)}));
        NavigationLayout navLayout = (NavigationLayout)CompileUtil.castDefault((Object)source.getNavigationLayout(), (Supplier[])new Supplier[]{() -> (NavigationLayout)p.resolve(Placeholders.property((String)"n2o.application.navigation_layout"), NavigationLayout.class)});
        layout.setFullSizeHeader(Boolean.valueOf(navLayout.equals((Object)NavigationLayout.fullSizeHeader)));
        application.setLayout(layout);
        DataSourcesScope dataSourcesScope = this.initDatasourcesScope(source.getDatasources());
        Header header = this.initHeader(source.getHeader(), context, dataSourcesScope, p);
        application.setHeader(header);
        application.setSidebars(this.collectSidebars(source.getSidebars(), header, context, dataSourcesScope, p));
        application.setFooter(this.initFooter(source.getFooter(), p));
        application.setEvents(this.initEvents(source.getEvents(), context, p));
        application.setWsPrefix(this.initWsPrefix(application.getDatasources(), application.getEvents(), p));
        application.setDatasources(this.initDatasources(dataSourcesScope, context, p));
        return application;
    }

    private List<Sidebar> collectSidebars(N2oSidebar[] sidebars, Header header, ApplicationContext context, DataSourcesScope dataSourcesScope, CompileProcessor p) {
        if (sidebars == null) {
            return null;
        }
        ArrayList<Sidebar> result = new ArrayList<Sidebar>();
        for (N2oSidebar n2oSidebar : sidebars) {
            Sidebar sidebar = this.initSidebar(n2oSidebar, header, context, dataSourcesScope, p);
            result.add(sidebar);
        }
        return result;
    }

    private DataSourcesScope initDatasourcesScope(N2oAbstractDatasource[] datasources) {
        DataSourcesScope scope = new DataSourcesScope();
        if (datasources == null) {
            return scope;
        }
        for (N2oAbstractDatasource datasource : datasources) {
            scope.put(datasource.getId(), datasource);
        }
        return scope;
    }

    private Header initHeader(N2oHeader source, ApplicationContext context, DataSourcesScope dataSourcesScope, CompileProcessor p) {
        if (source == null) {
            return null;
        }
        Header header = new Header();
        header.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.header.src"), String.class)}));
        header.setClassName(source.getCssClass());
        header.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        if (source.getDatasourceId() != null) {
            N2oAbstractDatasource datasource = (N2oAbstractDatasource)dataSourcesScope.get(source.getDatasourceId());
            if (datasource != null) {
                datasource.setSize((Integer)p.resolve(Placeholders.property((String)"n2o.api.header.size"), Integer.class));
            }
            header.setDatasource(source.getDatasourceId());
        }
        Logo logo = new Logo();
        logo.setTitle(p.resolveJS(source.getTitle()));
        logo.setSrc(source.getLogoSrc());
        logo.setHref(source.getHomePageUrl());
        header.setLogo(logo);
        ComponentScope componentScope = new ComponentScope(source);
        header.setMenu(source.getMenu() != null ? (SimpleMenu)p.compile((Object)source.getMenu(), (CompileContext)context, new Object[]{dataSourcesScope, componentScope}) : new SimpleMenu());
        header.setExtraMenu(source.getExtraMenu() != null ? (SimpleMenu)p.compile((Object)source.getExtraMenu(), (CompileContext)context, new Object[]{dataSourcesScope, componentScope}) : new SimpleMenu());
        header.setSearch(source.getSearchBar() != null ? (SearchBar)p.compile((Object)source.getSearchBar(), (CompileContext)context, new Object[0]) : null);
        header.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        if (source.getSidebarIcon() != null || source.getSidebarToggledIcon() != null) {
            Header.SidebarSwitcher sidebarSwitcher = new Header.SidebarSwitcher();
            sidebarSwitcher.setIcon(source.getSidebarIcon());
            sidebarSwitcher.setToggledIcon((String)CompileUtil.castDefault((Object)source.getSidebarToggledIcon(), (Object)source.getSidebarIcon(), (Object[])new String[0]));
            header.setSidebarSwitcher(sidebarSwitcher);
        }
        return header;
    }

    private Sidebar initSidebar(N2oSidebar source, Header header, ApplicationContext context, DataSourcesScope dataSourcesScope, CompileProcessor p) {
        if (source == null) {
            return null;
        }
        Sidebar sidebar = (Sidebar)p.compile((Object)source, (CompileContext)context, new Object[]{dataSourcesScope});
        if (header != null && header.getSidebarSwitcher() != null) {
            sidebar.setDefaultState((SidebarState)CompileUtil.castDefault((Object)source.getDefaultState(), (Object)SidebarState.NONE, (Object[])new SidebarState[0]));
            sidebar.setToggledState((SidebarState)CompileUtil.castDefault((Object)source.getToggledState(), (Object)SidebarState.MAXI, (Object[])new SidebarState[0]));
        }
        return sidebar;
    }

    private Footer initFooter(N2oFooter source, CompileProcessor p) {
        if (source == null) {
            return null;
        }
        Footer footer = new Footer();
        footer.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.footer.src"), String.class)}));
        footer.setClassName(source.getCssClass());
        footer.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        footer.setTextLeft(p.resolveJS(source.getLeftText()));
        footer.setTextRight(p.resolveJS(source.getRightText()));
        footer.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        return footer;
    }

    private void initWelcomePage(N2oApplication source, CompileProcessor p) {
        String welcomePageId = (String)CompileUtil.castDefault((Object)source.getWelcomePageId(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.homepage.id"), String.class)});
        PageContext context = new PageContext(welcomePageId, "/");
        p.addRoute((CompileContext)context);
    }

    private Map<String, AbstractDatasource> initDatasources(DataSourcesScope dataSourcesScope, ApplicationContext context, CompileProcessor p) {
        HashMap<String, AbstractDatasource> result = new HashMap<String, AbstractDatasource>();
        dataSourcesScope.values().forEach(ds -> {
            AbstractDatasource compiled = (AbstractDatasource)p.compile(ds, (CompileContext)context, new Object[0]);
            result.put(compiled.getId(), compiled);
        });
        return result;
    }

    private List<Event> initEvents(N2oAbstractEvent[] source, ApplicationContext context, CompileProcessor p) {
        if (source == null) {
            return null;
        }
        ArrayList<Event> events = new ArrayList<Event>();
        for (N2oAbstractEvent e : source) {
            events.add((Event)p.compile((Object)e, (CompileContext)context, new Object[0]));
        }
        return events;
    }

    /*
     * Unable to fully structure code
     */
    private String initWsPrefix(Map<String, AbstractDatasource> datasources, List<Event> events, CompileProcessor p) {
        if (datasources == null) ** GOTO lbl-1000
        if (datasources.values().stream().anyMatch((Predicate<AbstractDatasource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lnet/n2oapp/framework/api/metadata/datasource/AbstractDatasource;)Z)(StompDatasource.class))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = containsStompDs = false;
        }
        if (!containsStompDs && events == null) {
            return null;
        }
        return (String)p.resolve(Placeholders.property((String)"n2o.config.ws.endpoint"), String.class);
    }

    public Class<N2oApplication> getSourceClass() {
        return N2oApplication.class;
    }
}

