/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action.condition;

import net.n2oapp.framework.api.metadata.action.ifelse.N2oConditionBranch;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oElseBranchAction;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.condition.ConditionAction;
import net.n2oapp.framework.api.metadata.meta.action.condition.ConditionActionPayload;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.action.condition.ConditionBranchesScope;

public abstract class BaseConditionActionCompiler<S extends N2oConditionBranch>
extends AbstractActionCompiler<ConditionAction, S> {
    public ConditionAction compile(S source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        PageIndexScope indexScope = (PageIndexScope)p.getScope(PageIndexScope.class);
        this.setBranchId((N2oConditionBranch)source, indexScope);
        ConditionAction conditionAction = new ConditionAction();
        conditionAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.condition.type"), String.class));
        ConditionBranchesScope failBranchesScope = (ConditionBranchesScope)p.getScope(ConditionBranchesScope.class);
        this.compilePayload((N2oConditionBranch)source, (ConditionActionPayload)conditionAction.getPayload(), failBranchesScope, context, p, indexScope);
        this.compileAction(conditionAction, source, p);
        return conditionAction;
    }

    protected void compilePayload(N2oConditionBranch source, ConditionActionPayload payload, ConditionBranchesScope failBranchesScope, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope indexScope) {
        payload.setCondition(source.getTest());
        payload.setSuccess(this.compileSuccess(source, context, p, indexScope));
        payload.setFail(this.compileFail(payload, failBranchesScope, context, p, indexScope));
    }

    protected void setFromScope(ConditionActionPayload payload, ConditionBranchesScope failBranchesScope) {
        payload.setDatasource(failBranchesScope.getDatasourceId());
        payload.setModel(failBranchesScope.getModel());
    }

    private Action compileFail(ConditionActionPayload compiled, ConditionBranchesScope failBranchesScope, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope indexScope) {
        N2oConditionBranch branch = failBranchesScope.pop();
        if (branch == null) {
            return null;
        }
        if (branch instanceof N2oElseBranchAction) {
            this.setBranchId(branch, indexScope);
            return this.compileActionAware(branch, context, p, indexScope);
        }
        return (Action)p.compile((Object)branch, context, new Object[]{new ConditionBranchesScope(failBranchesScope, compiled.getDatasource(), compiled.getModel()), indexScope});
    }

    private Action compileSuccess(N2oConditionBranch source, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope indexScope) {
        return this.compileActionAware(source, context, p, indexScope);
    }

    private Action compileActionAware(N2oConditionBranch source, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope indexScope) {
        ActionCompileStaticProcessor.initActions((ActionsAware)source, p);
        return ActionCompileStaticProcessor.compileAction((ActionsAware)source, context, p, null, indexScope);
    }

    private void setBranchId(N2oConditionBranch branch, PageIndexScope indexScope) {
        branch.setId("condition_" + indexScope.get());
    }
}

