/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.ModalSize;
import net.n2oapp.framework.api.metadata.action.N2oShowModal;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.modal.show_modal.ShowModal;
import net.n2oapp.framework.api.metadata.meta.action.modal.show_modal.ShowModalPayload;
import net.n2oapp.framework.config.metadata.compile.action.AbstractModalCompiler;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class ShowModalCompiler
extends AbstractModalCompiler<ShowModal, N2oShowModal> {
    public Class<? extends Source> getSourceClass() {
        return N2oShowModal.class;
    }

    public ShowModal compile(N2oShowModal source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        ShowModal showModal = new ShowModal();
        this.compileModal(source, showModal, context, p);
        showModal.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.type"), String.class));
        return showModal;
    }

    @Override
    protected void compilePayload(N2oShowModal source, ShowModal showModal, PageContext pageContext, CompileProcessor p) {
        ShowModalPayload payload = (ShowModalPayload)showModal.getPayload();
        payload.setSize((ModalSize)CompileUtil.castDefault((Object)source.getModalSize(), (Supplier[])new Supplier[]{() -> (ModalSize)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.size"), ModalSize.class)}));
        payload.setScrollable((Boolean)CompileUtil.castDefault((Object)source.getScrollable(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.scrollable"), Boolean.class)}));
        payload.setCloseButton(Boolean.valueOf(true));
        payload.setPrompt(pageContext.getUnsavedDataPromptOnClose());
        payload.setHasHeader((Boolean)CompileUtil.castDefault((Object)source.getHasHeader(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.has_header"), Boolean.class)}));
        payload.setClassName(source.getClassName());
        String backdrop = (String)CompileUtil.castDefault((Object)source.getBackdrop(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.action.show_modal.backdrop"), String.class)});
        payload.setBackdrop("true".equals(backdrop) || "false".equals(backdrop) ? Boolean.valueOf(backdrop) : backdrop);
        payload.setStyle(StylesResolver.resolveStyles(source.getStyle()));
    }
}

