/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.AsyncMetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractMetaActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class InvokeActionCompiler
extends AbstractMetaActionCompiler<InvokeAction, N2oInvokeAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oInvokeAction.class;
    }

    public InvokeAction compile(N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        InvokeAction invokeAction = new InvokeAction();
        this.compileAction(invokeAction, source, p);
        invokeAction.setOperationId(source.getOperationId());
        invokeAction.setType(this.getType(p));
        ((InvokeActionPayload)invokeAction.getPayload()).setModel(this.getModelFromComponentScope(p));
        ((InvokeActionPayload)invokeAction.getPayload()).setDatasource(DatasourceUtil.getClientDatasourceId(this.getLocalDatasourceId(p), p));
        ((InvokeActionPayload)invokeAction.getPayload()).setWidgetId(DatasourceUtil.getClientDatasourceId(ClientDataProviderUtil.getWidgetIdByComponentScope(p), p));
        ((InvokeActionPayload)invokeAction.getPayload()).setPageId(this.getPageId(p));
        ((AsyncMetaSaga)invokeAction.getMeta()).setSuccess(this.initSuccessMeta(invokeAction, source, context, p));
        ((AsyncMetaSaga)invokeAction.getMeta()).setFail(this.initFailMeta(invokeAction, source, context));
        this.initDataProvider(invokeAction, source, context, p);
        return invokeAction;
    }

    @Override
    protected MetaSaga initSuccessMeta(InvokeAction compiled, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p) {
        MetaSaga metaSaga = super.initSuccessMeta(compiled, source, context, p);
        metaSaga.setMessageWidgetId(this.getMessageWidgetId(compiled, context, source.getCloseOnSuccess() != false || source.getDoubleCloseOnSuccess() != false));
        this.initClear(source, p, metaSaga);
        return metaSaga;
    }

    @Override
    protected MetaSaga initFailMeta(InvokeAction compiled, N2oInvokeAction source, CompileContext<?, ?> context) {
        MetaSaga metaSaga = super.initFailMeta(compiled, source, context);
        metaSaga.setMessageWidgetId(((InvokeActionPayload)compiled.getPayload()).getWidgetId());
        return metaSaga;
    }

    private String getType(CompileProcessor p) {
        return (String)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.type"), String.class);
    }

    @Override
    protected void initDefaults(N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p) {
        super.initDefaults(source, context, p);
        source.setRoute((String)CompileUtil.castDefault((Object)RouteUtil.normalize(source.getRoute()), (Object)("/" + source.getId()), (Object[])new String[0]));
        this.initSubmitMessageDefaults(source);
        source.setOptimistic((Boolean)CompileUtil.castDefault((Object)source.getOptimistic(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.optimistic"), Boolean.class)}));
        source.setSubmitAll((Boolean)CompileUtil.castDefault((Object)source.getSubmitAll(), (Object)true, (Object[])new Boolean[0]));
        source.setMethod((RequestMethod)CompileUtil.castDefault((Object)source.getMethod(), (Supplier[])new Supplier[]{() -> (RequestMethod)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.method"), RequestMethod.class)}));
        source.setClearOnSuccess((Boolean)CompileUtil.castDefault((Object)source.getClearOnSuccess(), (Object)false, (Object[])new Boolean[0]));
    }

    private void initSubmitMessageDefaults(N2oInvokeAction source) {
        source.setMessageOnSuccess((Boolean)CompileUtil.castDefault((Object)source.getMessageOnSuccess(), (Object)true, (Object[])new Boolean[0]));
        source.setMessageOnFail((Boolean)CompileUtil.castDefault((Object)source.getMessageOnFail(), (Object)true, (Object[])new Boolean[0]));
        source.setUseFailOut((Boolean)CompileUtil.castDefault((Object)source.getUseFailOut(), (Object)true, (Object[])new Boolean[0]));
    }

    private String getMessageWidgetId(InvokeAction compiled, CompileContext<?, ?> context, boolean closeOnSuccess) {
        if (closeOnSuccess && context instanceof PageContext) {
            return ((PageContext)context).getParentClientWidgetId();
        }
        return ((InvokeActionPayload)compiled.getPayload()).getWidgetId();
    }

    private void initDataProvider(InvokeAction invokeAction, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p) {
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        dataProvider.setId(source.getId());
        dataProvider.setOptimistic(source.getOptimistic());
        dataProvider.setTargetModel(this.getModelFromComponentScope(p));
        dataProvider.setDatasourceId(this.getLocalDatasourceId(p));
        dataProvider.setClientDatasourceId(DatasourceUtil.getClientDatasourceId(dataProvider.getDatasourceId(), p));
        this.validatePathAndRoute(source, routeScope);
        dataProvider.setPathParams(source.getPathParams());
        dataProvider.setFormParams(source.getFormParams());
        dataProvider.setHeaderParams(source.getHeaderParams());
        dataProvider.setMethod(source.getMethod());
        dataProvider.setUrl(RouteUtil.normalize(source.getRoute()));
        dataProvider.setSubmitForm(source.getSubmitAll());
        CompiledObject compiledObject = this.getObject(source, p);
        invokeAction.setObjectId(compiledObject.getId());
        AsyncMetaSaga metaSaga = (AsyncMetaSaga)invokeAction.getMeta();
        N2oClientDataProvider.ActionContextData actionContextData = new N2oClientDataProvider.ActionContextData();
        actionContextData.setObjectId(compiledObject.getId());
        actionContextData.setOperationId(source.getOperationId());
        this.checkOperationIdExistence(actionContextData, compiledObject);
        actionContextData.setClearDatasource(metaSaga.getSuccess().getClear());
        actionContextData.setRedirect(this.initServerRedirect(metaSaga));
        actionContextData.setRefresh(metaSaga.getSuccess().getRefresh());
        actionContextData.setParentWidgetId(metaSaga.getSuccess().getMessageWidgetId());
        actionContextData.setMessagesForm(metaSaga.getFail().getMessageWidgetId());
        actionContextData.setMessageOnSuccess(source.getMessageOnSuccess().booleanValue());
        actionContextData.setMessageOnFail(source.getMessageOnFail().booleanValue());
        actionContextData.setUseFailOut(source.getUseFailOut().booleanValue());
        actionContextData.setMessagePosition(source.getMessagePosition());
        actionContextData.setMessagePlacement(source.getMessagePlacement());
        actionContextData.setOperation((CompiledObject.Operation)compiledObject.getOperations().get(source.getOperationId()));
        dataProvider.setActionContextData(actionContextData);
        ClientDataProvider compiledDataProvider = ClientDataProviderUtil.compile(dataProvider, context, p);
        if (Objects.nonNull(routeScope) && Objects.nonNull(compiledDataProvider.getPathMapping())) {
            compiledDataProvider.getPathMapping().putAll(routeScope.getPathMapping());
        }
        ((InvokeActionPayload)invokeAction.getPayload()).setDataProvider(compiledDataProvider);
    }

    private CompiledObject getObject(N2oInvokeAction source, CompileProcessor p) {
        if (Objects.nonNull(source.getObjectId())) {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId()));
        }
        CompiledObject compiledObject = null;
        String localDatasource = this.getLocalDatasourceId(p);
        DataSourcesScope dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
        if (Objects.nonNull(localDatasource) && Objects.nonNull(dataSourcesScope) && dataSourcesScope.get(localDatasource) instanceof N2oStandardDatasource) {
            N2oStandardDatasource datasource = (N2oStandardDatasource)dataSourcesScope.get(localDatasource);
            String objectId = datasource.getObjectId();
            if (Objects.nonNull(objectId)) {
                return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(objectId));
            }
            if (Objects.nonNull(datasource.getQueryId())) {
                compiledObject = ((CompiledQuery)p.getCompiled((CompileContext)new QueryContext(datasource.getQueryId()))).getObject();
            }
        }
        if (Objects.isNull(compiledObject)) {
            compiledObject = (CompiledObject)p.getScope(CompiledObject.class);
        }
        if (Objects.isNull(compiledObject)) {
            throw new N2oException(String.format("\u0412 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438 \"<invoke>\" \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 'object-id' \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 '%s'", source.getOperationId()));
        }
        return compiledObject;
    }

    private void validatePathAndRoute(N2oInvokeAction source, ParentRouteScope routeScope) {
        List<String> routeParams;
        String route = source.getRoute();
        N2oParam[] pathParams = source.getPathParams();
        List<String> list = routeParams = Objects.isNull(route) ? null : RouteUtil.getParams(route);
        if ((Objects.isNull(routeParams) || routeParams.isEmpty()) && (Objects.isNull(pathParams) || pathParams.length == 0)) {
            return;
        }
        if (Objects.isNull(routeParams) || routeParams.isEmpty()) {
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0435", pathParams[0].getName()));
        }
        if (Objects.isNull(pathParams) || pathParams.length == 0) {
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u0434\u043b\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 '%s' \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d", route, routeParams.get(0)));
        }
        for (N2oParam pathParam : pathParams) {
            String paramName = pathParam.getName();
            if (routeParams.stream().noneMatch(p -> p.equals(paramName))) {
                throw new N2oException(String.format("\u041c\u0430\u0440\u0448\u0440\u0443\u0442 '%s' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s'", route, paramName));
            }
            if (!Objects.nonNull(routeScope.getUrl()) || !RouteUtil.getParams(routeScope.getUrl()).contains(paramName)) continue;
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0432 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c 'url'", paramName));
        }
    }

    private void checkOperationIdExistence(N2oClientDataProvider.ActionContextData actionContextData, CompiledObject compiledObject) {
        String operationId = actionContextData.getOperationId();
        if (compiledObject.getOperations().keySet().stream().noneMatch(k -> k.equals(operationId))) {
            throw new N2oException(String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \"<invoke>\" \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e 'operation-id = %s' \u043e\u0431\u044a\u0435\u043a\u0442\u0430 '%s'", operationId, compiledObject.getId()));
        }
    }

    private void initClear(N2oInvokeAction source, CompileProcessor p, MetaSaga meta) {
        if (source.getClearOnSuccess().booleanValue()) {
            meta.setClear(DatasourceUtil.getClientDatasourceId(this.getLocalDatasourceId(p), p));
        }
    }

    private RedirectSaga initServerRedirect(AsyncMetaSaga meta) {
        boolean isServer = Objects.nonNull(meta) && Objects.nonNull(meta.getSuccess()) && Objects.nonNull(meta.getSuccess().getRedirect()) && meta.getSuccess().getRedirect().isServer();
        return isServer ? meta.getSuccess().getRedirect() : null;
    }
}

