/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAnchor;
import net.n2oapp.framework.api.metadata.action.N2oCloseAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.AbstractAction;
import net.n2oapp.framework.api.metadata.meta.action.ActionPayload;
import net.n2oapp.framework.api.metadata.meta.action.close.CloseAction;
import net.n2oapp.framework.api.metadata.meta.action.close.CloseActionPayload;
import net.n2oapp.framework.api.metadata.meta.action.link.LinkActionImpl;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.context.SubPageContext;
import org.springframework.stereotype.Component;

@Component
public class CloseActionCompiler
extends AbstractActionCompiler<AbstractAction, N2oCloseAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oCloseAction.class;
    }

    public AbstractAction compile(N2oCloseAction source, CompileContext<?, ?> context, CompileProcessor p) {
        if (context instanceof SubPageContext) {
            throw new N2oException(String.format("\u0412 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 '%s', \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0441\u0441\u044b\u043b\u0430\u044e\u0442\u0441\u044f \u0432 \u0440\u0435\u0433\u0438\u043e\u043d\u0435 \"<sub-page>\", \u043d\u0435\u043b\u044c\u0437\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \"<close>\"", ((SubPageContext)context).getPageName()));
        }
        return context instanceof ModalPageContext ? this.getCloseAction(source, context, p) : CloseActionCompiler.getLinkAction(source, context, p);
    }

    private static LinkActionImpl getLinkAction(N2oCloseAction source, CompileContext<?, ?> context, CompileProcessor p) {
        N2oAnchor anchor = new N2oAnchor();
        if (source.getRedirectUrl() != null) {
            anchor.setHref(source.getRedirectUrl());
            anchor.setTarget(source.getRedirectTarget());
        } else if (context instanceof PageContext) {
            PageContext pageContext = (PageContext)context;
            String backRoute = pageContext.getParentRoute();
            anchor.setHref((String)CompileUtil.castDefault((Object)backRoute, (Object)"/", (Object[])new String[0]));
            anchor.setTarget(Target.application);
        } else {
            anchor.setHref("/");
            anchor.setTarget(Target.application);
        }
        LinkActionImpl compiled = (LinkActionImpl)p.compile((Object)anchor, context, new Object[0]);
        compiled.setRestore(Boolean.TRUE);
        return compiled;
    }

    private CloseAction getCloseAction(N2oCloseAction source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        CloseAction closeAction = new CloseAction();
        this.compileAction(closeAction, source, p);
        closeAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.close.type"), String.class));
        closeAction.setMeta(this.initMeta(source, context, p));
        closeAction.setPayload((ActionPayload)CloseActionCompiler.initPayload(source, context));
        return closeAction;
    }

    private static CloseActionPayload initPayload(N2oCloseAction source, CompileContext<?, ?> context) {
        CloseActionPayload payload = new CloseActionPayload();
        if (context instanceof ModalPageContext) {
            ModalPageContext modalPageContext = (ModalPageContext)context;
            payload.setPageId(((PageContext)context).getClientPageId());
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = modalPageContext::getUnsavedDataPromptOnClose;
            supplierArray[1] = () -> true;
            payload.setPrompt((Boolean)CompileUtil.castDefault((Object)source.getPrompt(), (Supplier[])supplierArray));
        }
        return payload;
    }

    private MetaSaga initMeta(N2oCloseAction source, CompileContext<?, ?> context, CompileProcessor p) {
        MetaSaga meta = new MetaSaga();
        boolean isRefreshable = (Boolean)CompileUtil.castDefault((Object)source.getRefresh(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.close.refresh_on_close"), Boolean.class)});
        if (source.getRedirectUrl() == null && context instanceof ModalPageContext) {
            meta.setModalsToClose(Integer.valueOf(1));
        }
        if (isRefreshable) {
            meta.setRefresh(new RefreshSaga());
            if (context instanceof PageContext) {
                PageContext pageContext = (PageContext)context;
                meta.getRefresh().setDatasources(pageContext.getRefreshClientDataSourceIds());
            }
        }
        if (source.getRedirectUrl() != null) {
            meta.setRedirect(new RedirectSaga());
            meta.getRedirect().setPath(source.getRedirectUrl());
            meta.getRedirect().setTarget(source.getRedirectTarget());
        }
        return meta;
    }
}

