/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.action.N2oAbstractMetaAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;

public abstract class AbstractMetaActionCompiler<D extends Action, S extends N2oAbstractMetaAction>
extends AbstractActionCompiler<D, S> {
    @Override
    protected void initDefaults(S source, CompileContext<?, ?> context, CompileProcessor p) {
        super.initDefaults(source, context, p);
        source.setDoubleCloseOnSuccess((Boolean)CompileUtil.castDefault((Object)source.getDoubleCloseOnSuccess(), (Object)false, (Object[])new Boolean[0]));
        source.setCloseOnSuccess(Boolean.valueOf(source.getDoubleCloseOnSuccess() != false || (Boolean)CompileUtil.castDefault((Object)source.getCloseOnSuccess(), (Object)false, (Object[])new Boolean[0]) != false));
        source.setCloseOnFail((Boolean)CompileUtil.castDefault((Object)source.getCloseOnFail(), (Object)false, (Object[])new Boolean[0]));
        source.setRefreshOnSuccess((Boolean)CompileUtil.castDefault((Object)source.getRefreshOnSuccess(), (Object)true, (Object[])new Boolean[0]));
        source.setRefreshDatasourceIds(this.initRefreshDatasources((N2oAbstractMetaAction)source, p));
    }

    protected MetaSaga initSuccessMeta(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
        MetaSaga meta = new MetaSaga();
        boolean redirect = source.getRedirectUrl() != null;
        boolean doubleCloseOnSuccess = source.getDoubleCloseOnSuccess();
        boolean closeOnSuccess = source.getCloseOnSuccess() != false || doubleCloseOnSuccess;
        this.initCloseOnSuccess(context, meta, redirect, doubleCloseOnSuccess, closeOnSuccess);
        this.initRefreshOnClose(source, context, p, meta, closeOnSuccess);
        this.initRedirect(source, context, p, meta, redirect, doubleCloseOnSuccess);
        return meta;
    }

    protected MetaSaga initFailMeta(D compiled, S source, CompileContext<?, ?> context) {
        MetaSaga metaSaga = new MetaSaga();
        if (Boolean.TRUE.equals(source.getCloseOnFail()) && context instanceof ModalPageContext) {
            metaSaga.setModalsToClose(Integer.valueOf(1));
        }
        return metaSaga;
    }

    private void initCloseOnSuccess(CompileContext<?, ?> context, MetaSaga meta, boolean redirect, boolean doubleCloseOnSuccess, boolean closeOnSuccess) {
        if (closeOnSuccess) {
            if (context instanceof ModalPageContext) {
                meta.setModalsToClose(Integer.valueOf(doubleCloseOnSuccess ? 2 : 1));
            } else if (!redirect) {
                String backRoute;
                if (context instanceof PageContext) {
                    PageContext pageContext = (PageContext)context;
                    backRoute = pageContext.getParentRoute();
                } else {
                    backRoute = "/";
                }
                meta.setRedirect(new RedirectSaga());
                meta.getRedirect().setPath(backRoute);
                meta.getRedirect().setTarget(Target.application);
            }
        }
    }

    private void initRefreshOnClose(S source, CompileContext<?, ?> context, CompileProcessor p, MetaSaga meta, boolean closeOnSuccess) {
        if (Boolean.TRUE.equals(source.getRefreshOnSuccess())) {
            meta.setRefresh(new RefreshSaga());
            if (!closeOnSuccess && source.getRefreshDatasourceIds() != null) {
                PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                if (pageScope != null) {
                    meta.getRefresh().setDatasources(DatasourceUtil.getClientDatasourceIds(Arrays.asList(source.getRefreshDatasourceIds()), p));
                }
            } else if (closeOnSuccess && PageContext.class.isAssignableFrom(context.getClass()) && ((PageContext)context).getRefreshClientDataSourceIds() != null) {
                meta.getRefresh().setDatasources(((PageContext)context).getRefreshClientDataSourceIds());
            }
        }
    }

    private void initRedirect(S source, CompileContext<?, ?> context, CompileProcessor p, MetaSaga meta, boolean redirect, boolean doubleCloseOnSuccess) {
        if (redirect) {
            if (context instanceof ModalPageContext) {
                meta.setModalsToClose(Integer.valueOf(doubleCloseOnSuccess ? 2 : 1));
            }
            meta.setRedirect(new RedirectSaga());
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            meta.getRedirect().setPath(RouteUtil.absolute(source.getRedirectUrl(), routeScope != null ? routeScope.getUrl() : null));
            meta.getRedirect().setTarget(source.getRedirectTarget());
            meta.getRedirect().setServer(true);
        }
    }

    private String[] initRefreshDatasources(N2oAbstractMetaAction source, CompileProcessor p) {
        if (source.getRefreshDatasourceIds() != null) {
            return source.getRefreshDatasourceIds();
        }
        String localDatasource = this.getLocalDatasourceId(p);
        if (localDatasource != null) {
            return new String[]{localDatasource};
        }
        return null;
    }
}

