/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;

public abstract class AbstractActionCompiler<D extends Action, S extends N2oAction>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    public void compileAction(D compiled, S source, CompileProcessor p) {
        compiled.setProperties(p.mapAttributes(source));
    }

    protected void initDefaults(S source, CompileContext<?, ?> context, CompileProcessor p) {
        source.setId(this.initId(source, p));
    }

    protected String initId(S source, CompileProcessor p) {
        ComponentScope componentScope;
        if (source.getId() == null && (componentScope = (ComponentScope)p.getScope(ComponentScope.class)) != null) {
            IdAware component = componentScope.unwrap(IdAware.class);
            if (component != null) {
                return component.getId();
            }
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            if (widgetScope != null) {
                return widgetScope.getClientWidgetId() + "_row";
            }
        }
        return source.getId();
    }

    protected ReduxModel getModelFromComponentScope(CompileProcessor p) {
        ModelAware modelAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (modelAware = componentScope.unwrap(ModelAware.class)) != null && modelAware.getModel() != null) {
            return modelAware.getModel();
        }
        return ReduxModel.resolve;
    }

    protected String getPageId(CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (pageScope != null) {
            return pageScope.getPageId();
        }
        return null;
    }

    protected Map<String, ModelLink> initParentRoutePathMappings(ParentRouteScope routeScope, String url) {
        HashMap<String, ModelLink> parentRoutePathMappings = new HashMap<String, ModelLink>();
        if (routeScope != null && routeScope.getPathMapping() != null) {
            List<String> pathParams = RouteUtil.getParams(url);
            routeScope.getPathMapping().forEach((k, v) -> {
                if (pathParams.contains(k)) {
                    parentRoutePathMappings.put((String)k, (ModelLink)v);
                }
            });
        }
        return parentRoutePathMappings;
    }

    protected void initMappings(N2oParam[] pathParams, N2oParam[] queryParams, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping, CompileProcessor p) {
        block8: {
            ReduxModel defaultModel;
            block7: {
                WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
                defaultModel = this.getModelFromComponentScope(p);
                if (widgetScope == null) break block7;
                String defaultClientWidgetId = this.getDefaultClientWidgetId(p);
                if (pathParams != null) {
                    for (N2oParam pathParam : pathParams) {
                        pathMapping.put(pathParam.getName(), this.initParamModelLink(pathParam, defaultClientWidgetId, defaultModel, p));
                    }
                }
                if (queryParams == null) break block8;
                for (N2oParam queryParam : queryParams) {
                    queryMapping.put(queryParam.getName(), this.initParamModelLink(queryParam, defaultClientWidgetId, defaultModel, p));
                }
                break block8;
            }
            if (pathParams != null) {
                for (N2oParam pathParam : pathParams) {
                    pathMapping.put(pathParam.getName(), this.initParamModelLink(pathParam, null, defaultModel, p));
                }
            }
            if (queryParams != null) {
                for (N2oParam queryParam : queryParams) {
                    queryMapping.put(queryParam.getName(), this.initParamModelLink(queryParam, null, defaultModel, p));
                }
            }
        }
    }

    protected String getLocalDatasourceId(CompileProcessor p) {
        String datasourceId = ComponentScope.getFirstNotNull((ComponentScope)p.getScope(ComponentScope.class), DatasourceIdAware.class, DatasourceIdAware::getDatasourceId);
        if (datasourceId != null) {
            return datasourceId;
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getDatasourceId();
        }
        return null;
    }

    protected ReduxModel getLocalModel(CompileProcessor p) {
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        return (ReduxModel)CompileUtil.castDefault((Object)ComponentScope.getFirstNotNull(componentScope, ModelAware.class, ModelAware::getModel), (Object)ReduxModel.resolve, (Object[])new ReduxModel[0]);
    }

    private ModelLink initParamModelLink(N2oParam param, String defaultClientWidgetId, ReduxModel defaultModel, CompileProcessor p) {
        String clientDatasourceId;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String widgetId = (String)CompileUtil.castDefault((Object)DatasourceUtil.getClientDatasourceId(param.getRefWidgetId(), p), (Object)defaultClientWidgetId, (Object[])new String[0]);
        if (pageScope == null) {
            String string = clientDatasourceId = param.getDatasourceId() != null ? param.getDatasourceId() : widgetId;
            if (clientDatasourceId == null) {
                clientDatasourceId = this.getLocalDatasourceId(p);
            }
        } else {
            clientDatasourceId = DatasourceUtil.getClientDatasourceId(param.getDatasourceId() != null ? param.getDatasourceId() : this.getLocalDatasourceId(p), p);
        }
        ModelLink link = new ModelLink((ReduxModel)CompileUtil.castDefault((Object)param.getModel(), (Object)defaultModel, (Object[])new ReduxModel[0]), clientDatasourceId);
        link.setValue((Object)p.resolveJS(param.getValue()));
        return link;
    }

    private String getDefaultClientWidgetId(CompileProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String widgetIdByComponentScope = DatasourceUtil.getClientDatasourceId(ClientDataProviderUtil.getWidgetIdByComponentScope(p), p);
        return widgetIdByComponentScope != null ? widgetIdByComponentScope : widgetScope.getClientWidgetId();
    }
}

