/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.config.register.route.RouteUtil;

public class ParentRouteScope {
    private String url;
    private Map<String, ModelLink> pathMapping = new HashMap<String, ModelLink>();
    private Map<String, ModelLink> queryMapping = new LinkedHashMap<String, ModelLink>();

    public ParentRouteScope(String url) {
        this.url = url;
    }

    public ParentRouteScope(String url, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping) {
        this(url);
        if (pathMapping != null) {
            this.pathMapping.putAll(pathMapping);
        }
        if (queryMapping != null) {
            this.queryMapping.putAll(queryMapping);
        }
    }

    public ParentRouteScope(String route, ParentRouteScope parent) {
        this(RouteUtil.normalize(parent.getUrl() + route), parent.getPathMapping(), parent.getQueryMapping());
    }

    public ParentRouteScope(String route, Map<String, ModelLink> additionalPathMapping, Map<String, ModelLink> additionalQueryMapping, ParentRouteScope parent) {
        this(route, parent);
        if (additionalPathMapping != null) {
            this.pathMapping.putAll(additionalPathMapping);
        }
        if (additionalQueryMapping != null) {
            this.queryMapping.putAll(additionalQueryMapping);
        }
    }

    public String toString() {
        return this.queryMapping != null ? RouteUtil.addQueryParams(this.url, this.queryMapping) : this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, ModelLink> getPathMapping() {
        return this.pathMapping;
    }

    public Map<String, ModelLink> getQueryMapping() {
        return this.queryMapping;
    }
}

