/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.metadata.compile.SourceMerger;
import net.n2oapp.framework.api.metadata.compile.SourceMergerFactory;
import net.n2oapp.framework.config.factory.BaseMetadataFactory;
import net.n2oapp.framework.config.factory.FactoryPredicates;
import net.n2oapp.framework.config.metadata.compile.BaseSourceMerger;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.SerializationUtils;

public class N2oSourceMergerFactory
extends BaseMetadataFactory<SourceMerger<?>>
implements SourceMergerFactory {
    public N2oSourceMergerFactory() {
    }

    public N2oSourceMergerFactory(Map<String, SourceMerger<?>> beans) {
        super(beans);
    }

    public <S> S merge(S source, S override) {
        List<SourceMerger> mergers = this.produceList(FactoryPredicates::isSourceAssignableFrom, source);
        Object result = SerializationUtils.deserialize((byte[])SerializationUtils.serialize(source));
        for (SourceMerger merger : mergers) {
            SourceMerger castedMerger = merger;
            Class<?> mergerClass = this.getMergerClass(castedMerger);
            if (mergerClass == null || !mergerClass.isAssignableFrom(override.getClass())) continue;
            result = castedMerger.merge(result, override);
        }
        return (S)result;
    }

    private Class<?> getMergerClass(SourceMerger<?> merger) {
        return GenericTypeResolver.resolveTypeArgument(merger.getClass(), BaseSourceMerger.class);
    }
}

